/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.widgets;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.databinding.BindingAdapter;
import androidx.databinding.DataBindingUtil;
import com.sendbird.android.BaseMessage;
import com.sendbird.uikit.R;
import com.sendbird.uikit.databinding.SbViewTimeLineMessageComponentBinding;
import com.sendbird.uikit.utils.DateUtils;
import com.sendbird.uikit.widgets.BaseMessageView;

public class TimelineMessageView
extends BaseMessageView {
    private SbViewTimeLineMessageComponentBinding binding;

    @Override
    public SbViewTimeLineMessageComponentBinding getBinding() {
        return this.binding;
    }

    @Override
    public View getLayout() {
        return this.binding.getRoot();
    }

    public TimelineMessageView(Context context) {
        this(context, null);
    }

    public TimelineMessageView(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.sb_message_timeline_style);
    }

    public TimelineMessageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs, defStyle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs, int defStyle) {
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.MessageView, defStyle, 0);
        try {
            this.binding = (SbViewTimeLineMessageComponentBinding)DataBindingUtil.inflate((LayoutInflater)LayoutInflater.from((Context)this.getContext()), (int)R.layout.sb_view_time_line_message_component, (ViewGroup)this, (boolean)true);
            int textAppearance = a.getResourceId(R.styleable.MessageView_sb_message_timeline_text_appearance, R.style.SendbirdCaption1OnDark01);
            int backgroundResourceId = a.getResourceId(R.styleable.MessageView_sb_message_timeline_background, R.drawable.sb_shape_timeline_background);
            this.binding.tvTimeline.setTextAppearance(context, textAppearance);
            this.binding.tvTimeline.setBackgroundResource(backgroundResourceId);
        }
        finally {
            a.recycle();
        }
    }

    public void drawTimeline(BaseMessage message) {
        this.binding.tvTimeline.setText((CharSequence)DateUtils.formatDate(message.getCreatedAt()));
    }

    @BindingAdapter(value={"message"})
    public static void drawTimeline(TimelineMessageView view, BaseMessage message) {
        view.drawTimeline(message);
    }
}

