/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.fragments;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Intent;
import android.content.res.Configuration;
import android.net.Uri;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import androidx.databinding.DataBindingUtil;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import androidx.recyclerview.widget.RecyclerView;
import com.sendbird.android.BaseChannel;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.FileMessage;
import com.sendbird.android.FileMessageParams;
import com.sendbird.android.MessageListParams;
import com.sendbird.android.OpenChannel;
import com.sendbird.android.SendBird;
import com.sendbird.android.SendBirdException;
import com.sendbird.android.User;
import com.sendbird.android.UserMessage;
import com.sendbird.android.UserMessageParams;
import com.sendbird.uikit.R;
import com.sendbird.uikit.SendBirdUIKit;
import com.sendbird.uikit.activities.OpenChannelSettingsActivity;
import com.sendbird.uikit.activities.ParticipantsListActivity;
import com.sendbird.uikit.activities.PhotoViewActivity;
import com.sendbird.uikit.activities.adapter.OpenChannelMessageListAdapter;
import com.sendbird.uikit.activities.viewholder.MessageType;
import com.sendbird.uikit.activities.viewholder.MessageViewHolderFactory;
import com.sendbird.uikit.consts.KeyboardDisplayType;
import com.sendbird.uikit.databinding.SbFragmentOpenChannelBinding;
import com.sendbird.uikit.fragments.BaseOpenChannelFragment;
import com.sendbird.uikit.fragments.ItemAnimator;
import com.sendbird.uikit.fragments.MessageAnchorDialog;
import com.sendbird.uikit.fragments.PermissionFragment;
import com.sendbird.uikit.interfaces.CustomParamsHandler;
import com.sendbird.uikit.interfaces.LoadingDialogHandler;
import com.sendbird.uikit.interfaces.OnItemClickListener;
import com.sendbird.uikit.interfaces.OnItemLongClickListener;
import com.sendbird.uikit.interfaces.OnResultHandler;
import com.sendbird.uikit.log.Logger;
import com.sendbird.uikit.model.DialogListItem;
import com.sendbird.uikit.model.FileInfo;
import com.sendbird.uikit.tasks.JobResultTask;
import com.sendbird.uikit.tasks.TaskQueue;
import com.sendbird.uikit.utils.ChannelUtils;
import com.sendbird.uikit.utils.ContextUtils;
import com.sendbird.uikit.utils.DialogUtils;
import com.sendbird.uikit.utils.FileUtils;
import com.sendbird.uikit.utils.IntentUtils;
import com.sendbird.uikit.utils.MessageUtils;
import com.sendbird.uikit.utils.SoftInputUtils;
import com.sendbird.uikit.utils.TextUtils;
import com.sendbird.uikit.vm.FileDownloader;
import com.sendbird.uikit.vm.OpenChannelViewModel;
import com.sendbird.uikit.vm.ViewModelFactory;
import com.sendbird.uikit.widgets.PagerRecyclerView;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class OpenChannelFragment
extends BaseOpenChannelFragment
implements OnItemClickListener<BaseMessage>,
OnItemLongClickListener<BaseMessage>,
LoadingDialogHandler {
    private static final int CAPTURE_IMAGE_PERMISSIONS_REQUEST_CODE = 2001;
    private static final int PICK_IMAGE_PERMISSIONS_REQUEST_CODE = 2002;
    private static final int PICK_FILE_PERMISSIONS_REQUEST_CODE = 2003;
    private static final int GROUP_CHANNEL_SETTINGS_REQUEST_CODE = 2004;
    private static final int PERMISSION_REQUEST_ALL = 2005;
    private static final int PERMISSION_REQUEST_STORAGE = 2006;
    private SbFragmentOpenChannelBinding binding;
    private OpenChannelViewModel viewModel;
    private OpenChannelMessageListAdapter adapter;
    private String inputHint;
    private MessageAnchorDialog messageAnchorDialog;
    private Uri mediaUri;
    private long editMessageId;
    private boolean hasHeaderDescription;
    private View.OnClickListener headerLeftButtonListener;
    private View.OnClickListener headerRightButtonListener;
    private OnItemClickListener<BaseMessage> profileClickListener;
    private OnItemClickListener<BaseMessage> itemClickListener;
    private OnItemLongClickListener<BaseMessage> itemLongClickListener;
    private View.OnClickListener inputLeftButtonListener;
    private MessageListParams params;
    private LoadingDialogHandler loadingDialogHandler;
    final AtomicBoolean isInitialCall = new AtomicBoolean(true);

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Logger.i(">> OpenChannelFragment::onCreate()", new Object[0]);
        Bundle args = this.getArguments();
        int themeResId = SendBirdUIKit.getDefaultThemeMode().getResId();
        if (args != null) {
            themeResId = args.getInt("KEY_THEME_RES_ID", SendBirdUIKit.getDefaultThemeMode().getResId());
        }
        if (this.getActivity() != null) {
            this.getActivity().setTheme(themeResId);
        }
        if (this.loadingDialogHandler == null) {
            this.loadingDialogHandler = this;
        }
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        SendBird.setAutoBackgroundDetection((boolean)true);
        if (this.channel != null) {
            this.channel.exit(null);
        }
        if (this.isInitialCall.get()) {
            this.loadingDialogHandler.shouldDismissLoadingDialog();
        }
    }

    public void onConfigurationChanged(@NonNull Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        Logger.i(">> OpenChannelFragment::onConfigurationChanged(%s)", newConfig.orientation);
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        Logger.i(">> OpenChannelFragment::onCreateView()", new Object[0]);
        this.binding = (SbFragmentOpenChannelBinding)DataBindingUtil.inflate((LayoutInflater)inflater, (int)R.layout.sb_fragment_open_channel, (ViewGroup)container, (boolean)false);
        return this.binding.getRoot();
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.initHeaderOnCreated();
        this.loadingDialogHandler.shouldShowLoadingDialog();
    }

    @Override
    protected void onReadyFailure() {
        this.toastError(R.string.sb_text_error_connect_server);
        this.loadingDialogHandler.shouldDismissLoadingDialog();
    }

    @Override
    protected void onConfigure() {
        Logger.i(">> OpenChannelFragment::onConfigure() - %s", Logger.getCallerTraceInfo(OpenChannelFragment.class));
    }

    @Override
    protected void onDrawPage() {
        Logger.i(">> OpenChannelFragment::onDrawPage() - %s", Logger.getCallerTraceInfo(OpenChannelFragment.class));
        this.channel.enter(e -> {
            if (!this.isActive()) {
                return;
            }
            if (e != null) {
                this.toastError(R.string.sb_text_error_enter_channel);
                this.finish();
                return;
            }
            this.viewModel = this.createViewModel(this.channel);
            this.getLifecycle().addObserver((LifecycleObserver)this.viewModel);
            this.initHeaderOnReady(this.channel);
            this.initMessageList(this.channel);
            this.initMessageInput();
            this.drawChannel(this.channel);
        });
    }

    private OpenChannelViewModel createViewModel(OpenChannel channel) {
        return (OpenChannelViewModel)new ViewModelProvider((ViewModelStoreOwner)this.getActivity(), (ViewModelProvider.Factory)new ViewModelFactory(this, channel, this.params)).get(OpenChannelViewModel.class);
    }

    private void drawChannel(OpenChannel channel) {
        Logger.dev("++ drawChannel()");
        if (this.isActive()) {
            this.binding.chvChannelHeader.getTitleTextView().setText((CharSequence)channel.getName());
            ChannelUtils.loadChannelCover(this.binding.chvChannelHeader.getProfileView(), (BaseChannel)channel);
            this.drawMessageInput(channel);
            this.updateHeaderParticipantCount();
        }
    }

    private void drawMessageInput(OpenChannel channel) {
        boolean isEnabled;
        boolean isFrozen;
        boolean isOperator = channel.isOperator(SendBird.getCurrentUser());
        boolean isMuted = false;
        boolean bl = isFrozen = channel.isFrozen() && !isOperator;
        if (isMuted || isFrozen) {
            this.enableMessageInput(false, this.getResources().getString(isFrozen ? R.string.sb_text_channel_input_text_hint_frozen : R.string.sb_text_channel_input_text_hint_muted));
        } else {
            this.enableMessageInput(true, this.inputHint);
        }
        this.binding.tvInformation.setVisibility(channel.isFrozen() ? 0 : 8);
        this.binding.tvInformation.setText(R.string.sb_text_information_channel_frozen);
        boolean bl2 = isEnabled = !isMuted && !isFrozen;
        String hintText = isEnabled ? this.inputHint : this.getResources().getString(isMuted ? R.string.sb_text_channel_input_text_hint_muted : R.string.sb_text_channel_input_text_hint_frozen);
        Logger.dev("++ hint text : " + hintText);
        this.enableMessageInput(isEnabled, hintText);
    }

    private void enableMessageInput(boolean isEnable, String hintText) {
        this.binding.vgInputBox.setEnabled(isEnable);
        this.binding.vgInputBox.setInputTextHint(hintText);
        if (!isEnable) {
            this.finishEditMode();
        }
    }

    private void initHeaderOnCreated() {
        Bundle args = this.getArguments();
        boolean useHeader = false;
        boolean useHeaderLeftButton = false;
        boolean useHeaderRightButton = true;
        int headerLeftButtonIconResId = R.drawable.icon_arrow_left;
        String headerDescription = null;
        if (args != null) {
            useHeader = args.getBoolean("KEY_USE_HEADER", false);
            useHeaderLeftButton = args.getBoolean("KEY_USE_HEADER_LEFT_BUTTON", false);
            useHeaderRightButton = args.getBoolean("KEY_USE_HEADER_RIGHT_BUTTON", true);
            headerLeftButtonIconResId = args.getInt("KEY_HEADER_LEFT_BUTTON_ICON_RES_ID", R.drawable.icon_arrow_left);
            headerDescription = args.getString("KEY_HEADER_DESCRIPTION", null);
            this.hasHeaderDescription = args.containsKey("KEY_HEADER_DESCRIPTION");
        }
        this.binding.chvChannelHeader.setVisibility(useHeader ? 0 : 8);
        if (!TextUtils.isEmpty(headerDescription)) {
            this.binding.chvChannelHeader.getDescriptionTextView().setVisibility(0);
            this.binding.chvChannelHeader.getDescriptionTextView().setText(headerDescription);
        }
        this.binding.chvChannelHeader.setUseLeftImageButton(useHeaderLeftButton);
        this.binding.chvChannelHeader.getRightImageButton().setVisibility(useHeaderRightButton ? 0 : 8);
        this.binding.chvChannelHeader.getLeftImageButton().setImageResource(headerLeftButtonIconResId);
        this.binding.chvChannelHeader.getLeftImageButton().setOnClickListener(v -> this.finish());
    }

    private void initHeaderOnReady(OpenChannel channel) {
        Bundle args = this.getArguments();
        boolean isOperator = channel.isOperator(SendBird.getCurrentUser());
        int headerRightButtonIconResId = channel.isOperator(SendBird.getCurrentUser()) ? R.drawable.icon_info : R.drawable.icon_members;
        headerRightButtonIconResId = args != null ? args.getInt("KEY_HEADER_RIGHT_BUTTON_ICON_RES_ID", headerRightButtonIconResId) : headerRightButtonIconResId;
        this.binding.chvChannelHeader.getRightImageButton().setImageResource(headerRightButtonIconResId);
        if (this.headerLeftButtonListener != null) {
            this.binding.chvChannelHeader.getLeftImageButton().setOnClickListener(this.headerLeftButtonListener);
        }
        if (this.headerRightButtonListener != null) {
            this.binding.chvChannelHeader.getRightImageButton().setOnClickListener(this.headerRightButtonListener);
        } else {
            this.binding.chvChannelHeader.getRightImageButton().setOnClickListener(v -> {
                if (isOperator) {
                    Intent intent = OpenChannelSettingsActivity.newIntent(this.getContext(), channel.getUrl());
                    this.startActivityForResult(intent, 2004);
                } else {
                    this.startActivity(ParticipantsListActivity.newIntent(this.getContext(), channel.getUrl()));
                }
            });
        }
        this.binding.chvChannelHeader.getProfileView().setVisibility(0);
        this.viewModel.isChannelChanged().observe((LifecycleOwner)this, this::drawChannel);
        this.viewModel.getChannelDeleted().observe((LifecycleOwner)this, deleted -> this.finish());
        this.viewModel.getEnterFailed().observe((LifecycleOwner)this, failed -> {
            this.toastError(R.string.sb_text_error_enter_channel);
            this.finish();
        });
    }

    private void updateHeaderParticipantCount() {
        if (this.hasHeaderDescription) {
            return;
        }
        int count = this.channel.getParticipantCount();
        this.binding.chvChannelHeader.getDescriptionTextView().setVisibility(0);
        this.binding.chvChannelHeader.getDescriptionTextView().setText((CharSequence)String.format(this.getString(R.string.sb_text_header_participants_count), ChannelUtils.makeMemberCountText(count)));
    }

    private void initMessageList(OpenChannel channel) {
        boolean overlayMode;
        Bundle args = this.getArguments();
        boolean useMessageGroupUI = args == null || args.getBoolean("KEY_USE_MESSAGE_GROUP_UI", true);
        boolean useUserProfile = args == null || args.getBoolean("KEY_USE_USER_PROFILE", SendBirdUIKit.shouldUseDefaultUserProfile());
        boolean bl = overlayMode = args == null || args.getBoolean("KEY_USE_OVERLAY_MODE", false);
        if (this.adapter == null) {
            this.adapter = new OpenChannelMessageListAdapter(channel, null, null, useMessageGroupUI);
        }
        if (overlayMode) {
            this.binding.bg.setBackgroundResource(R.color.onlight_02);
        }
        this.adapter.setChannel(channel);
        if (this.itemClickListener == null) {
            this.itemClickListener = this;
        }
        if (this.itemLongClickListener == null) {
            this.itemLongClickListener = this;
        }
        if (this.profileClickListener == null && useUserProfile) {
            this.profileClickListener = (view, position, message) -> {
                if (this.getContext() == null || this.getFragmentManager() == null) {
                    return;
                }
                this.hideKeyboard();
                DialogUtils.buildUserProfile(this.getContext(), (User)message.getSender(), false, null, null).showSingle(this.getFragmentManager());
            };
        }
        this.adapter.setOnItemClickListener(this.itemClickListener);
        this.adapter.setOnItemLongClickListener(this.itemLongClickListener);
        this.adapter.setOnProfileClickListener(this.profileClickListener);
        final PagerRecyclerView recyclerView = this.binding.mrvMessageList.getRecyclerView();
        recyclerView.setAdapter(this.adapter);
        recyclerView.setHasFixedSize(true);
        recyclerView.setPager(this.viewModel);
        recyclerView.setThreshold(5);
        recyclerView.setItemAnimator((RecyclerView.ItemAnimator)new ItemAnimator());
        recyclerView.setOnScrollEndedEventListener(this::hideScrollBottomButton);
        this.binding.mrvMessageList.getScrollBottomView().setOnClickListener(v -> {
            recyclerView.stopScroll();
            this.scrollToBottom();
        });
        this.adapter.registerAdapterDataObserver(new RecyclerView.AdapterDataObserver(){

            public void onItemRangeInserted(int positionStart, int itemCount) {
                BaseMessage message;
                if (positionStart == 0 && OpenChannelFragment.this.adapter != null && (BaseMessage.belongsTo((BaseMessage)(message = OpenChannelFragment.this.adapter.getItem(positionStart)), (String)SendBird.getCurrentUser().getUserId()) || ((OpenChannelFragment)OpenChannelFragment.this).binding.mrvMessageList.getRecyclerView().findFirstVisibleItemPosition() == 0) && !OpenChannelFragment.this.isAnchorShowing()) {
                    recyclerView.scrollToPosition(0);
                }
            }
        });
        recyclerView.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrollStateChanged(@NonNull RecyclerView recyclerView, int newState) {
                if (((OpenChannelFragment)OpenChannelFragment.this).binding.mrvMessageList.getRecyclerView().findFirstVisibleItemPosition() > 0) {
                    ((OpenChannelFragment)OpenChannelFragment.this).binding.mrvMessageList.showScrollBottomButton();
                }
            }
        });
        this.viewModel.getStatusFrame().observe((LifecycleOwner)this, this.binding.statusFrame::setStatus);
        this.viewModel.getMessageLoadState().observe((LifecycleOwner)this, state -> {
            switch (state) {
                case LOAD_STARTED: {
                    break;
                }
                case LOAD_ENDED: {
                    if (!this.isActive() || !this.isInitialCall.getAndSet(false)) break;
                    this.loadingDialogHandler.shouldDismissLoadingDialog();
                }
            }
        });
        this.viewModel.getMessageList().observe((LifecycleOwner)this, messageList -> {
            Logger.dev("++ result messageList size : %s", messageList.size());
            this.binding.mrvMessageList.getRecyclerView().setRefreshing(false);
            this.adapter.setItems(channel, (List<BaseMessage>)messageList);
        });
        this.viewModel.load();
    }

    private void initMessageInput() {
        Bundle args = this.getArguments();
        this.inputHint = this.getResources().getString(R.string.sb_text_channel_input_text_hint);
        if (args != null) {
            KeyboardDisplayType displayType;
            if (args.containsKey("KEY_INPUT_LEFT_BUTTON_ICON_RES_ID")) {
                int inputLeftButtonIconResId = args.getInt("KEY_INPUT_LEFT_BUTTON_ICON_RES_ID", SendBirdUIKit.isDarkMode() ? R.drawable.selector_message_input_chooser_icon_dark : R.drawable.selector_message_input_chooser_icon);
                this.binding.vgInputBox.setAddImageResource(inputLeftButtonIconResId);
            }
            if (args.containsKey("KEY_INPUT_RIGHT_BUTTON_ICON_RES_ID")) {
                int inputRightButtonIconResId = args.getInt("KEY_INPUT_RIGHT_BUTTON_ICON_RES_ID", R.drawable.icon_send);
                this.binding.vgInputBox.setSendImageResource(inputRightButtonIconResId);
            }
            if (args.containsKey("KEY_INPUT_HINT")) {
                this.inputHint = args.getString("KEY_INPUT_HINT", this.getString(R.string.sb_text_channel_input_text_hint));
                this.binding.vgInputBox.setInputTextHint(this.inputHint);
            }
            if (args.containsKey("KEY_KEYBOARD_DISPLAY_TYPE") && (displayType = (KeyboardDisplayType)((Object)args.getSerializable("KEY_KEYBOARD_DISPLAY_TYPE"))) != null && this.getFragmentManager() != null) {
                this.binding.vgInputBox.setKeyboardDisplayType(this.getFragmentManager(), displayType);
            }
            if (args.containsKey("KEY_USE_INPUT_LEFT_BUTTON")) {
                boolean useInputLeftButton = args.getBoolean("KEY_USE_INPUT_LEFT_BUTTON", true);
                if (useInputLeftButton) {
                    this.binding.vgInputBox.setAddButtonVisibility(0);
                } else {
                    this.binding.vgInputBox.setAddButtonVisibility(8);
                }
            }
        }
        this.binding.vgInputBox.setOnSendClickListener(this::sendMessage);
        this.binding.vgInputBox.setOnAddClickListener(this.inputLeftButtonListener == null ? v -> this.showMediaSelectDialog() : this.inputLeftButtonListener);
        this.binding.vgInputBox.setOnEditCancelClickListener(v -> this.finishEditMode());
        this.binding.vgInputBox.setOnEditSaveClickListener(v -> {
            String text = this.getEditTextString();
            if (!TextUtils.isEmpty(text)) {
                UserMessageParams params = new UserMessageParams(text);
                this.updateUserMessage(this.editMessageId, params);
            }
            this.finishEditMode();
        });
    }

    private void hideScrollBottomButton() {
        this.binding.mrvMessageList.hideScrollBottomButton();
    }

    private void scrollToBottom() {
        if (this.binding == null) {
            return;
        }
        RecyclerView.LayoutManager layoutMgr = this.binding.mrvMessageList.getRecyclerView().getLayoutManager();
        if (layoutMgr == null) {
            return;
        }
        layoutMgr.scrollToPosition(0);
    }

    protected void showMediaSelectDialog() {
        if (this.getContext() == null || this.getFragmentManager() == null) {
            return;
        }
        DialogListItem[] items = new DialogListItem[]{new DialogListItem(R.string.sb_text_channel_input_camera, R.drawable.icon_camera), new DialogListItem(R.string.sb_text_channel_input_gallery, R.drawable.icon_photo), new DialogListItem(R.string.sb_text_channel_input_document, R.drawable.icon_document)};
        this.hideKeyboard();
        DialogUtils.buildItemsBottom(items, (view, position, key) -> {
            try {
                if (key == R.string.sb_text_channel_input_camera) {
                    this.takeCamera();
                } else if (key == R.string.sb_text_channel_input_gallery) {
                    this.takePhoto();
                } else {
                    this.takeFile();
                }
            }
            catch (Exception e) {
                Logger.e(e);
                if (key == R.string.sb_text_channel_input_camera) {
                    this.toastError(R.string.sb_text_error_open_camera);
                }
                if (key == R.string.sb_text_channel_input_gallery) {
                    this.toastError(R.string.sb_text_error_open_gallery);
                }
                this.toastError(R.string.sb_text_error_open_file);
            }
        }).showSingle(this.getFragmentManager());
    }

    public void takeCamera() {
        SendBird.setAutoBackgroundDetection((boolean)false);
        this.checkPermission(2005, new PermissionFragment.IPermissionHandler(){

            @Override
            public String[] getPermissions(int requestCode) {
                return new String[]{"android.permission.CAMERA", "android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.READ_EXTERNAL_STORAGE"};
            }

            @Override
            public void onPermissionGranted(int requestCode) {
                OpenChannelFragment.this.mediaUri = FileUtils.createPictureImageUri(OpenChannelFragment.this.getContext());
                Intent intent = IntentUtils.getCameraIntent(OpenChannelFragment.this.getContext(), OpenChannelFragment.this.mediaUri);
                if (IntentUtils.hasIntent(OpenChannelFragment.this.getContext(), intent)) {
                    OpenChannelFragment.this.startActivityForResult(intent, 2001);
                }
            }
        });
    }

    public void takePhoto() {
        SendBird.setAutoBackgroundDetection((boolean)false);
        this.checkPermission(2006, new PermissionFragment.IPermissionHandler(){

            @Override
            public String[] getPermissions(int requestCode) {
                return new String[]{"android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.READ_EXTERNAL_STORAGE"};
            }

            @Override
            public void onPermissionGranted(int requestCode) {
                Intent intent = IntentUtils.getGalleryIntent();
                OpenChannelFragment.this.startActivityForResult(intent, 2002);
            }
        });
    }

    public void takeFile() {
        SendBird.setAutoBackgroundDetection((boolean)false);
        this.checkPermission(2006, new PermissionFragment.IPermissionHandler(){

            @Override
            public String[] getPermissions(int requestCode) {
                return new String[]{"android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.READ_EXTERNAL_STORAGE"};
            }

            @Override
            public void onPermissionGranted(int requestCode) {
                Intent intent = IntentUtils.getFileChooserIntent();
                OpenChannelFragment.this.startActivityForResult(intent, 2003);
            }
        });
    }

    private void finishEditMode() {
        this.binding.vgInputBox.hideEditMode();
        this.editMessageId = 0L;
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        SendBird.setAutoBackgroundDetection((boolean)true);
        if (resultCode != -1) {
            return;
        }
        if (requestCode == 2004) {
            this.drawChannel(this.viewModel.getChannel());
            return;
        }
        switch (requestCode) {
            case 2001: {
                break;
            }
            case 2002: 
            case 2003: {
                this.mediaUri = data.getData();
            }
        }
        if (this.mediaUri != null && this.isActive()) {
            this.sendFileMessage(this.mediaUri);
        }
    }

    private void sendMessage(View view) {
        String text;
        Logger.dev("++ onClick()");
        if (view.getId() == this.binding.vgInputBox.getBinding().ibtnSend.getId() && !TextUtils.isEmpty(text = this.getEditTextString())) {
            UserMessageParams params = new UserMessageParams(text);
            this.sendUserMessage(params);
            this.binding.vgInputBox.setInputText("");
        }
    }

    protected void onBeforeSendUserMessage(@NonNull UserMessageParams params) {
    }

    protected void onBeforeSendFileMessage(@NonNull FileMessageParams params) {
    }

    protected void onBeforeUpdateUserMessage(@NonNull UserMessageParams params) {
    }

    protected void sendUserMessage(@NonNull UserMessageParams params) {
        if (this.viewModel != null) {
            CustomParamsHandler cutsomHandler = SendBirdUIKit.getCustomParamsHandler();
            if (cutsomHandler != null) {
                cutsomHandler.onBeforeSendUserMessage(params);
            }
            this.onBeforeSendUserMessage(params);
            this.viewModel.sendUserMessage(params);
        }
    }

    protected void sendFileMessage(@NonNull Uri uri) {
        if (this.viewModel != null && this.getContext() != null) {
            FileInfo.fromUri(this.getContext(), uri, SendBirdUIKit.shouldUseImageCompression(), new OnResultHandler<FileInfo>(){

                @Override
                public void onResult(FileInfo info) {
                    FileMessageParams params = info.toFileParams();
                    CustomParamsHandler cutsomHandler = SendBirdUIKit.getCustomParamsHandler();
                    if (cutsomHandler != null) {
                        cutsomHandler.onBeforeSendFileMessage(params);
                    }
                    OpenChannelFragment.this.onBeforeSendFileMessage(params);
                    OpenChannelFragment.this.viewModel.sendFileMessage(params, info);
                }

                @Override
                public void onError(SendBirdException e) {
                    Logger.w((Throwable)e);
                    OpenChannelFragment.this.toastError(R.string.sb_text_error_send_message);
                }
            });
        }
    }

    protected void updateUserMessage(long messageId, @NonNull UserMessageParams params) {
        if (this.viewModel != null) {
            CustomParamsHandler cutsomHandler = SendBirdUIKit.getCustomParamsHandler();
            if (cutsomHandler != null) {
                cutsomHandler.onBeforeUpdateUserMessage(params);
            }
            this.onBeforeUpdateUserMessage(params);
            this.viewModel.updateUserMessage(messageId, params);
        }
    }

    protected void deleteMessage(@NonNull BaseMessage message) {
        if (this.viewModel != null) {
            this.viewModel.deleteMessage(message);
        }
    }

    protected void resendMessage(@NonNull BaseMessage message) {
        if (this.viewModel != null) {
            if (message.isResendable()) {
                this.viewModel.resendMessage(message);
            } else {
                this.toastError(R.string.sb_text_error_not_possible_resend_message);
            }
        }
    }

    @Override
    public boolean shouldShowLoadingDialog() {
        return false;
    }

    @Override
    public void shouldDismissLoadingDialog() {
    }

    private String getEditTextString() {
        return this.binding.vgInputBox.getInputText();
    }

    private void showFile(final @NonNull File file, final @NonNull String mimeType) {
        TaskQueue.addTask(new JobResultTask<Intent>(){

            @Override
            public Intent call() {
                Uri uri = FileUtils.fileToUri(OpenChannelFragment.this.getContext(), file);
                return IntentUtils.getFileViewerIntent(uri, mimeType);
            }

            @Override
            public void onResultForUiThread(Intent intent, SendBirdException e) {
                if (e != null) {
                    Logger.e((Throwable)e);
                    OpenChannelFragment.this.toastError(R.string.sb_text_error_open_file);
                    return;
                }
                if (intent != null) {
                    OpenChannelFragment.this.startActivity(intent);
                }
            }
        });
    }

    @Override
    public void onItemClick(View view, int position, BaseMessage message) {
        Logger.d("++ OpenChannelFragment::onItemClicked()");
        BaseMessage.SendingStatus status = message.getSendingStatus();
        if (status == BaseMessage.SendingStatus.SUCCEEDED) {
            MessageType type = MessageViewHolderFactory.getMessageType(message);
            switch (type) {
                case VIEW_TYPE_FILE_MESSAGE_IMAGE_ME: 
                case VIEW_TYPE_FILE_MESSAGE_IMAGE_OTHER: {
                    this.startActivity(PhotoViewActivity.newIntent(this.getContext(), BaseChannel.ChannelType.OPEN, (FileMessage)message));
                    break;
                }
                case VIEW_TYPE_FILE_MESSAGE_VIDEO_ME: 
                case VIEW_TYPE_FILE_MESSAGE_VIDEO_OTHER: 
                case VIEW_TYPE_FILE_MESSAGE_ME: 
                case VIEW_TYPE_FILE_MESSAGE_OTHER: {
                    final FileMessage fileMessage = (FileMessage)message;
                    FileDownloader.downloadFile(this.getContext(), fileMessage, new OnResultHandler<File>(){

                        @Override
                        public void onResult(File file) {
                            OpenChannelFragment.this.showFile(file, fileMessage.getType());
                        }

                        @Override
                        public void onError(SendBirdException e) {
                            OpenChannelFragment.this.toastError(R.string.sb_text_error_download_file);
                        }
                    });
                    break;
                }
            }
        } else if (message instanceof UserMessage || message instanceof FileMessage) {
            this.resendMessage(message);
        }
    }

    private boolean isLongClickable(BaseMessage message) {
        BaseMessage.SendingStatus status = message.getSendingStatus();
        switch (status) {
            case FAILED: 
            case SUCCEEDED: 
            case CANCELED: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void onItemLongClick(View itemView, int position, BaseMessage message) {
        if (!this.isLongClickable(message)) {
            return;
        }
        Logger.d("++ OpenChannelFragment::onItemLongClick()");
        MessageType type = MessageViewHolderFactory.getMessageType(message);
        DialogListItem copy = new DialogListItem(R.string.sb_text_channel_anchor_copy, R.drawable.icon_copy);
        DialogListItem edit = new DialogListItem(R.string.sb_text_channel_anchor_edit, R.drawable.icon_edit);
        DialogListItem save = new DialogListItem(R.string.sb_text_channel_anchor_save, R.drawable.icon_download);
        DialogListItem delete = new DialogListItem(R.string.sb_text_channel_anchor_delete, R.drawable.icon_delete);
        DialogListItem[] actions = null;
        BaseMessage.SendingStatus status = message.getSendingStatus();
        switch (type) {
            case VIEW_TYPE_USER_MESSAGE_ME: {
                if (status == BaseMessage.SendingStatus.SUCCEEDED) {
                    actions = new DialogListItem[]{copy, edit, delete};
                    break;
                }
                if (status != BaseMessage.SendingStatus.FAILED && status != BaseMessage.SendingStatus.CANCELED) break;
                actions = new DialogListItem[]{delete};
                break;
            }
            case VIEW_TYPE_USER_MESSAGE_OTHER: {
                actions = new DialogListItem[]{copy};
                break;
            }
            case VIEW_TYPE_FILE_MESSAGE_IMAGE_ME: 
            case VIEW_TYPE_FILE_MESSAGE_VIDEO_ME: 
            case VIEW_TYPE_FILE_MESSAGE_ME: {
                if (status == BaseMessage.SendingStatus.FAILED || status == BaseMessage.SendingStatus.CANCELED) {
                    actions = new DialogListItem[]{delete};
                    break;
                }
                actions = new DialogListItem[]{delete, save};
                break;
            }
            case VIEW_TYPE_FILE_MESSAGE_IMAGE_OTHER: 
            case VIEW_TYPE_FILE_MESSAGE_VIDEO_OTHER: 
            case VIEW_TYPE_FILE_MESSAGE_OTHER: {
                actions = new DialogListItem[]{save};
                break;
            }
            case VIEW_TYPE_UNKNOWN_MESSAGE_ME: {
                actions = new DialogListItem[]{delete};
            }
        }
        if (actions != null) {
            if (MessageUtils.isUnknownType(message)) {
                if (this.getContext() == null || this.getFragmentManager() == null) {
                    return;
                }
                DialogUtils.buildItemsBottom(actions, this.createMessageActionListener(message)).showSingle(this.getFragmentManager());
            } else {
                if (this.getContext() == null) {
                    return;
                }
                this.messageAnchorDialog = new MessageAnchorDialog.Builder(itemView, (View)this.binding.mrvMessageList, actions).setOnItemClickListener(this.createMessageActionListener(message)).build();
                this.messageAnchorDialog.show();
            }
        }
    }

    private void hideKeyboard() {
        if (this.getView() != null) {
            SoftInputUtils.hideSoftKeyboard(this.getView());
        }
    }

    private OnItemClickListener<Integer> createMessageActionListener(final BaseMessage message) {
        return (view, position, key) -> {
            if (key == R.string.sb_text_channel_anchor_copy) {
                this.copyTextToClipboard(message.getMessage());
            } else if (key == R.string.sb_text_channel_anchor_edit) {
                this.editMessage(message);
            } else if (key == R.string.sb_text_channel_anchor_delete) {
                this.showWarningDialog(message);
            } else if (key == R.string.sb_text_channel_anchor_save) {
                this.checkPermission(2006, new PermissionFragment.IPermissionHandler(){

                    @Override
                    public String[] getPermissions(int requestCode) {
                        return new String[]{"android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"};
                    }

                    @Override
                    public void onPermissionGranted(int requestCode) {
                        OpenChannelFragment.this.download((FileMessage)message);
                    }
                });
            }
        };
    }

    private void download(final FileMessage message) {
        this.toastSuccess(R.string.sb_text_toast_success_start_download_file);
        TaskQueue.addTask(new JobResultTask<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                FileDownloader.getInstance().saveFile(OpenChannelFragment.this.getContext(), message.getUrl(), message.getName());
                return true;
            }

            @Override
            public void onResultForUiThread(Boolean result, SendBirdException e) {
                if (e != null) {
                    Logger.e((Throwable)e);
                    OpenChannelFragment.this.toastError(R.string.sb_text_error_download_file);
                    return;
                }
                OpenChannelFragment.this.toastSuccess(R.string.sb_text_toast_success_download_file);
            }
        });
    }

    private void copyTextToClipboard(String text) {
        ClipboardManager clipboardManager = (ClipboardManager)this.getContext().getSystemService("clipboard");
        ClipData clipData = ClipData.newPlainText((CharSequence)"COPY_TEXT", (CharSequence)text);
        if (clipboardManager != null) {
            clipboardManager.setPrimaryClip(clipData);
            ContextUtils.toastSuccess(this.getContext(), R.string.sb_text_toast_success_copy);
        } else {
            this.toastError(R.string.sb_text_error_copy_message);
        }
    }

    private void editMessage(BaseMessage message) {
        this.editMessageId = message.getMessageId();
        this.binding.vgInputBox.showEditMode(message.getMessage());
    }

    private void showWarningDialog(BaseMessage message) {
        if (this.getContext() == null || this.getFragmentManager() == null) {
            return;
        }
        DialogUtils.buildWarning(this.getString(R.string.sb_text_dialog_delete_message), (int)this.getResources().getDimension(R.dimen.sb_dialog_width_280), this.getString(R.string.sb_text_button_delete), delete -> {
            Logger.dev("delete");
            this.deleteMessage(message);
        }, this.getString(R.string.sb_text_button_cancel), cancel -> Logger.dev("cancel")).showSingle(this.getFragmentManager());
    }

    private boolean isAnchorShowing() {
        return this.messageAnchorDialog != null && this.messageAnchorDialog.isShowing();
    }

    private void setHeaderLeftButtonListener(View.OnClickListener listener) {
        this.headerLeftButtonListener = listener;
    }

    private void setHeaderRightButtonListener(View.OnClickListener listener) {
        this.headerRightButtonListener = listener;
    }

    private void setMessageListAdapter(OpenChannelMessageListAdapter adapter) {
        this.adapter = adapter;
    }

    private void setItemClickListener(OnItemClickListener<BaseMessage> itemClickListener) {
        this.itemClickListener = itemClickListener;
    }

    private void setItemLongClickListener(OnItemLongClickListener<BaseMessage> itemLongClickListener) {
        this.itemLongClickListener = itemLongClickListener;
    }

    private void setInputLeftButtonListener(View.OnClickListener listener) {
        this.inputLeftButtonListener = listener;
    }

    private void setMessageListParams(MessageListParams params) {
        this.params = params;
    }

    private void setOnProfileClickListener(OnItemClickListener<BaseMessage> profileClickListener) {
        this.profileClickListener = profileClickListener;
    }

    private void setLoadingDialogHandler(LoadingDialogHandler loadingDialogHandler) {
        this.loadingDialogHandler = loadingDialogHandler;
    }

    public static class Builder {
        private final Bundle bundle = new Bundle();
        private OpenChannelFragment customFragment;
        private OpenChannelMessageListAdapter adapter;
        private View.OnClickListener headerLeftButtonListener;
        private View.OnClickListener headerRightButtonListener;
        private OnItemClickListener<BaseMessage> itemClickListener;
        private OnItemLongClickListener<BaseMessage> itemLongClickListener;
        private View.OnClickListener inputLeftButtonListener;
        private MessageListParams params;
        private OnItemClickListener<BaseMessage> profileClickListener;
        private LoadingDialogHandler loadingDialogHandler;

        public Builder(@NonNull String channelUrl) {
            this(channelUrl, SendBirdUIKit.getDefaultThemeMode());
        }

        public Builder(@NonNull String channelUrl, SendBirdUIKit.ThemeMode themeMode) {
            this.bundle.putInt("KEY_THEME_RES_ID", themeMode.getResId());
            this.bundle.putString("KEY_CHANNEL_URL", channelUrl);
        }

        public Builder(@NonNull String channelUrl, @StyleRes int customThemeResId) {
            this.bundle.putInt("KEY_THEME_RES_ID", customThemeResId);
            this.bundle.putString("KEY_CHANNEL_URL", channelUrl);
        }

        public <T extends OpenChannelFragment> Builder setCustomOpenChannelFragment(T fragment) {
            this.customFragment = fragment;
            return this;
        }

        public Builder setUseHeader(boolean useHeader) {
            this.bundle.putBoolean("KEY_USE_HEADER", useHeader);
            return this;
        }

        public Builder setHeaderDescription(String description) {
            this.bundle.putString("KEY_HEADER_DESCRIPTION", description);
            return this;
        }

        public Builder setUseHeaderRightButton(boolean useHeaderRightButton) {
            this.bundle.putBoolean("KEY_USE_HEADER_RIGHT_BUTTON", useHeaderRightButton);
            return this;
        }

        public Builder setUseHeaderLeftButton(boolean useHeaderLeftButton) {
            this.bundle.putBoolean("KEY_USE_HEADER_LEFT_BUTTON", useHeaderLeftButton);
            return this;
        }

        public Builder setHeaderLeftButtonIconResId(@DrawableRes int resId) {
            this.bundle.putInt("KEY_HEADER_LEFT_BUTTON_ICON_RES_ID", resId);
            return this;
        }

        public Builder setHeaderRightButtonIconResId(@DrawableRes int resId) {
            this.bundle.putInt("KEY_HEADER_RIGHT_BUTTON_ICON_RES_ID", resId);
            return this;
        }

        public Builder setUseInputLeftButton(boolean useInputLeftButton) {
            this.bundle.putBoolean("KEY_USE_INPUT_LEFT_BUTTON", useInputLeftButton);
            return this;
        }

        public Builder setInputLeftButtonIconResId(@DrawableRes int resId) {
            this.bundle.putInt("KEY_INPUT_LEFT_BUTTON_ICON_RES_ID", resId);
            return this;
        }

        public Builder setInputRightButtonIconResId(@DrawableRes int resId) {
            this.bundle.putInt("KEY_INPUT_RIGHT_BUTTON_ICON_RES_ID", resId);
            return this;
        }

        public Builder setInputHint(String hint) {
            this.bundle.putString("KEY_INPUT_HINT", hint);
            return this;
        }

        public Builder setHeaderLeftButtonListener(View.OnClickListener listener) {
            this.headerLeftButtonListener = listener;
            return this;
        }

        public Builder setHeaderRightButtonListener(View.OnClickListener listener) {
            this.headerRightButtonListener = listener;
            return this;
        }

        public Builder setOpenChannelMessageListAdapter(OpenChannelMessageListAdapter adapter) {
            this.adapter = adapter;
            return this;
        }

        public Builder setItemClickListener(OnItemClickListener<BaseMessage> itemClickListener) {
            this.itemClickListener = itemClickListener;
            return this;
        }

        public Builder setItemLongClickListener(OnItemLongClickListener<BaseMessage> itemLongClickListener) {
            this.itemLongClickListener = itemLongClickListener;
            return this;
        }

        public Builder setInputLeftButtonListener(View.OnClickListener listener) {
            this.inputLeftButtonListener = listener;
            return this;
        }

        public Builder setMessageListParams(MessageListParams params) {
            this.params = params;
            return this;
        }

        public Builder setUseMessageGroupUI(boolean useMessageGroupUI) {
            this.bundle.putBoolean("KEY_USE_MESSAGE_GROUP_UI", useMessageGroupUI);
            return this;
        }

        public Builder setOnProfileClickListener(OnItemClickListener<BaseMessage> profileClickListener) {
            this.profileClickListener = profileClickListener;
            return this;
        }

        public Builder setUseUserProfile(boolean useUserProfile) {
            this.bundle.putBoolean("KEY_USE_USER_PROFILE", useUserProfile);
            return this;
        }

        public Builder useOverlayMode() {
            this.bundle.putBoolean("KEY_USE_OVERLAY_MODE", true);
            this.bundle.putInt("KEY_THEME_RES_ID", R.style.SendBird_Overlay);
            return this;
        }

        public Builder setKeyboardDisplayType(KeyboardDisplayType type) {
            this.bundle.putSerializable("KEY_KEYBOARD_DISPLAY_TYPE", (Serializable)((Object)type));
            return this;
        }

        public Builder setLoadingDialogHandler(LoadingDialogHandler loadingDialogHandler) {
            this.loadingDialogHandler = loadingDialogHandler;
            return this;
        }

        public OpenChannelFragment build() {
            OpenChannelFragment fragment = this.customFragment != null ? this.customFragment : new OpenChannelFragment();
            fragment.setArguments(this.bundle);
            fragment.setHeaderLeftButtonListener(this.headerLeftButtonListener);
            fragment.setHeaderRightButtonListener(this.headerRightButtonListener);
            fragment.setMessageListAdapter(this.adapter);
            fragment.setItemClickListener(this.itemClickListener);
            fragment.setItemLongClickListener(this.itemLongClickListener);
            fragment.setInputLeftButtonListener(this.inputLeftButtonListener);
            fragment.setMessageListParams(this.params);
            fragment.setOnProfileClickListener(this.profileClickListener);
            fragment.setLoadingDialogHandler(this.loadingDialogHandler);
            return fragment;
        }
    }
}

