/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.widgets;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.databinding.DataBindingUtil;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.engine.GlideException;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.target.Target;
import com.sendbird.android.OGMetaData;
import com.sendbird.uikit.R;
import com.sendbird.uikit.SendBirdUIKit;
import com.sendbird.uikit.databinding.SbViewOpenChannelOgtagBinding;
import com.sendbird.uikit.utils.TextUtils;

public class OpenChannelOgtagView
extends FrameLayout {
    private SbViewOpenChannelOgtagBinding binding;

    public OpenChannelOgtagView(@NonNull Context context) {
        this(context, null);
    }

    public OpenChannelOgtagView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.sb_open_channel_message_user_style);
    }

    public OpenChannelOgtagView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, null);
    }

    public static OpenChannelOgtagView inflate(@NonNull Context context, @Nullable ViewGroup parent) {
        return new OpenChannelOgtagView(context, null, R.attr.sb_open_channel_message_user_style, parent);
    }

    private OpenChannelOgtagView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, ViewGroup parent) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr, parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, ViewGroup parent) {
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.MessageView, defStyleAttr, 0);
        try {
            if (parent == null) {
                parent = this;
            }
            this.binding = (SbViewOpenChannelOgtagBinding)DataBindingUtil.inflate((LayoutInflater)LayoutInflater.from((Context)this.getContext()), (int)R.layout.sb_view_open_channel_ogtag, (ViewGroup)parent, (boolean)true);
            int ogtagTitleAppearence = a.getResourceId(R.styleable.MessageView_sb_message_ogtag_title_appearance, R.style.SendbirdBody1OnLight01);
            int ogtagDescAppearence = a.getResourceId(R.styleable.MessageView_sb_message_ogtag_description_appearance, R.style.SendbirdCaption2OnLight01);
            int ogtagUrlAppearence = a.getResourceId(R.styleable.MessageView_sb_message_ogtag_url_appearance, R.style.SendbirdCaption2OnLight02);
            this.binding.tvOgTitle.setTextAppearance(context, ogtagTitleAppearence);
            this.binding.tvOgDescription.setTextAppearance(context, ogtagDescAppearence);
            this.binding.tvOgUrl.setTextAppearance(context, ogtagUrlAppearence);
        }
        finally {
            a.recycle();
        }
    }

    public void drawOgtag(@Nullable OGMetaData metaData) {
        this.setVisibility(metaData != null ? 0 : 8);
        if (metaData == null || this.binding == null) {
            return;
        }
        if (metaData.getOGImage() != null && (metaData.getOGImage().getSecureUrl() != null || metaData.getOGImage().getUrl() != null)) {
            this.binding.ivOgImage.setVisibility(0);
            String ogImageUrl = metaData.getOGImage().getSecureUrl() != null ? metaData.getOGImage().getSecureUrl() : metaData.getOGImage().getUrl();
            RequestBuilder builder = (RequestBuilder)((RequestBuilder)((RequestBuilder)Glide.with((Context)this.getContext()).asDrawable().diskCacheStrategy(DiskCacheStrategy.ALL)).placeholder(SendBirdUIKit.isDarkMode() ? R.drawable.icon_thumbnail_dark : R.drawable.icon_thumbnail_light)).error(SendBirdUIKit.isDarkMode() ? R.drawable.icon_no_thumbnail_dark : R.drawable.icon_no_thumbnail_light);
            this.binding.ivOgImage.setRadius(this.getResources().getDimensionPixelSize(R.dimen.sb_size_8));
            this.binding.ivOgImage.getContent().setScaleType(ImageView.ScaleType.CENTER);
            ((RequestBuilder)builder.load(ogImageUrl).centerCrop()).thumbnail(0.3f).listener((RequestListener)new RequestListener<Drawable>(){

                public boolean onLoadFailed(@Nullable GlideException e, Object model, Target<Drawable> target, boolean isFirstResource) {
                    return false;
                }

                public boolean onResourceReady(Drawable resource, Object model, Target<Drawable> target, DataSource dataSource, boolean isFirstResource) {
                    ((OpenChannelOgtagView)OpenChannelOgtagView.this).binding.ivOgImage.getContent().setScaleType(ImageView.ScaleType.CENTER_CROP);
                    return false;
                }
            }).into(this.binding.ivOgImage.getContent());
        } else {
            this.binding.ivOgImage.setVisibility(8);
        }
        if (!TextUtils.isEmpty(metaData.getTitle())) {
            this.binding.tvOgTitle.setVisibility(0);
            this.binding.tvOgTitle.setText((CharSequence)metaData.getTitle());
        } else {
            this.binding.tvOgTitle.setVisibility(8);
        }
        if (!TextUtils.isEmpty(metaData.getDescription())) {
            this.binding.tvOgDescription.setVisibility(0);
            this.binding.tvOgDescription.setText((CharSequence)metaData.getDescription());
        } else {
            this.binding.tvOgDescription.setVisibility(8);
        }
        if (!TextUtils.isEmpty(metaData.getUrl())) {
            this.binding.tvOgUrl.setVisibility(0);
            this.binding.tvOgUrl.setText((CharSequence)metaData.getUrl());
        } else {
            this.binding.tvOgUrl.setVisibility(8);
        }
    }
}

