/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.widgets;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.databinding.BindingAdapter;
import androidx.databinding.DataBindingUtil;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.sendbird.android.Emoji;
import com.sendbird.uikit.R;
import com.sendbird.uikit.databinding.SbViewEmojiComponentBinding;
import com.sendbird.uikit.model.EmojiManager;

public class EmojiView
extends FrameLayout {
    private SbViewEmojiComponentBinding binding;
    private int backgroundResource;
    private int imageResource;

    public EmojiView(@NonNull Context context) {
        this(context, null);
    }

    public EmojiView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.sb_emoji_reaction_style);
    }

    public EmojiView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.Emoji, defStyleAttr, R.style.Widget_SendBird_Emoji);
        try {
            this.binding = (SbViewEmojiComponentBinding)DataBindingUtil.inflate((LayoutInflater)LayoutInflater.from((Context)this.getContext()), (int)R.layout.sb_view_emoji_component, (ViewGroup)this, (boolean)true);
            this.backgroundResource = a.getResourceId(R.styleable.Emoji_sb_emoji_background, R.drawable.sb_emoji_background_light);
            this.imageResource = R.drawable.emoji_fail;
            this.binding.emojiPanel.setBackgroundResource(this.backgroundResource);
            this.binding.ivEmoji.setImageResource(this.imageResource);
        }
        finally {
            a.recycle();
        }
    }

    public void setBackgroundResource(int backgroundResource) {
        this.backgroundResource = backgroundResource;
        if (this.binding != null) {
            this.binding.emojiPanel.setBackgroundResource(backgroundResource);
        }
    }

    public void setImageResource(int imageResource) {
        this.imageResource = imageResource;
        if (this.binding != null) {
            this.binding.ivEmoji.setImageResource(imageResource);
        }
    }

    public void setEmojiUrl(String emojiUrl) {
        if (this.binding != null) {
            int overrideSize = this.getResources().getDimensionPixelSize(R.dimen.sb_size_38);
            ((RequestBuilder)((RequestBuilder)((RequestBuilder)((RequestBuilder)((RequestBuilder)Glide.with((View)this.binding.ivEmoji).load(emojiUrl).override(overrideSize, overrideSize)).centerCrop()).diskCacheStrategy(DiskCacheStrategy.ALL)).error(R.drawable.emoji_fail)).placeholder(R.drawable.emoji_fail)).into((ImageView)this.binding.ivEmoji);
        }
    }

    public View getLayout() {
        return this.binding.getRoot();
    }

    public SbViewEmojiComponentBinding getBinding() {
        return this.binding;
    }

    public void drawEmoji(Emoji emoji) {
        if (emoji == null) {
            return;
        }
        this.setEmojiUrl(EmojiManager.getInstance().getEmojiUrl(emoji.getKey()));
    }

    @BindingAdapter(value={"emoji"})
    public static void drawEmoji(@NonNull EmojiView view, Emoji emoji) {
        view.drawEmoji(emoji);
    }
}

