/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.widgets;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.databinding.BindingAdapter;
import androidx.databinding.DataBindingUtil;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.sendbird.android.Reaction;
import com.sendbird.uikit.R;
import com.sendbird.uikit.databinding.SbViewEmojiReactionComponentBinding;
import com.sendbird.uikit.model.EmojiManager;

public class EmojiReactionView
extends FrameLayout {
    private SbViewEmojiReactionComponentBinding binding;

    public EmojiReactionView(@NonNull Context context) {
        this(context, null);
    }

    public EmojiReactionView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.sb_emoji_reaction_style);
    }

    public EmojiReactionView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.EmojiReaction, defStyleAttr, R.style.Widget_SendBird_Emoji);
        try {
            this.binding = (SbViewEmojiReactionComponentBinding)DataBindingUtil.inflate((LayoutInflater)LayoutInflater.from((Context)this.getContext()), (int)R.layout.sb_view_emoji_reaction_component, (ViewGroup)this, (boolean)true);
            int backgroundRes = a.getResourceId(R.styleable.EmojiReaction_sb_emoji_reaction_background, R.drawable.sb_emoji_reaction_background_light);
            int textStyle = a.getResourceId(R.styleable.EmojiReaction_sb_emoji_reaction_text_appearance, R.style.SendbirdCaption3OnLight01);
            this.binding.getRoot().setBackgroundResource(backgroundRes);
            this.binding.tvCount.setTextAppearance(context, textStyle);
        }
        finally {
            a.recycle();
        }
    }

    public void setBackgroundResource(int backgroundResource) {
        if (this.binding != null) {
            this.binding.getRoot().setBackgroundResource(backgroundResource);
        }
    }

    public void setCount(int count) {
        if (this.binding == null) {
            return;
        }
        if (count <= 0) {
            this.binding.empty.setVisibility(8);
            this.binding.tvCount.setVisibility(8);
        } else {
            this.binding.empty.setVisibility(0);
            this.binding.tvCount.setVisibility(0);
            String countText = count > 99 ? this.getContext().getString(R.string.sb_text_channel_reaction_count_max) : String.valueOf(count);
            this.binding.tvCount.setText((CharSequence)countText);
        }
    }

    public void setImageResource(int imageResource) {
        if (this.binding != null) {
            this.binding.ivEmoji.setImageResource(imageResource);
        }
    }

    public void setEmojiUrl(String emojiUrl) {
        if (this.binding != null) {
            int overrideSize = this.getResources().getDimensionPixelSize(R.dimen.sb_size_38);
            ((RequestBuilder)((RequestBuilder)((RequestBuilder)((RequestBuilder)((RequestBuilder)Glide.with((View)this.binding.ivEmoji).load(emojiUrl).override(overrideSize, overrideSize)).centerCrop()).diskCacheStrategy(DiskCacheStrategy.ALL)).error(R.drawable.emoji_fail)).placeholder(R.drawable.emoji_fail)).into((ImageView)this.binding.ivEmoji);
        }
    }

    public View getLayout() {
        return this.binding.getRoot();
    }

    public SbViewEmojiReactionComponentBinding getBinding() {
        return this.binding;
    }

    public void drawReaction(Reaction reaction) {
        if (reaction == null || reaction.getUserIds() == null) {
            return;
        }
        this.setCount(reaction.getUserIds().size());
        this.setEmojiUrl(EmojiManager.getInstance().getEmojiUrl(reaction.getKey()));
    }

    @BindingAdapter(value={"reaction"})
    public static void drawReaction(@NonNull EmojiReactionView view, Reaction reaction) {
        view.drawReaction(reaction);
    }
}

