/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.vm;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestManager;
import com.sendbird.android.FileMessage;
import com.sendbird.android.SendBirdException;
import com.sendbird.uikit.interfaces.OnResultHandler;
import com.sendbird.uikit.log.Logger;
import com.sendbird.uikit.tasks.JobResultTask;
import com.sendbird.uikit.tasks.TaskQueue;
import com.sendbird.uikit.utils.FileUtils;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;

public class FileDownloader {
    private final Set<String> downloadingFileSet = new HashSet<String>();

    private FileDownloader() {
    }

    public static FileDownloader getInstance() {
        return FileDownloadHolder.INSTANCE;
    }

    private File getDownloadFile(@NonNull Context context, @NonNull FileMessage message) {
        String newFileName = "Downloaded_file_" + message.getMessageId() + "_" + message.getName();
        return FileUtils.createCachedDirFile(context.getApplicationContext(), newFileName);
    }

    public boolean hasFile(@NonNull Context context, @NonNull FileMessage message) {
        File file = this.getDownloadFile(context, message);
        if (file.exists() && file.length() == (long)message.getSize()) {
            Logger.dev("__ return exist file");
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public File downloadToCache(@NonNull Context context, @NonNull FileMessage message) throws ExecutionException, InterruptedException {
        String url = message.getUrl();
        if (this.downloadingFileSet.contains(url)) {
            return null;
        }
        try {
            File file;
            this.downloadingFileSet.add(url);
            String newFileName = "Downloaded_file_" + message.getMessageId() + "_" + message.getName();
            File destFile = FileUtils.createCachedDirFile(context.getApplicationContext(), newFileName);
            Logger.dev("__ file size : " + destFile.length());
            if (destFile.exists()) {
                if (destFile.length() == (long)message.getSize()) {
                    Logger.dev("__ return exist file");
                    File file2 = destFile;
                    return file2;
                }
                destFile.delete();
            }
            if ((file = (File)Glide.with((Context)context).asFile().load(message.getUrl()).submit().get()) != null && file.exists() && file.renameTo(destFile)) {
                File file3 = destFile;
                return file3;
            }
        }
        finally {
            this.downloadingFileSet.remove(url);
        }
        return null;
    }

    public boolean isDownloading(@NonNull String url) {
        return this.downloadingFileSet.contains(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File saveFile(Context context, @NonNull String url, @NonNull String fileName) throws Exception {
        if (this.downloadingFileSet.contains(url) || context == null) {
            return null;
        }
        File result = null;
        try {
            this.downloadingFileSet.add(url);
            RequestManager glide = Glide.with((Context)context);
            File file = (File)glide.asFile().load(url).submit().get();
            result = FileUtils.saveFile(context, file, fileName);
        }
        finally {
            this.downloadingFileSet.remove(url);
        }
        return result;
    }

    public static boolean downloadFile(final @NonNull Context context, final @NonNull FileMessage message, final @NonNull OnResultHandler<File> handler) {
        boolean isDownloading = FileDownloader.getInstance().isDownloading(message.getUrl());
        Logger.d("++ request download file url=%s", message.getUrl());
        Logger.d("++ isDownloading=%s", isDownloading);
        if (isDownloading) {
            Logger.d("-- [%s] already request download.", message.getUrl());
            return false;
        }
        TaskQueue.addTask(new JobResultTask<File>(){

            @Override
            public File call() throws ExecutionException, InterruptedException {
                return FileDownloader.getInstance().downloadToCache(context, message);
            }

            @Override
            public void onResultForUiThread(File file, SendBirdException e) {
                if (e != null) {
                    Logger.e(e);
                    handler.onError(e);
                    return;
                }
                Logger.d("++ file download Complete file path : " + file.getAbsolutePath());
                handler.onResult(file);
            }
        });
        return true;
    }

    private static class FileDownloadHolder {
        static final FileDownloader INSTANCE = new FileDownloader();

        private FileDownloadHolder() {
        }
    }
}

