/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.utils;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.TextAppearanceSpan;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.Key;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.engine.GlideException;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.signature.ObjectKey;
import com.sendbird.android.BaseChannel;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.FileMessage;
import com.sendbird.android.OGMetaData;
import com.sendbird.android.Sender;
import com.sendbird.uikit.R;
import com.sendbird.uikit.SendBirdUIKit;
import com.sendbird.uikit.log.Logger;
import com.sendbird.uikit.model.FileInfo;
import com.sendbird.uikit.utils.DrawableUtils;
import com.sendbird.uikit.utils.IntentUtils;
import com.sendbird.uikit.utils.MessageUtils;
import com.sendbird.uikit.utils.ReactionUtils;
import com.sendbird.uikit.vm.PendingMessageRepository;
import com.sendbird.uikit.widgets.EmojiReactionListView;
import com.sendbird.uikit.widgets.OgtagView;
import com.sendbird.uikit.widgets.RoundCornerView;
import java.util.List;

public class ViewUtils {
    private static void drawUnknownMessage(TextView view, boolean isMine) {
        int unknownHintAppearance = isMine ? (SendBirdUIKit.isDarkMode() ? R.style.SendbirdBody1OnLight02 : R.style.SendbirdBody1OnDark02) : (SendBirdUIKit.isDarkMode() ? R.style.SendbirdBody1OnDark03 : R.style.SendbirdBody1OnLight02);
        int sizeOfFirstLine = 23;
        String unknownHintText = view.getContext().getResources().getString(R.string.sb_text_channel_unknown_type_text);
        SpannableString spannable = new SpannableString((CharSequence)unknownHintText);
        spannable.setSpan((Object)new TextAppearanceSpan(view.getContext(), unknownHintAppearance), 23, spannable.length(), 33);
        view.setText((CharSequence)spannable);
    }

    public static void drawTextMessage(@NonNull TextView textView, BaseMessage message, @StyleRes int editedTextAppearance) {
        if (message == null) {
            return;
        }
        if (MessageUtils.isUnknownType(message)) {
            ViewUtils.drawUnknownMessage(textView, MessageUtils.isMine(message));
            return;
        }
        textView.setText((CharSequence)message.getMessage());
        if (message.getUpdatedAt() <= 0L) {
            return;
        }
        String edited = textView.getResources().getString(R.string.sb_text_channel_message_badge_edited);
        SpannableString spannable = new SpannableString((CharSequence)edited);
        spannable.setSpan((Object)new TextAppearanceSpan(textView.getContext(), editedTextAppearance), 0, edited.length(), 33);
        textView.append((CharSequence)spannable);
    }

    public static void drawOgtag(@NonNull ViewGroup parent, OGMetaData ogMetaData) {
        if (ogMetaData == null) {
            return;
        }
        parent.removeAllViews();
        OgtagView ogtagView = OgtagView.inflate(parent.getContext(), parent);
        ogtagView.drawOgtag(ogMetaData);
        parent.setOnClickListener(v -> {
            if (ogMetaData.getUrl() == null) {
                return;
            }
            Intent intent = IntentUtils.getWebViewerIntent(ogMetaData.getUrl());
            try {
                ogtagView.getContext().startActivity(intent);
            }
            catch (ActivityNotFoundException e) {
                Logger.e(e);
            }
        });
    }

    public static void drawReactionEnabled(EmojiReactionListView view, BaseChannel channel) {
        boolean canSendReaction = ReactionUtils.canSendReaction(channel);
        view.setClickable(canSendReaction);
        if (view.useMoreButton() != canSendReaction) {
            view.setUseMoreButton(canSendReaction);
            view.refresh();
        }
    }

    public static void drawNickname(TextView tvNickname, BaseMessage message) {
        if (message == null) {
            return;
        }
        Sender sender = message.getSender();
        String nickname = sender == null || TextUtils.isEmpty((CharSequence)sender.getNickname()) ? tvNickname.getContext().getString(R.string.sb_text_channel_list_title_unknown) : sender.getNickname();
        tvNickname.setText((CharSequence)nickname);
    }

    public static void drawProfile(ImageView ivProfile, BaseMessage message) {
        if (message == null) {
            return;
        }
        Sender sender = message.getSender();
        String url = "";
        if (sender != null && !TextUtils.isEmpty((CharSequence)sender.getProfileUrl())) {
            url = sender.getProfileUrl();
        }
        ((RequestBuilder)((RequestBuilder)((RequestBuilder)Glide.with((Context)ivProfile.getContext()).load(url).diskCacheStrategy(DiskCacheStrategy.ALL)).signature((Key)new ObjectKey((Object)url))).error(SendBirdUIKit.isDarkMode() ? R.drawable.icon_avatar_dark : R.drawable.icon_avatar_light)).apply((BaseRequestOptions)RequestOptions.circleCropTransform()).into(ivProfile);
    }

    public static void drawThumbnail(final RoundCornerView view, FileMessage message) {
        String url = message.getUrl();
        Context context = view.getContext();
        RequestOptions options = (RequestOptions)new RequestOptions().diskCacheStrategy(DiskCacheStrategy.ALL);
        RequestBuilder builder = Glide.with((Context)context).asDrawable().apply((BaseRequestOptions)options);
        int width = context.getResources().getDimensionPixelSize(R.dimen.sb_default_thumbnail_width);
        int height = context.getResources().getDimensionPixelSize(R.dimen.sb_default_thumbnail_height);
        FileInfo fileInfo = PendingMessageRepository.getInstance().getFileInfo((BaseMessage)message);
        if (fileInfo != null) {
            width = fileInfo.getThumbnailWidth();
            height = fileInfo.getThumbnailHeight();
            builder = (RequestBuilder)builder.override(width, height);
            if (!TextUtils.isEmpty((CharSequence)fileInfo.getThumbnailPath())) {
                url = fileInfo.getThumbnailPath();
            }
        } else {
            List thumbnails = message.getThumbnails();
            FileMessage.Thumbnail thumbnail = null;
            if (thumbnails.size() > 0) {
                thumbnail = (FileMessage.Thumbnail)thumbnails.get(0);
            }
            if (thumbnail != null) {
                Logger.dev("++ thumbnail width : %s, thumbnail height : %s", thumbnail.getRealWidth(), thumbnail.getRealHeight());
                width = thumbnail.getRealWidth();
                height = thumbnail.getRealHeight();
                url = thumbnail.getUrl();
            }
            builder = (RequestBuilder)builder.override(width, height);
        }
        if (message.getType().toLowerCase().contains("image") && !message.getType().toLowerCase().contains("gif")) {
            view.getContent().setScaleType(ImageView.ScaleType.CENTER);
            builder = (RequestBuilder)((RequestBuilder)builder.placeholder(SendBirdUIKit.isDarkMode() ? R.drawable.icon_thumbnail_dark : R.drawable.icon_thumbnail_light)).error(SendBirdUIKit.isDarkMode() ? R.drawable.icon_no_thumbnail_dark : R.drawable.icon_no_thumbnail_light);
        }
        ((RequestBuilder)builder.load(url).centerCrop()).thumbnail(0.3f).listener((RequestListener)new RequestListener<Drawable>(){

            public boolean onLoadFailed(@Nullable GlideException e, Object model, Target<Drawable> target, boolean isFirstResource) {
                return false;
            }

            public boolean onResourceReady(Drawable resource, Object model, Target<Drawable> target, DataSource dataSource, boolean isFirstResource) {
                view.getContent().setScaleType(ImageView.ScaleType.CENTER_CROP);
                return false;
            }
        }).into(view.getContent());
    }

    public static void drawThumbnailIcon(ImageView imageView, FileMessage fileMessage) {
        String type = fileMessage.getType();
        if (type.toLowerCase().contains("gif")) {
            imageView.setImageResource(R.drawable.icon_gif);
        } else if (type.toLowerCase().contains("video")) {
            imageView.setImageResource(R.drawable.icon_play);
        } else {
            imageView.setImageResource(17170445);
        }
    }

    public static void drawFileIcon(ImageView imageView, FileMessage fileMessage) {
        SendBirdUIKit.ThemeMode theme = SendBirdUIKit.getDefaultThemeMode();
        if (fileMessage.getType().toLowerCase().startsWith("audio")) {
            imageView.setImageDrawable(DrawableUtils.setTintList(imageView.getContext(), R.drawable.icon_file_audio, theme.getTintResId()));
        } else {
            imageView.setImageDrawable(DrawableUtils.setTintList(imageView.getContext(), R.drawable.icon_file_document, theme.getTintResId()));
        }
    }
}

