/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.utils;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import androidx.core.app.ActivityCompat;
import androidx.core.content.PermissionChecker;
import java.util.ArrayList;
import java.util.List;

public class PermissionUtils {
    private PermissionUtils() {
    }

    public static boolean hasPermissions(Context context, String ... permissions) {
        if (Build.VERSION.SDK_INT >= 23) {
            for (String permission2 : permissions) {
                if (PermissionChecker.checkSelfPermission((Context)context, (String)permission2) == 0) continue;
                return false;
            }
        }
        return true;
    }

    public static String[] getNotGrantedPermissions(Context context, String ... permissions) {
        ArrayList<String> notGrantedPermissions = new ArrayList<String>();
        for (String perm : permissions) {
            if (PermissionUtils.hasPermissions(context, perm)) continue;
            notGrantedPermissions.add(perm);
        }
        return notGrantedPermissions.toArray(new String[0]);
    }

    public static List<String> getShowRequestPermissionRationale(Activity activity, String ... permissions) {
        ArrayList<String> result = new ArrayList<String>();
        if (Build.VERSION.SDK_INT >= 23) {
            for (String permission2 : permissions) {
                if (!ActivityCompat.shouldShowRequestPermissionRationale((Activity)activity, (String)permission2)) continue;
                result.add(permission2);
            }
        }
        return result;
    }
}

