/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.model;

import androidx.annotation.NonNull;
import com.sendbird.android.Emoji;
import com.sendbird.android.EmojiCategory;
import com.sendbird.android.EmojiContainer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;

public final class EmojiManager {
    private String emojiHash = null;
    private final Object emojiLock = new Object();
    private LinkedHashMap<Long, EmojiCategory> emojiCategoryMap = new LinkedHashMap();
    private LinkedHashMap<String, Emoji> allEmojiMap = new LinkedHashMap();

    private EmojiManager() {
    }

    public static EmojiManager getInstance() {
        return EmojiManagerHolder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upsertEmojiContainer(@NonNull EmojiContainer emojiContainer) {
        this.emojiHash = emojiContainer.getEmojiHash();
        Object object = this.emojiLock;
        synchronized (object) {
            this.emojiCategoryMap = new LinkedHashMap();
            this.allEmojiMap = new LinkedHashMap();
            for (EmojiCategory emojiCategory : emojiContainer.getEmojiCategories()) {
                this.emojiCategoryMap.put(emojiCategory.getId(), emojiCategory);
                for (Emoji emoji : emojiCategory.getEmojis()) {
                    this.allEmojiMap.put(emoji.getKey(), emoji);
                }
            }
        }
    }

    public String getEmojiHash() {
        return this.emojiHash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getEmojiUrl(String key) {
        Object object = this.emojiLock;
        synchronized (object) {
            Emoji emoji;
            if (this.allEmojiMap != null && (emoji = this.allEmojiMap.get(key)) != null) {
                return emoji.getUrl();
            }
        }
        return null;
    }

    public List<EmojiCategory> getAllEmojiCategories() {
        ArrayList<EmojiCategory> emojiCategoryList = new ArrayList<EmojiCategory>(this.emojiCategoryMap.values());
        return Collections.unmodifiableList(emojiCategoryList);
    }

    public List<Emoji> getAllEmojis() {
        ArrayList<Emoji> emojiList = new ArrayList<Emoji>(this.allEmojiMap.values());
        return Collections.unmodifiableList(emojiList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Emoji> getEmojis(long emojiCategoryId) {
        Object object = this.emojiLock;
        synchronized (object) {
            EmojiCategory emojiCategory = this.emojiCategoryMap.get(emojiCategoryId);
            if (emojiCategory != null) {
                return Collections.unmodifiableList(emojiCategory.getEmojis());
            }
        }
        return null;
    }

    private static class EmojiManagerHolder {
        static final EmojiManager INSTANCE = new EmojiManager();

        private EmojiManagerHolder() {
        }
    }
}

