/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.fragments;

import android.os.Bundle;
import android.view.View;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.StringRes;
import androidx.annotation.StyleRes;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.GroupChannelMemberListQuery;
import com.sendbird.android.Member;
import com.sendbird.uikit.R;
import com.sendbird.uikit.SendBirdUIKit;
import com.sendbird.uikit.activities.adapter.MemberListAdapter;
import com.sendbird.uikit.fragments.MemberTypeListFragment;
import com.sendbird.uikit.interfaces.CustomMemberListQueryHandler;
import com.sendbird.uikit.interfaces.LoadingDialogHandler;
import com.sendbird.uikit.interfaces.OnItemClickListener;
import com.sendbird.uikit.interfaces.OnItemLongClickListener;
import com.sendbird.uikit.interfaces.OnListResultHandler;
import com.sendbird.uikit.model.DialogListItem;
import com.sendbird.uikit.utils.DialogUtils;

public class MutedMemberListFragment
extends MemberTypeListFragment
implements LoadingDialogHandler {
    @Override
    protected void onConfigure() {
        super.onConfigure();
        if (this.customQueryHandler == null) {
            this.setCustomQueryHandler(new MutedMembersQueryHandler(this.channel));
        }
    }

    @Override
    protected void onActionItemClicked(View view, int position, Member member) {
        if (this.getContext() == null || this.getFragmentManager() == null) {
            return;
        }
        DialogListItem unMute = new DialogListItem(R.string.sb_text_unmute_member);
        DialogListItem[] items = new DialogListItem[]{unMute};
        DialogUtils.buildItems(member.getNickname(), (int)this.getResources().getDimension(R.dimen.sb_dialog_width_280), items, (v, p, key) -> this.unmuteUser(member.getUserId())).showSingle(this.getFragmentManager());
    }

    private void unmuteUser(@NonNull String userId) {
        this.loadingDialogHandler.shouldShowLoadingDialog();
        this.channel.unmuteUserWithUserId(userId, e -> {
            this.loadingDialogHandler.shouldDismissLoadingDialog();
            if (e != null) {
                this.toastError(R.string.sb_text_error_unmute_member);
            }
        });
    }

    @Override
    public boolean shouldShowLoadingDialog() {
        this.showWaitingDialog();
        return true;
    }

    @Override
    public void shouldDismissLoadingDialog() {
        this.dismissWaitingDialog();
    }

    public static class Builder {
        private final Bundle bundle = new Bundle();
        private MutedMemberListFragment customFragment;
        private View.OnClickListener headerLeftButtonListener;
        private View.OnClickListener headerRightButtonListener;
        private MemberListAdapter adapter;
        private OnItemClickListener<Member> itemClickListener;
        private OnItemLongClickListener<Member> itemLongClickListener;
        private OnItemClickListener<Member> actionItemClickListener;
        private OnItemClickListener<Member> profileClickListener;
        private LoadingDialogHandler loadingDialogHandler;

        public Builder(@NonNull String channelUrl) {
            this(channelUrl, SendBirdUIKit.getDefaultThemeMode());
        }

        public Builder(@NonNull String channelUrl, SendBirdUIKit.ThemeMode themeMode) {
            this(channelUrl, themeMode.getResId());
        }

        public Builder(@NonNull String channelUrl, @StyleRes int customThemeResId) {
            this.bundle.putInt("KEY_THEME_RES_ID", customThemeResId);
            this.bundle.putString("KEY_CHANNEL_URL", channelUrl);
        }

        public <T extends MutedMemberListFragment> Builder setCustomMutedMemberFragment(T fragment) {
            this.customFragment = fragment;
            return this;
        }

        public Builder setHeaderTitle(String title) {
            this.bundle.putString("KEY_HEADER_TITLE", title);
            return this;
        }

        public Builder setUseHeader(boolean useHeader) {
            this.bundle.putBoolean("KEY_USE_HEADER", useHeader);
            return this;
        }

        public Builder setUseHeaderRightButton(boolean useHeaderRightButton) {
            this.bundle.putBoolean("KEY_USE_HEADER_RIGHT_BUTTON", useHeaderRightButton);
            return this;
        }

        public Builder setUseHeaderLeftButton(boolean useHeaderLeftButton) {
            this.bundle.putBoolean("KEY_USE_HEADER_LEFT_BUTTON", useHeaderLeftButton);
            return this;
        }

        public Builder setHeaderLeftButtonIconResId(@DrawableRes int resId) {
            this.bundle.putInt("KEY_HEADER_LEFT_BUTTON_ICON_RES_ID", resId);
            return this;
        }

        public Builder setHeaderRightButtonIconResId(@DrawableRes int resId) {
            this.bundle.putInt("KEY_HEADER_RIGHT_BUTTON_ICON_RES_ID", resId);
            return this;
        }

        public Builder setEmptyIcon(@DrawableRes int resId) {
            this.bundle.putInt("KEY_EMPTY_ICON_RES_ID", resId);
            return this;
        }

        public Builder setEmptyText(@StringRes int resId) {
            this.bundle.putInt("KEY_EMPTY_TEXT_RES_ID", resId);
            return this;
        }

        public Builder setHeaderLeftButtonListener(View.OnClickListener listener) {
            this.headerLeftButtonListener = listener;
            return this;
        }

        public Builder setHeaderRightButtonListener(View.OnClickListener listener) {
            this.headerRightButtonListener = listener;
            return this;
        }

        public <T extends MemberListAdapter> Builder setMemberListAdpater(T adapter) {
            this.adapter = adapter;
            return this;
        }

        public Builder setItemClickListener(OnItemClickListener<Member> itemClickListener) {
            this.itemClickListener = itemClickListener;
            return this;
        }

        public Builder setItemLongClickListener(OnItemLongClickListener<Member> itemLongClickListener) {
            this.itemLongClickListener = itemLongClickListener;
            return this;
        }

        public Builder setActionItemClickListener(OnItemClickListener<Member> actionItemClickListener) {
            this.actionItemClickListener = actionItemClickListener;
            return this;
        }

        public Builder setOnProfileClickListener(OnItemClickListener<Member> profileClickListener) {
            this.profileClickListener = profileClickListener;
            return this;
        }

        public Builder setUseUserProfile(boolean useUserProfile) {
            this.bundle.putBoolean("KEY_USE_USER_PROFILE", useUserProfile);
            return this;
        }

        public Builder setLoadingDialogHandler(LoadingDialogHandler loadingDialogHandler) {
            this.loadingDialogHandler = loadingDialogHandler;
            return this;
        }

        public MutedMemberListFragment build() {
            MutedMemberListFragment fragment = this.customFragment != null ? this.customFragment : new MutedMemberListFragment();
            fragment.setArguments(this.bundle);
            fragment.setMemberListAdapter(this.adapter);
            fragment.setHeaderLeftButtonListener(this.headerLeftButtonListener);
            fragment.setHeaderRightButtonListener(this.headerRightButtonListener);
            fragment.setItemClickListener(this.itemClickListener);
            fragment.setItemLongClickListener(this.itemLongClickListener);
            fragment.setActionItemClickListener(this.actionItemClickListener);
            fragment.setOnProfileClickListener(this.profileClickListener);
            fragment.setLoadingDialogHandler(this.loadingDialogHandler);
            return fragment;
        }
    }

    private static class MutedMembersQueryHandler
    implements CustomMemberListQueryHandler<Member> {
        private final GroupChannel channel;
        private GroupChannelMemberListQuery query;

        MutedMembersQueryHandler(@NonNull GroupChannel channel) {
            this.channel = channel;
        }

        @Override
        public void loadInitial(OnListResultHandler<Member> handler) {
            this.query = this.channel.createMemberListQuery();
            this.query.setLimit(30);
            this.query.setMutedMemberFilter(GroupChannelMemberListQuery.MutedMemberFilter.MUTED);
            this.load(handler);
        }

        @Override
        public void load(OnListResultHandler<Member> handler) {
            this.query.next(handler::onResult);
        }

        @Override
        public boolean hasMore() {
            return this.query.hasNext();
        }
    }
}

