/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.utils;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import androidx.annotation.NonNull;
import androidx.core.content.FileProvider;
import com.sendbird.android.FileMessage;
import com.sendbird.uikit.log.Logger;
import com.sendbird.uikit.model.FileInfo;
import com.sendbird.uikit.utils.ImageUtils;
import com.sendbird.uikit.utils.TextUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class FileUtils {
    static File getDocumentCacheDir(@NonNull Context context) {
        File dir = new File(context.getCacheDir(), "documents");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    public static File createDownloadFile(@NonNull String fileName) {
        String imageFileName = "Downloaded_file_" + System.currentTimeMillis() + "_" + fileName;
        File dir = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS);
        return new File(dir, imageFileName);
    }

    public static File getDownloadFileFromMessage(@NonNull FileMessage message) {
        String newFileName = "Downloaded_file_" + message.getMessageId() + "_" + message.getName();
        File dir = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS);
        return new File(dir, newFileName);
    }

    public static boolean hasDownloadFileFromMessage(@NonNull FileMessage message) {
        File file = FileUtils.getDownloadFileFromMessage(message);
        return file.exists() && file.length() > 0L;
    }

    public static Uri fileToUri(@NonNull Context context, @NonNull File file) {
        return FileProvider.getUriForFile((Context)context, (String)(context.getPackageName() + ".provider"), (File)file);
    }

    static String uriToPath29higher(@NonNull Context context, @NonNull Uri uri) {
        String tempFileName = "Temp_" + uri.hashCode() + ".tmp";
        File dstFile = FileUtils.createCachedDirFile(context, tempFileName);
        if (!dstFile.exists() || dstFile.length() <= 0L) {
            try {
                InputStream inputStream = context.getContentResolver().openInputStream(uri);
                FileOutputStream outputStream = new FileOutputStream(dstFile);
                FileUtils.copy(inputStream, outputStream);
            }
            catch (Exception e) {
                Logger.e(e);
            }
        }
        return dstFile.getAbsolutePath();
    }

    public static String uriToPath(@NonNull Context context, @NonNull Uri uri) {
        String path = null;
        if (Build.VERSION.SDK_INT >= 29) {
            return FileUtils.uriToPath29higher(context, uri);
        }
        if (Build.VERSION.SDK_INT >= 19 && DocumentsContract.isDocumentUri((Context)context, (Uri)uri)) {
            String id2 = DocumentsContract.getDocumentId((Uri)uri);
            if (!TextUtils.isEmpty(id2) && id2.startsWith("raw:")) {
                return id2.replaceFirst("raw:", "");
            }
            String authority = context.getPackageName() + ".provider";
            if (FileUtils.isLocalStorageDocument(authority, uri)) {
                path = id2;
            } else if (FileUtils.isExternalStorageDocument(uri)) {
                String[] split = id2.split(":");
                String type = split[0];
                if ("primary".equalsIgnoreCase(type)) {
                    path = Environment.getExternalStorageDirectory() + File.separator + split[1];
                }
            } else if (FileUtils.isDownloadsDocument(uri)) {
                String[] contentUriPrefixesToTry;
                for (String contentUriPrefix : contentUriPrefixesToTry = new String[]{"content://downloads/public_downloads", "content://downloads/my_downloads", "content://downloads/all_downloads"}) {
                    Uri contentUri = ContentUris.withAppendedId((Uri)Uri.parse((String)contentUriPrefix), (long)Long.valueOf(id2));
                    try {
                        path = FileUtils.getDataColumn(context, contentUri, null, null);
                        if (path == null) continue;
                        break;
                    }
                    catch (Exception e) {
                        Logger.w(e);
                    }
                }
                if (TextUtils.isEmpty(path)) {
                    String fileName = "Downloads_file_" + System.currentTimeMillis();
                    File cacheDir = FileUtils.getDocumentCacheDir(context);
                    File file = FileUtils.generateFileName(fileName, cacheDir);
                    String destinationPath = null;
                    if (file != null) {
                        destinationPath = file.getAbsolutePath();
                        FileUtils.saveFileFromUri(context, uri, destinationPath);
                    }
                    return destinationPath;
                }
            } else if (FileUtils.isMediaDocument(uri)) {
                String[] split = id2.split(":");
                String type = split[0];
                Uri contentUri = null;
                if ("image".equals(type)) {
                    contentUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                } else if ("video".equals(type)) {
                    contentUri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                } else if ("audio".equals(type)) {
                    contentUri = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                }
                String selection = "_id=?";
                String[] selectionArgs = new String[]{split[1]};
                path = FileUtils.getDataColumn(context, contentUri, "_id=?", selectionArgs);
            }
        }
        if (TextUtils.isEmpty(path)) {
            if ("content".equalsIgnoreCase(uri.getScheme())) {
                if (FileUtils.isGooglePhotoUri(uri)) {
                    return uri.getLastPathSegment();
                }
                path = FileUtils.getDataColumn(context, uri, null, null);
            } else {
                path = "file".equalsIgnoreCase(uri.getScheme()) ? uri.getPath() : FileUtils.getDataColumn(context, uri, null, null);
            }
        }
        return path;
    }

    public static File uriToFile(@NonNull Context context, @NonNull Uri uri) {
        return new File(FileUtils.uriToPath(context, uri));
    }

    public static File saveFile(@NonNull Context context, @NonNull File src, @NonNull String fileName) throws Exception {
        File newFile = FileUtils.createDownloadFile(fileName);
        return FileUtils.saveFile(context, src, newFile);
    }

    public static File saveFile(@NonNull Context context, @NonNull File src, @NonNull File dest) throws Exception {
        FileInputStream input = new FileInputStream(src);
        FileOutputStream output = new FileOutputStream(dest);
        FileUtils.copy(input, output);
        FileUtils.galleryAddPic(context, dest.getAbsolutePath());
        return dest;
    }

    static File bitmapToFile(@NonNull Bitmap image, @NonNull File dest, @NonNull Bitmap.CompressFormat format) throws IOException {
        FileOutputStream outputStream = new FileOutputStream(dest);
        image.compress(format, 100, (OutputStream)outputStream);
        ((OutputStream)outputStream).close();
        return dest;
    }

    private static void galleryAddPic(Context context, String imagePath) {
        Intent mediaScanIntent = new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE");
        File f = new File(imagePath);
        Uri contentUri = Uri.fromFile((File)f);
        mediaScanIntent.setData(contentUri);
        context.sendBroadcast(mediaScanIntent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveFileFromUri(Context context, Uri uri, String destinationPath) {
        InputStream is = null;
        FilterOutputStream bos = null;
        try {
            is = context.getContentResolver().openInputStream(uri);
            bos = new BufferedOutputStream(new FileOutputStream(destinationPath, false));
            byte[] buf = new byte[1024];
            is.read(buf);
            do {
                bos.write(buf);
            } while (is.read(buf) != -1);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (bos != null) {
                    bos.close();
                }
            }
            catch (IOException e) {
                Logger.e(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int copy(InputStream input, OutputStream output) throws Exception {
        int BUFFER_SIZE = 2048;
        byte[] buffer = new byte[BUFFER_SIZE];
        BufferedInputStream in = new BufferedInputStream(input, BUFFER_SIZE);
        BufferedOutputStream out = new BufferedOutputStream(output, BUFFER_SIZE);
        int count = 0;
        try {
            int n;
            while ((n = in.read(buffer, 0, BUFFER_SIZE)) != -1) {
                out.write(buffer, 0, n);
                count += n;
            }
            out.flush();
        }
        finally {
            out.close();
            in.close();
        }
        return count;
    }

    public static Uri createPictureImageUri(@NonNull Context context) {
        ContentResolver contentResolver = context.getContentResolver();
        ContentValues cv = new ContentValues();
        String fileName = new SimpleDateFormat("yyyyMMdd_HHmmss", Locale.getDefault()).format(new Date());
        cv.put("title", fileName);
        return contentResolver.insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, cv);
    }

    public static File createPictureTempFile(@NonNull Context context) throws IOException {
        String imageFileName = "Picture_file_" + System.currentTimeMillis();
        File dir = context.getExternalFilesDir(Environment.DIRECTORY_PICTURES);
        return File.createTempFile(imageFileName, ".jpg", dir);
    }

    private static void deleteRecursive(File fileOrDirectory) {
        File[] list;
        int deleteCount = 0;
        if (fileOrDirectory.isDirectory() && (list = fileOrDirectory.listFiles()) != null) {
            for (File child : list) {
                ++deleteCount;
                FileUtils.deleteRecursive(child);
            }
        }
        fileOrDirectory.delete();
    }

    public static void removeDeletableDir(@NonNull Context context) {
        File dir = FileUtils.getDeletableDir(context);
        FileUtils.deleteRecursive(dir);
    }

    private static File getDeletableDir(@NonNull Context context) {
        File dir = context.getCacheDir();
        File file = new File(dir, "deletable");
        if (!file.exists()) {
            file.mkdir();
        }
        return file;
    }

    private static File createDeletableFile(@NonNull Context context, @NonNull String fileName) {
        return new File(FileUtils.getDeletableDir(context), fileName);
    }

    public static File createCachedDirFile(@NonNull Context context, @NonNull String fileName) {
        File dir = context.getCacheDir();
        return new File(dir, fileName);
    }

    public static File createPictureTempFileWithName(@NonNull Context context, @NonNull String fileName) throws IOException {
        File dir = context.getExternalFilesDir(Environment.DIRECTORY_PICTURES);
        return File.createTempFile(fileName, ".jpg", dir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileInfo getFileInfo(@NonNull Context context, @NonNull Uri uri) throws IOException {
        FileInfo fileInfo = null;
        try (Cursor cursor = context.getContentResolver().query(uri, null, null, null, null);){
            String mimeType = context.getContentResolver().getType(uri);
            String path = FileUtils.uriToPath(context, uri);
            if (cursor != null) {
                int nameIndex = cursor.getColumnIndex("_display_name");
                int sizeIndex = cursor.getColumnIndex("_size");
                if (cursor.moveToFirst()) {
                    String name = cursor.getString(nameIndex);
                    int size = (int)cursor.getLong(sizeIndex);
                    Bitmap bitmap = null;
                    if (mimeType != null) {
                        bitmap = ImageUtils.getThumbnailBitmap(path, mimeType);
                    }
                    String thumbnailPath = null;
                    int thumbnailWidth = 0;
                    int thumbnailHeight = 0;
                    if (bitmap != null) {
                        File file = FileUtils.bitmapToFile(bitmap, FileUtils.createDeletableFile(context, name), Bitmap.CompressFormat.JPEG);
                        thumbnailWidth = bitmap.getWidth();
                        thumbnailHeight = bitmap.getHeight();
                        if (file.length() > 0L) {
                            thumbnailPath = file.getAbsolutePath();
                        }
                    }
                    fileInfo = new FileInfo(path, size, mimeType, name, uri, thumbnailWidth, thumbnailHeight, thumbnailPath);
                }
            }
        }
        return fileInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDataColumn(Context context, Uri uri, String selection, String[] selectionArgs) {
        Cursor cursor = null;
        String column = "_data";
        String[] projection = new String[]{"_data"};
        try {
            cursor = context.getContentResolver().query(uri, projection, selection, selectionArgs, null);
            if (cursor != null && cursor.moveToFirst()) {
                Logger.dev("dump cursor:" + DatabaseUtils.dumpCursorToString((Cursor)cursor));
                int column_index = cursor.getColumnIndexOrThrow("_data");
                String string2 = cursor.getString(column_index);
                return string2;
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return null;
    }

    public static String getFileName(@NonNull Context context, Uri uri) {
        String mimeType = context.getContentResolver().getType(uri);
        String filename = null;
        if (mimeType == null && context != null) {
            String path = FileUtils.getPath(context, uri);
            if (path == null) {
                filename = FileUtils.getName(uri.toString());
            } else {
                File file = new File(path);
                filename = file.getName();
            }
        } else {
            Cursor returnCursor = context.getContentResolver().query(uri, null, null, null, null);
            if (returnCursor != null) {
                int nameIndex = returnCursor.getColumnIndex("_display_name");
                returnCursor.moveToFirst();
                filename = returnCursor.getString(nameIndex);
                returnCursor.close();
            }
        }
        return filename;
    }

    private static String getName(String filename) {
        if (filename == null) {
            return null;
        }
        int index = filename.lastIndexOf(47);
        return filename.substring(index + 1);
    }

    private static String getPath(Context context, Uri uri) {
        String absolutePath = FileUtils.uriToPath(context, uri);
        return absolutePath != null ? absolutePath : uri.toString();
    }

    static File generateFileName(String name, File directory) {
        if (name == null) {
            return null;
        }
        File file = new File(directory, name);
        if (file.exists()) {
            String fileName = name;
            String extension = "";
            int dotIndex = name.lastIndexOf(46);
            if (dotIndex > 0) {
                fileName = name.substring(0, dotIndex);
                extension = name.substring(dotIndex);
            }
            int index = 0;
            while (file.exists()) {
                name = fileName + '(' + ++index + ')' + extension;
                file = new File(directory, name);
            }
        }
        try {
            if (!file.createNewFile()) {
                return null;
            }
        }
        catch (IOException e) {
            Logger.w(e);
            return null;
        }
        return file;
    }

    private static boolean isLocalStorageDocument(String authority, Uri uri) {
        return authority.equals(uri.getAuthority());
    }

    private static boolean isExternalStorageDocument(Uri uri) {
        return "com.android.externalstorage.documents".equals(uri.getAuthority());
    }

    private static boolean isDownloadsDocument(Uri uri) {
        return "com.android.providers.downloads.documents".equals(uri.getAuthority());
    }

    private static boolean isMediaDocument(Uri uri) {
        return "com.android.providers.media.documents".equals(uri.getAuthority());
    }

    private static boolean isGooglePhotoUri(Uri uri) {
        return "com.google.android.apps.photos.content".equals(uri.getAuthority());
    }
}

