/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.fragments;

import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.PopupWindow;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.GroupChannelParams;
import com.sendbird.android.SendBird;
import com.sendbird.android.User;
import com.sendbird.uikit.R;
import com.sendbird.uikit.SendBirdUIKit;
import com.sendbird.uikit.activities.ChannelActivity;
import com.sendbird.uikit.dialogs.DialogHelper;
import com.sendbird.uikit.interfaces.CustomParamsHandler;
import com.sendbird.uikit.interfaces.LoadingDialogHandler;
import com.sendbird.uikit.interfaces.OnItemClickListener;
import com.sendbird.uikit.log.Logger;
import com.sendbird.uikit.widgets.UserProfile;
import com.sendbird.uikit.widgets.WaitingDialog;
import java.util.Collections;

class UserProfileDialog
implements LoadingDialogHandler {
    private static final Handler mainHandler = new Handler(Looper.getMainLooper());
    private final PopupWindow window;
    private final Context context;
    private final User data;
    private final OnItemClickListener<User> listener;
    private final LoadingDialogHandler loadingDialogHandler;

    private UserProfileDialog(@NonNull Context context, @NonNull User data, @Nullable OnItemClickListener<User> listener, LoadingDialogHandler loadingDialogHandler) {
        this.context = context;
        this.data = data;
        this.listener = listener;
        this.window = new PopupWindow(-1, -2);
        this.loadingDialogHandler = loadingDialogHandler == null ? this : loadingDialogHandler;
    }

    @Override
    public boolean shouldShowLoadingDialog() {
        WaitingDialog.show(this.context);
        return true;
    }

    @Override
    public void shouldDismissLoadingDialog() {
        WaitingDialog.dismiss();
    }

    public void show() {
        mainHandler.post(() -> {
            Logger.d(">> UserProfileDialog::show()");
            this.window.setFocusable(true);
            UserProfile userProfile = new UserProfile(this.context);
            userProfile.drawUserProfile(this.data);
            userProfile.setOnItemClickListener((view, position, menuItem) -> {
                this.window.dismiss();
                if (this.listener != null) {
                    this.listener.onItemClick(view, position, (User)menuItem);
                } else {
                    this.createDirectChannel();
                }
            });
            this.window.setContentView((View)userProfile);
            this.window.setOutsideTouchable(true);
            this.window.setAnimationStyle(R.style.Animation_SendBird_Dialog);
            this.window.setBackgroundDrawable((Drawable)new ColorDrawable(0));
            this.window.showAtLocation(this.window.getContentView(), 80, 0, 0);
            UserProfileDialog.dimBehind(this.window);
        });
    }

    public void dismiss() {
        mainHandler.post(() -> {
            try {
                Logger.d(">> UserProfileDialog::dismiss()");
                this.window.dismiss();
            }
            catch (Exception e) {
                Logger.d(e);
            }
        });
    }

    private static void dimBehind(PopupWindow popupWindow) {
        View parent = popupWindow.getContentView().getRootView();
        Context context = parent.getContext();
        WindowManager wm = (WindowManager)context.getSystemService("window");
        WindowManager.LayoutParams wlp = (WindowManager.LayoutParams)parent.getLayoutParams();
        if (wlp != null) {
            wlp.flags |= 2;
            wlp.dimAmount = 0.5f;
            if (wm != null) {
                wm.updateViewLayout(parent, (ViewGroup.LayoutParams)wlp);
            }
        }
    }

    private void createDirectChannel() {
        GroupChannelParams params = new GroupChannelParams();
        params.addUserId(this.data.getUserId());
        params.setName("");
        params.setCoverUrl("");
        params.setOperators(Collections.singletonList(SendBird.getCurrentUser()));
        CustomParamsHandler cutsomHandler = SendBirdUIKit.getCustomParamsHandler();
        if (cutsomHandler != null) {
            cutsomHandler.onBeforeCreateGroupChannel(params);
        }
        this.loadingDialogHandler.shouldShowLoadingDialog();
        GroupChannel.createChannel((GroupChannelParams)params, (channel, e) -> {
            this.loadingDialogHandler.shouldDismissLoadingDialog();
            if (e != null) {
                DialogHelper.toastError(this.context, R.string.sb_text_error_create_channel);
                Logger.e((Throwable)e);
                return;
            }
            this.context.startActivity(ChannelActivity.newIntent(this.context, channel.getUrl()));
        });
    }

    static class Builder {
        private final Context context;
        private final User data;
        private OnItemClickListener<User> listener;
        private LoadingDialogHandler loadingDialogHandler;

        public Builder(@NonNull Context context, @NonNull User data) {
            this.context = context;
            this.data = data;
        }

        public Builder setOnItemClickListener(OnItemClickListener<User> listener) {
            this.listener = listener;
            return this;
        }

        public Builder setLoadingDialogHandler(LoadingDialogHandler loadingDialogHandler) {
            this.loadingDialogHandler = loadingDialogHandler;
            return this;
        }

        public UserProfileDialog build() {
            return new UserProfileDialog(this.context, this.data, this.listener, this.loadingDialogHandler);
        }
    }
}

