/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.activities.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.sendbird.android.Member;
import com.sendbird.android.User;
import com.sendbird.uikit.activities.adapter.BaseAdapter;
import com.sendbird.uikit.activities.viewholder.BaseViewHolder;
import com.sendbird.uikit.databinding.SbViewMemberPreviewBinding;
import com.sendbird.uikit.interfaces.OnItemClickListener;
import com.sendbird.uikit.interfaces.OnItemLongClickListener;
import com.sendbird.uikit.widgets.MemberPreview;
import java.util.Collections;
import java.util.List;

public class UserTypeListAdapter
extends BaseAdapter<User, BaseViewHolder<User>> {
    private List<User> users;
    private OnItemClickListener<User> listener;
    private OnItemLongClickListener<User> longClickListener;
    private OnItemClickListener<User> actionItemClickListener;
    private Member.Role myRole = Member.Role.NONE;
    private OnItemClickListener<User> profileClickListener;

    @NonNull
    public BaseViewHolder<User> onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new UserPreviewHolder(SbViewMemberPreviewBinding.inflate(LayoutInflater.from((Context)parent.getContext()), parent, false));
    }

    public void onBindViewHolder(@NonNull BaseViewHolder<User> holder, int position) {
        holder.bind(this.getItem(position));
    }

    public int getItemCount() {
        return this.users == null ? 0 : this.users.size();
    }

    @Override
    public User getItem(int position) {
        return this.users != null ? this.users.get(position) : null;
    }

    @Override
    public List<User> getItems() {
        return this.users != null ? Collections.unmodifiableList(this.users) : null;
    }

    public long getItemId(int position) {
        return this.getItem(position).hashCode();
    }

    public void setOnItemClickListener(@Nullable OnItemClickListener<User> listener) {
        this.listener = listener;
    }

    public void setOnItemLongClickListener(@Nullable OnItemLongClickListener<User> listener) {
        this.longClickListener = listener;
    }

    public void setOnActionItemClickListener(@Nullable OnItemClickListener<User> listener) {
        this.actionItemClickListener = listener;
    }

    public void setOnProfileClickListener(OnItemClickListener<User> profileClickListener) {
        this.profileClickListener = profileClickListener;
    }

    public void setItems(List<User> userList, Member.Role myRole) {
        this.users = userList;
        this.myRole = myRole;
        this.notifyDataSetChanged();
    }

    private class UserPreviewHolder
    extends BaseViewHolder<User> {
        private SbViewMemberPreviewBinding binding;

        UserPreviewHolder(SbViewMemberPreviewBinding binding) {
            super(binding.getRoot());
            this.binding = binding;
            binding.memberViewHolder.setOnClickListener(v -> {
                int userPosition = this.getAdapterPosition();
                if (userPosition != -1 && UserTypeListAdapter.this.listener != null) {
                    User user = UserTypeListAdapter.this.getItem(userPosition);
                    UserTypeListAdapter.this.listener.onItemClick(v, userPosition, user);
                }
            });
            binding.memberViewHolder.setOnLongClickListener(v -> {
                int userPosition = this.getAdapterPosition();
                if (userPosition != -1 && UserTypeListAdapter.this.longClickListener != null) {
                    UserTypeListAdapter.this.longClickListener.onItemLongClick(v, userPosition, UserTypeListAdapter.this.getItem(userPosition));
                    return true;
                }
                return false;
            });
            binding.memberViewHolder.setOnActionMenuClickListener(v -> {
                int userPosition = this.getAdapterPosition();
                if (userPosition != -1 && UserTypeListAdapter.this.actionItemClickListener != null) {
                    User user = UserTypeListAdapter.this.getItem(userPosition);
                    UserTypeListAdapter.this.actionItemClickListener.onItemClick(v, userPosition, user);
                }
            });
            binding.memberViewHolder.setOnProfileClickListener(v -> {
                int userPosition = this.getAdapterPosition();
                if (userPosition != -1 && UserTypeListAdapter.this.profileClickListener != null) {
                    User user = UserTypeListAdapter.this.getItem(userPosition);
                    UserTypeListAdapter.this.profileClickListener.onItemClick(v, userPosition, user);
                }
            });
        }

        @Override
        public void bind(User user) {
            this.binding.memberViewHolder.useActionMenu(UserTypeListAdapter.this.myRole == Member.Role.OPERATOR && UserTypeListAdapter.this.actionItemClickListener != null);
            MemberPreview.drawMemberFromUser(this.binding.memberViewHolder, user);
            this.binding.executePendingBindings();
        }
    }
}

