/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.widgets;

import android.graphics.RectF;
import android.text.Layout;
import android.text.Selection;
import android.text.Spannable;
import android.text.method.LinkMovementMethod;
import android.text.style.BackgroundColorSpan;
import android.text.style.ClickableSpan;
import android.text.style.ForegroundColorSpan;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.widget.TextView;
import com.sendbird.uikit.log.Logger;

class SBLinkMovementMethod
extends LinkMovementMethod {
    private OnLinkClickListener onLinkClickListener;
    private OnLinkLongClickListener onLinkLongClickListener;
    private LongPressTimer longPressTimer;
    private BackgroundColorSpan backgroundColorSpan;
    private ForegroundColorSpan foregroundColorSpan;
    private int activateTextViewHashcode = 0;
    private RectF touchedLineBounded = new RectF();
    private boolean longPressedRegistered = false;
    private ClickableSpan prevLink = null;

    private SBLinkMovementMethod() {
    }

    private SBLinkMovementMethod(OnLinkClickListener onLinkClickListener, OnLinkLongClickListener onLinkLongClickListener, int clickedLinkTextColor, int clickedLinkBackgroundColor) {
        this.onLinkClickListener = onLinkClickListener;
        this.onLinkLongClickListener = onLinkLongClickListener;
        if (clickedLinkBackgroundColor != 0) {
            this.backgroundColorSpan = new BackgroundColorSpan(clickedLinkBackgroundColor);
        }
        if (clickedLinkTextColor != 0) {
            this.foregroundColorSpan = new ForegroundColorSpan(clickedLinkTextColor);
        }
    }

    public boolean onTouchEvent(TextView widget, Spannable buffer, MotionEvent event) {
        if (this.activateTextViewHashcode != widget.hashCode()) {
            this.activateTextViewHashcode = widget.hashCode();
            widget.setAutoLinkMask(0);
        }
        int touchX = (int)event.getX();
        int touchY = (int)event.getY();
        touchX -= widget.getTotalPaddingLeft();
        touchY -= widget.getTotalPaddingTop();
        Layout layout2 = widget.getLayout();
        int touchedLine = layout2.getLineForVertical(touchY += widget.getScrollY());
        int touchOffset = layout2.getOffsetForHorizontal(touchedLine, (float)(touchX += widget.getScrollX()));
        this.touchedLineBounded.left = layout2.getLineLeft(touchedLine);
        this.touchedLineBounded.top = layout2.getLineTop(touchedLine);
        this.touchedLineBounded.right = layout2.getLineWidth(touchedLine) + this.touchedLineBounded.left;
        this.touchedLineBounded.bottom = layout2.getLineBottom(touchedLine);
        if (!this.touchedLineBounded.contains((float)touchX, (float)touchY)) {
            this.clearTouchEvent(widget, buffer);
            return false;
        }
        ClickableSpan[] links = (ClickableSpan[])buffer.getSpans(touchOffset, touchOffset, ClickableSpan.class);
        if (links.length <= 0 || links[0] == null) {
            this.clearTouchEvent(widget, buffer);
            return false;
        }
        ClickableSpan link = links[0];
        if (event.getAction() == 0) {
            this.prevLink = link;
        }
        switch (event.getAction()) {
            case 0: {
                Logger.d("ACTION_DOWN for link");
                this.drawClickedLink(link, buffer);
                widget.cancelLongPress();
                LongPressTimer.OnTimerReachedListener onTimerReachedListener = () -> {
                    this.longPressedRegistered = true;
                    widget.performHapticFeedback(0);
                    this.eraseClickedLink(buffer);
                    if (this.onLinkLongClickListener != null) {
                        this.onLinkLongClickListener.onLongClick(widget, buffer.toString().substring(buffer.getSpanStart((Object)link), buffer.getSpanEnd((Object)link)));
                    } else {
                        link.onClick((View)widget);
                    }
                };
                this.longPressTimer = new LongPressTimer();
                this.longPressTimer.setOnTimerReachedListener(onTimerReachedListener);
                widget.postDelayed((Runnable)this.longPressTimer, (long)ViewConfiguration.getLongPressTimeout());
                return true;
            }
            case 1: {
                Logger.d("ACTION_UP for link");
                if (!this.longPressedRegistered && link == this.prevLink) {
                    if (this.onLinkClickListener != null) {
                        this.onLinkClickListener.onClick(widget, buffer.toString().substring(buffer.getSpanStart((Object)link), buffer.getSpanEnd((Object)link)));
                    } else {
                        link.onClick((View)widget);
                    }
                }
                this.clearTouchEvent(widget, buffer);
                return true;
            }
            case 2: {
                if (!this.longPressedRegistered) {
                    this.drawClickedLink(link, buffer);
                }
                if (link != this.prevLink) {
                    this.clearTouchEvent(widget, buffer);
                }
                return true;
            }
        }
        this.clearTouchEvent(widget, buffer);
        return false;
    }

    private void drawClickedLink(ClickableSpan clickableSpan, Spannable text) {
        int spanStart = text.getSpanStart((Object)clickableSpan);
        int spanEnd = text.getSpanEnd((Object)clickableSpan);
        if (this.backgroundColorSpan != null) {
            text.setSpan((Object)this.backgroundColorSpan, spanStart, spanEnd, 18);
        }
        if (this.foregroundColorSpan != null) {
            text.setSpan((Object)this.foregroundColorSpan, spanStart, spanEnd, 18);
        }
        Selection.setSelection((Spannable)text, (int)spanStart, (int)spanEnd);
    }

    private void eraseClickedLink(Spannable text) {
        text.removeSpan((Object)this.backgroundColorSpan);
        text.removeSpan((Object)this.foregroundColorSpan);
        Selection.removeSelection((Spannable)text);
    }

    private void clearTouchEvent(TextView widget, Spannable buffer) {
        this.eraseClickedLink(buffer);
        this.longPressedRegistered = false;
        widget.removeCallbacks((Runnable)this.longPressTimer);
        this.longPressTimer = null;
    }

    public static class Builder {
        private OnLinkClickListener onLinkClickListener;
        private OnLinkLongClickListener onLinkLongClickListener;
        private int clickedLinkTextColor;
        private int clickedLinkBackgroundColor;

        public Builder setOnLinkClickListener(OnLinkClickListener onLinkClickListener) {
            this.onLinkClickListener = onLinkClickListener;
            return this;
        }

        public Builder setOnLinkLongClickListener(OnLinkLongClickListener onLinkLongClickListener) {
            this.onLinkLongClickListener = onLinkLongClickListener;
            return this;
        }

        public Builder setClickedLinkTextColor(int clickedLinkTextColor) {
            this.clickedLinkTextColor = clickedLinkTextColor;
            return this;
        }

        public Builder setClickedLinkBackgroundColor(int clickedLinkBackgroundColor) {
            this.clickedLinkBackgroundColor = clickedLinkBackgroundColor;
            return this;
        }

        public SBLinkMovementMethod create() {
            return new SBLinkMovementMethod(this.onLinkClickListener, this.onLinkLongClickListener, this.clickedLinkTextColor, this.clickedLinkBackgroundColor);
        }
    }

    private static final class LongPressTimer
    implements Runnable {
        private OnTimerReachedListener onTimerReachedListener;

        private LongPressTimer() {
        }

        @Override
        public void run() {
            this.onTimerReachedListener.onTimerReached();
        }

        public void setOnTimerReachedListener(OnTimerReachedListener onTimerReachedListener) {
            this.onTimerReachedListener = onTimerReachedListener;
        }

        private static interface OnTimerReachedListener {
            public void onTimerReached();
        }
    }

    public static interface OnLinkLongClickListener {
        public boolean onLongClick(TextView var1, String var2);
    }

    public static interface OnLinkClickListener {
        public boolean onClick(TextView var1, String var2);
    }
}

