/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.fragments;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import androidx.databinding.DataBindingUtil;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.User;
import com.sendbird.uikit.R;
import com.sendbird.uikit.SendBirdUIKit;
import com.sendbird.uikit.activities.BannedListActivity;
import com.sendbird.uikit.activities.MutedMemberListActivity;
import com.sendbird.uikit.activities.OperatorListActivity;
import com.sendbird.uikit.databinding.SbFragmentModerationsBinding;
import com.sendbird.uikit.fragments.BaseFragment;
import com.sendbird.uikit.interfaces.OnMenuItemClickListener;
import com.sendbird.uikit.log.Logger;
import com.sendbird.uikit.model.ReadyStatus;

public class ModerationFragment
extends BaseFragment {
    private SbFragmentModerationsBinding binding;
    protected View.OnClickListener headerLeftButtonListener;
    protected OnMenuItemClickListener<ModerationMenu, GroupChannel> menuItemClickListener;

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Logger.i(">> ModerationFragment::onCreate()", new Object[0]);
        Bundle args = this.getArguments();
        int themeResId = SendBirdUIKit.getDefaultThemeMode().getResId();
        if (args != null) {
            themeResId = args.getInt("KEY_THEME_RES_ID");
        }
        if (this.getActivity() != null) {
            this.getActivity().setTheme(themeResId);
        }
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.binding = (SbFragmentModerationsBinding)DataBindingUtil.inflate((LayoutInflater)inflater, (int)R.layout.sb_fragment_moderations, (ViewGroup)container, (boolean)false);
        return this.binding.getRoot();
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.initHeaderOnCreated();
    }

    @Override
    public void onReady(User user, ReadyStatus status) {
        this.onConfigure();
        this.onDrawPage();
    }

    protected void onConfigure() {
    }

    protected void onDrawPage() {
        this.initHeaderOnReady();
        this.initModerations(this.channel);
    }

    private void initHeaderOnCreated() {
        Bundle args = this.getArguments();
        String headerTitle = this.getString(R.string.sb_text_channel_settings_moderations);
        boolean useHeader = false;
        boolean useHeaderLeftButton = true;
        int headerLeftButtonIconResId = R.drawable.icon_arrow_left;
        if (args != null) {
            headerTitle = args.getString("KEY_HEADER_TITLE", this.getString(R.string.sb_text_channel_settings_moderations));
            useHeader = args.getBoolean("KEY_USE_HEADER", false);
            useHeaderLeftButton = args.getBoolean("KEY_USE_HEADER_LEFT_BUTTON", true);
            headerLeftButtonIconResId = args.getInt("KEY_HEADER_LEFT_BUTTON_ICON_RES_ID", R.drawable.icon_arrow_left);
        }
        this.binding.abSettingsHeader.setVisibility(useHeader ? 0 : 8);
        this.binding.abSettingsHeader.getTitleTextView().setText((CharSequence)headerTitle);
        this.binding.abSettingsHeader.setUseLeftImageButton(useHeaderLeftButton);
        this.binding.abSettingsHeader.getLeftImageButton().setImageResource(headerLeftButtonIconResId);
        this.binding.abSettingsHeader.getLeftImageButton().setOnClickListener(v -> this.finish());
    }

    private void initHeaderOnReady() {
        if (this.headerLeftButtonListener != null) {
            this.binding.abSettingsHeader.getLeftImageButton().setOnClickListener(this.headerLeftButtonListener);
        }
    }

    private void initModerations(@NonNull GroupChannel channel) {
        this.binding.vgContent.setBackgroundResource(SendBirdUIKit.isDarkMode() ? R.color.background_600 : R.color.background_100);
        this.binding.operatorsItem.setOnClickListener(v -> {
            Logger.dev("++ operation item clicked");
            if (this.menuItemClickListener != null && this.menuItemClickListener.onMenuItemClicked(v, ModerationMenu.OPERATORS, channel)) {
                return;
            }
            this.startActivity(OperatorListActivity.newIntent(this.getContext(), channel.getUrl()));
        });
        this.binding.freezeChannelItem.setChecked(channel.isFrozen());
        this.binding.mutedMembersItem.setOnClickListener(v -> {
            Logger.dev("++ muted item clicked");
            if (this.menuItemClickListener != null && this.menuItemClickListener.onMenuItemClicked(v, ModerationMenu.MUTED_MEMBERS, channel)) {
                return;
            }
            this.startActivity(MutedMemberListActivity.newIntent(this.getContext(), channel.getUrl()));
        });
        this.binding.bannedMembersItem.setOnClickListener(v -> {
            Logger.dev("++ banned item clicked");
            if (this.menuItemClickListener != null && this.menuItemClickListener.onMenuItemClicked(v, ModerationMenu.BANNED_MEMBERS, channel)) {
                return;
            }
            this.startActivity(BannedListActivity.newIntent(this.getContext(), channel.getUrl()));
        });
        this.binding.freezeChannelItem.setOnClickListener(v -> {
            Logger.dev("++ freeze item clicked");
            if (this.menuItemClickListener != null && this.menuItemClickListener.onMenuItemClicked(v, ModerationMenu.FREEZE_CHANNEL, channel)) {
                return;
            }
            this.freezeOrUnFreezeChannel(channel);
        });
        this.binding.freezeChannelItem.setOnActionMenuClickListener(v -> {
            Logger.dev("++ menu action clicked");
            if (this.menuItemClickListener != null && this.menuItemClickListener.onMenuItemClicked(v, ModerationMenu.FREEZE_CHANNEL, channel)) {
                return;
            }
            this.freezeOrUnFreezeChannel(channel);
        });
        this.binding.mutedMembersItem.setVisibility(channel.isBroadcast() ? 8 : 0);
        this.binding.freezeChannelItem.setVisibility(channel.isBroadcast() ? 8 : 0);
    }

    private void freezeOrUnFreezeChannel(@NonNull GroupChannel channel) {
        boolean isFrozen = channel.isFrozen();
        this.showWaitingDialog();
        if (isFrozen) {
            channel.unfreeze(e -> {
                this.dismissWaitingDialog();
                this.binding.freezeChannelItem.setChecked(e != null);
            });
        } else {
            channel.freeze(e -> {
                this.dismissWaitingDialog();
                this.binding.freezeChannelItem.setChecked(e == null);
            });
        }
    }

    protected void setHeaderLeftButtonListener(View.OnClickListener listener) {
        this.headerLeftButtonListener = listener;
    }

    protected void setOnMenuItemClickListener(OnMenuItemClickListener<ModerationMenu, GroupChannel> listener) {
        this.menuItemClickListener = listener;
    }

    public static class Builder {
        private Bundle bundle = new Bundle();
        private ModerationFragment customFragment;
        private View.OnClickListener headerLeftButtonListener;
        private OnMenuItemClickListener<ModerationMenu, GroupChannel> menuItemClickListener;

        public Builder(@NonNull String channelUrl) {
            this(channelUrl, SendBirdUIKit.getDefaultThemeMode());
        }

        public Builder(@NonNull String channelUrl, SendBirdUIKit.ThemeMode themeMode) {
            this.bundle.putInt("KEY_THEME_RES_ID", themeMode.getResId());
            this.bundle.putString("KEY_CHANNEL_URL", channelUrl);
        }

        public Builder(@NonNull String channelUrl, @StyleRes int customThemeResId) {
            this.bundle.putInt("KEY_THEME_RES_ID", customThemeResId);
            this.bundle.putString("KEY_CHANNEL_URL", channelUrl);
        }

        public <T extends ModerationFragment> Builder setCustomModerationFragment(T fragment) {
            this.customFragment = fragment;
            return this;
        }

        public Builder setHeaderTitle(String title) {
            this.bundle.putString("KEY_HEADER_TITLE", title);
            return this;
        }

        public Builder setUseHeader(boolean useHeader) {
            this.bundle.putBoolean("KEY_USE_HEADER", useHeader);
            return this;
        }

        public Builder setUseHeaderLeftButton(boolean useHeaderLeftButton) {
            this.bundle.putBoolean("KEY_USE_HEADER_LEFT_BUTTON", useHeaderLeftButton);
            return this;
        }

        public Builder setHeaderLeftButtonIconResId(@DrawableRes int resId) {
            this.bundle.putInt("KEY_HEADER_LEFT_BUTTON_ICON_RES_ID", resId);
            return this;
        }

        public Builder setHeaderLeftButtonListener(View.OnClickListener listener) {
            this.headerLeftButtonListener = listener;
            return this;
        }

        public Builder setOnMenuItemClickListener(OnMenuItemClickListener<ModerationMenu, GroupChannel> listener) {
            this.menuItemClickListener = listener;
            return this;
        }

        public ModerationFragment build() {
            ModerationFragment fragment = this.customFragment != null ? this.customFragment : new ModerationFragment();
            fragment.setArguments(this.bundle);
            fragment.setHeaderLeftButtonListener(this.headerLeftButtonListener);
            fragment.setOnMenuItemClickListener(this.menuItemClickListener);
            return fragment;
        }
    }

    public static enum ModerationMenu {
        OPERATORS,
        MUTED_MEMBERS,
        BANNED_MEMBERS,
        FREEZE_CHANNEL;

    }
}

