/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.widgets;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.databinding.DataBindingUtil;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewpager2.adapter.FragmentStateAdapter;
import com.google.android.material.tabs.TabLayout;
import com.google.android.material.tabs.TabLayoutMediator;
import com.sendbird.android.Reaction;
import com.sendbird.android.User;
import com.sendbird.uikit.R;
import com.sendbird.uikit.activities.adapter.EmojiReactionUserListAdapter;
import com.sendbird.uikit.databinding.SbFragmentUserListBinding;
import com.sendbird.uikit.databinding.SbViewEmojiReactionUserListBinding;
import com.sendbird.uikit.model.EmojiManager;
import com.sendbird.uikit.widgets.EmojiReactionCountView;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class EmojiReactionUserListView
extends FrameLayout {
    private SbViewEmojiReactionUserListBinding binding;

    public EmojiReactionUserListView(@NonNull Context context) {
        this(context, null);
    }

    public EmojiReactionUserListView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.sb_emoji_reaction_style);
    }

    public EmojiReactionUserListView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.EmojiReactionCountList, defStyleAttr, R.style.Widget_SendBird_Emoji);
        try {
            this.binding = (SbViewEmojiReactionUserListBinding)DataBindingUtil.inflate((LayoutInflater)LayoutInflater.from((Context)context), (int)R.layout.sb_view_emoji_reaction_user_list, (ViewGroup)this, (boolean)true);
            int tabLayoutBackgroundResId = a.getResourceId(R.styleable.EmojiReactionCountList_sb_emoji_reaction_count_tab_layout_background, R.drawable.sb_tab_layout_border_background_light);
            int indicatorColor = a.getColor(R.styleable.EmojiReactionCountList_sb_emoji_reaction_count_tab_indicator_color, context.getResources().getColor(R.color.primary_300));
            this.binding.tabLayoutPanel.setBackgroundResource(tabLayoutBackgroundResId);
            this.binding.tabLayout.setSelectedTabIndicatorColor(indicatorColor);
        }
        finally {
            a.recycle();
        }
    }

    public void setEmojiReactionUserData(Fragment fragment, int currentPosition, List<Reaction> reactionList, Map<Reaction, List<User>> reactionUserInfo) {
        UserListPagerAdapter pagerAdapter = new UserListPagerAdapter(fragment, reactionList, reactionUserInfo);
        this.binding.vpEmojiReactionUserList.setAdapter((RecyclerView.Adapter)pagerAdapter);
        new TabLayoutMediator(this.binding.tabLayout, this.binding.vpEmojiReactionUserList, (tab, position) -> {
            EmojiReactionCountView view = new EmojiReactionCountView(this.getContext());
            Reaction reaction = (Reaction)reactionList.get(position);
            if (reaction != null && reaction.getUserIds() != null) {
                view.setCount(reaction.getUserIds().size());
                view.setEmojiUrl(EmojiManager.getInstance().getEmojiUrl(reaction.getKey()));
            }
            tab.setCustomView((View)view);
        }).attach();
        TabLayout.Tab defaultTab = this.binding.tabLayout.getTabAt(currentPosition);
        if (defaultTab != null) {
            defaultTab.select();
        }
    }

    public static class UserListFragment
    extends Fragment {
        private SbFragmentUserListBinding binding;
        private final List<User> userList;

        UserListFragment(List<User> userList) {
            this.userList = new ArrayList<User>(userList);
        }

        public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
            this.binding = SbFragmentUserListBinding.inflate(inflater);
            return this.binding.getRoot();
        }

        public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
            super.onViewCreated(view, savedInstanceState);
            EmojiReactionUserListAdapter userListAdapter = new EmojiReactionUserListAdapter(this.userList);
            this.binding.rvUserList.setAdapter(userListAdapter);
            this.binding.rvUserList.setHasFixedSize(true);
        }
    }

    private class UserListPagerAdapter
    extends FragmentStateAdapter {
        private final int itemCount;
        private final List<Fragment> fragmentList;

        UserListPagerAdapter(@NonNull Fragment fragment, @NonNull List<Reaction> reactionList, Map<Reaction, List<User>> reactionUserInfo) {
            super(fragment);
            this.fragmentList = new ArrayList<Fragment>();
            this.itemCount = reactionUserInfo.size();
            for (Reaction reaction : reactionList) {
                List<User> userList = reactionUserInfo.get(reaction);
                this.fragmentList.add(new UserListFragment(userList));
            }
        }

        @NonNull
        public Fragment createFragment(int position) {
            return this.fragmentList.get(position);
        }

        public int getItemCount() {
            return this.itemCount;
        }
    }
}

