/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.fragments;

import android.os.Bundle;
import android.view.View;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.StringRes;
import androidx.annotation.StyleRes;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.OperatorListQuery;
import com.sendbird.android.User;
import com.sendbird.uikit.R;
import com.sendbird.uikit.SendBirdUIKit;
import com.sendbird.uikit.activities.PromoteOperatorsActivity;
import com.sendbird.uikit.activities.adapter.UserTypeListAdapter;
import com.sendbird.uikit.dialogs.DialogHelper;
import com.sendbird.uikit.fragments.UserTypeListFragment;
import com.sendbird.uikit.interfaces.CustomMemberListQueryHandler;
import com.sendbird.uikit.interfaces.OnItemClickListener;
import com.sendbird.uikit.interfaces.OnItemLongClickListener;
import com.sendbird.uikit.interfaces.OnListResultHandler;
import com.sendbird.uikit.log.Logger;
import java.util.Collections;

public class OperatorListFragment
extends UserTypeListFragment {
    @Override
    protected void onConfigure() {
        if (this.customQueryHandler == null) {
            this.setCustomQueryHandler(new OperatorQueryHandler(this.channel));
        }
        if (this.headerRightButtonListener == null) {
            this.setHeaderRightButtonListener(v -> {
                if (this.isActive() && this.getContext() != null) {
                    this.startActivity(PromoteOperatorsActivity.newIntent(this.getContext(), this.channel.getUrl()));
                }
            });
        }
    }

    @Override
    protected void onActionItemClicked(View view, int position, User user) {
        Logger.d(">> OperatorListFragment::onActionItemClicked()");
        DialogHelper.DialogListItem removeOperator = new DialogHelper.DialogListItem(R.string.sb_text_dismiss_operator);
        DialogHelper.DialogListItem[] items = new DialogHelper.DialogListItem[]{removeOperator};
        DialogHelper.showList(this.getContext(), user.getNickname(), items, key -> this.removeOperator(user.getUserId()));
    }

    private void removeOperator(@NonNull String userId) {
        Logger.d(">> OperatorListFragment::removeOperator()");
        this.showWaitingDialog();
        this.channel.removeOperators(Collections.singletonList(userId), e -> {
            this.dismissWaitingDialog();
            if (e != null) {
                this.toastError(R.string.sb_text_error_dismiss_operator);
            }
        });
    }

    public static class Builder {
        private Bundle bundle = new Bundle();
        private OperatorListFragment customFragment;
        private View.OnClickListener headerLeftButtonListener;
        private View.OnClickListener headerRightButtonListener;
        private UserTypeListAdapter adapter;
        private OnItemClickListener<User> itemClickListener;
        private OnItemLongClickListener<User> itemLongClickListener;
        private OnItemClickListener<User> actionItemClickListener;
        private OnItemClickListener<User> profileClickListener;

        public Builder(@NonNull String channelUrl) {
            this(channelUrl, SendBirdUIKit.getDefaultThemeMode());
        }

        public Builder(@NonNull String channelUrl, SendBirdUIKit.ThemeMode themeMode) {
            this(channelUrl, themeMode.getResId());
        }

        public Builder(@NonNull String channelUrl, @StyleRes int customThemeResId) {
            this.bundle.putInt("KEY_THEME_RES_ID", customThemeResId);
            this.bundle.putString("KEY_CHANNEL_URL", channelUrl);
        }

        public <T extends OperatorListFragment> Builder setCustomOperatorListFragment(T fragment) {
            this.customFragment = fragment;
            return this;
        }

        public Builder setHeaderTitle(String title) {
            this.bundle.putString("KEY_HEADER_TITLE", title);
            return this;
        }

        public Builder setUseHeader(boolean useHeader) {
            this.bundle.putBoolean("KEY_USE_HEADER", useHeader);
            return this;
        }

        public Builder setUseHeaderRightButton(boolean useHeaderRightButton) {
            this.bundle.putBoolean("KEY_USE_HEADER_RIGHT_BUTTON", useHeaderRightButton);
            return this;
        }

        public Builder setUseHeaderLeftButton(boolean useHeaderLeftButton) {
            this.bundle.putBoolean("KEY_USE_HEADER_LEFT_BUTTON", useHeaderLeftButton);
            return this;
        }

        public Builder setHeaderLeftButtonIconResId(@DrawableRes int resId) {
            this.bundle.putInt("KEY_HEADER_LEFT_BUTTON_ICON_RES_ID", resId);
            return this;
        }

        public Builder setHeaderRightButtonIconResId(@DrawableRes int resId) {
            this.bundle.putInt("KEY_HEADER_RIGHT_BUTTON_ICON_RES_ID", resId);
            return this;
        }

        public Builder setEmptyIcon(@DrawableRes int resId) {
            this.bundle.putInt("KEY_EMPTY_ICON_RES_ID", resId);
            return this;
        }

        public Builder setEmptyText(@StringRes int resId) {
            this.bundle.putInt("KEY_EMPTY_TEXT_RES_ID", resId);
            return this;
        }

        public Builder setHeaderLeftButtonListener(View.OnClickListener listener) {
            this.headerLeftButtonListener = listener;
            return this;
        }

        public Builder setHeaderRightButtonListener(View.OnClickListener listener) {
            this.headerRightButtonListener = listener;
            return this;
        }

        public <T extends UserTypeListAdapter> Builder setUserListAdapter(T adapter) {
            this.adapter = adapter;
            return this;
        }

        public Builder setItemClickListener(OnItemClickListener<User> itemClickListener) {
            this.itemClickListener = itemClickListener;
            return this;
        }

        public Builder setItemLongClickListener(OnItemLongClickListener<User> itemLongClickListener) {
            this.itemLongClickListener = itemLongClickListener;
            return this;
        }

        public Builder setActionItemClickListener(OnItemClickListener<User> actionItemClickListener) {
            this.actionItemClickListener = actionItemClickListener;
            return this;
        }

        public Builder setOnProfileClickListener(OnItemClickListener<User> profileClickListener) {
            this.profileClickListener = profileClickListener;
            return this;
        }

        public Builder setUseUserProfile(boolean useUserProfile) {
            this.bundle.putBoolean("KEY_USE_USER_PROFILE", useUserProfile);
            return this;
        }

        public OperatorListFragment build() {
            OperatorListFragment fragment = this.customFragment != null ? this.customFragment : new OperatorListFragment();
            fragment.setArguments(this.bundle);
            fragment.setUserListAdapter(this.adapter);
            fragment.setHeaderLeftButtonListener(this.headerLeftButtonListener);
            fragment.setHeaderRightButtonListener(this.headerRightButtonListener);
            fragment.setItemClickListener(this.itemClickListener);
            fragment.setItemLongClickListener(this.itemLongClickListener);
            fragment.setActionItemClickListener(this.actionItemClickListener);
            fragment.setOnProfileClickListener(this.profileClickListener);
            return fragment;
        }
    }

    private static class OperatorQueryHandler
    implements CustomMemberListQueryHandler<User> {
        private OperatorListQuery query;
        private final GroupChannel channel;

        OperatorQueryHandler(@NonNull GroupChannel channel) {
            this.channel = channel;
        }

        @Override
        public void loadInitial(OnListResultHandler<User> handler) {
            this.query = this.channel.createOperatorListQuery();
            this.query.setLimit(30);
            this.load(handler);
        }

        @Override
        public void load(OnListResultHandler<User> handler) {
            Logger.d(">> OperatorQueryHandler::load()");
            this.query.next(handler::onResult);
        }

        @Override
        public boolean hasMore() {
            return this.query.hasNext();
        }
    }
}

