/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.fragments;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.PopupWindow;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import androidx.databinding.DataBindingUtil;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import androidx.recyclerview.widget.RecyclerView;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.GroupChannelListQuery;
import com.sendbird.android.User;
import com.sendbird.uikit.R;
import com.sendbird.uikit.SendBirdUIKit;
import com.sendbird.uikit.activities.ChannelActivity;
import com.sendbird.uikit.activities.CreateChannelActivity;
import com.sendbird.uikit.activities.adapter.ChannelListAdapter;
import com.sendbird.uikit.consts.CreateableChannelType;
import com.sendbird.uikit.databinding.SbFragmentChannelListBinding;
import com.sendbird.uikit.dialogs.DialogHelper;
import com.sendbird.uikit.fragments.BaseFragment;
import com.sendbird.uikit.fragments.ItemAnimator;
import com.sendbird.uikit.interfaces.OnItemClickListener;
import com.sendbird.uikit.interfaces.OnItemLongClickListener;
import com.sendbird.uikit.log.Logger;
import com.sendbird.uikit.model.ReadyStatus;
import com.sendbird.uikit.utils.Available;
import com.sendbird.uikit.utils.ChannelUtils;
import com.sendbird.uikit.vm.ChannelListViewModel;
import com.sendbird.uikit.vm.ViewModelFactory;
import com.sendbird.uikit.widgets.SelectChannelTypeView;
import com.sendbird.uikit.widgets.StatusFrameView;
import java.util.List;

public class ChannelListFragment
extends BaseFragment {
    private SbFragmentChannelListBinding binding;
    private ChannelListViewModel viewModel;
    private View.OnClickListener headerLeftButtonListener;
    private View.OnClickListener headerRightButtonListener;
    private ChannelListAdapter adapter;
    private GroupChannelListQuery query;
    private OnItemClickListener<GroupChannel> itemClickListener;
    private OnItemLongClickListener<GroupChannel> itemLongClickListener;

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Logger.i(">> ChannelListFragment::onCreate()", new Object[0]);
        Bundle args = this.getArguments();
        int themeResId = SendBirdUIKit.getDefaultThemeMode().getResId();
        if (args != null) {
            themeResId = args.getInt("KEY_THEME_RES_ID", SendBirdUIKit.getDefaultThemeMode().getResId());
        }
        if (this.getActivity() != null) {
            this.getActivity().setTheme(themeResId);
        }
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.binding = (SbFragmentChannelListBinding)DataBindingUtil.inflate((LayoutInflater)inflater, (int)R.layout.sb_fragment_channel_list, (ViewGroup)container, (boolean)false);
        return this.binding.getRoot();
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.binding.statusFrame.setStatus(StatusFrameView.Status.LOADING);
        this.initHeaderOnCreated();
    }

    @Override
    public void onReady(User user, ReadyStatus status) {
        Logger.i(">> ChannelListFragment::onReady()", new Object[0]);
        if (status == ReadyStatus.ERROR) {
            this.setErrorFrame();
            return;
        }
        this.onConfigure();
        this.onDrawPage();
    }

    protected void onConfigure() {
    }

    protected void onDrawPage() {
        Logger.i(">> ChannelListFragment::onDrawPage()", new Object[0]);
        this.initHeaderOnReady();
        this.initChannelList();
    }

    protected void setErrorFrame() {
        this.binding.statusFrame.setStatus(StatusFrameView.Status.CONNECTION_ERROR);
        this.binding.statusFrame.setOnActionEventListener(v -> {
            this.binding.statusFrame.setStatus(StatusFrameView.Status.LOADING);
            this.connect();
        });
    }

    private void initHeaderOnCreated() {
        Bundle args = this.getArguments();
        String headerTitle = this.getString(R.string.sb_text_header_channel_list);
        boolean useHeader = false;
        boolean useHeaderLeftButton = true;
        boolean useHeaderRightButton = true;
        int headerLeftButtonIconResId = R.drawable.icon_arrow_left;
        int headerRightButtonIconResId = R.drawable.icon_create;
        if (args != null) {
            headerTitle = args.getString("KEY_HEADER_TITLE", this.getString(R.string.sb_text_header_channel_list));
            useHeader = args.getBoolean("KEY_USE_HEADER", false);
            useHeaderLeftButton = args.getBoolean("KEY_USE_HEADER_LEFT_BUTTON", true);
            useHeaderRightButton = args.getBoolean("KEY_USE_HEADER_RIGHT_BUTTON", true);
            headerLeftButtonIconResId = args.getInt("KEY_HEADER_LEFT_BUTTON_ICON_RES_ID", R.drawable.icon_arrow_left);
            headerRightButtonIconResId = args.getInt("KEY_HEADER_RIGHT_BUTTON_ICON_RES_ID", R.drawable.icon_create);
        }
        this.binding.abvChannelList.setVisibility(useHeader ? 0 : 8);
        this.binding.abvChannelList.getTitleTextView().setText((CharSequence)headerTitle);
        this.binding.abvChannelList.setUseLeftImageButton(useHeaderLeftButton);
        this.binding.abvChannelList.getRightImageButton().setVisibility(useHeaderRightButton ? 0 : 8);
        this.binding.abvChannelList.getLeftImageButton().setImageResource(headerLeftButtonIconResId);
        this.binding.abvChannelList.getRightImageButton().setImageResource(headerRightButtonIconResId);
        this.binding.abvChannelList.getLeftImageButton().setOnClickListener(v -> this.finish());
    }

    private void initHeaderOnReady() {
        if (this.headerLeftButtonListener != null) {
            this.binding.abvChannelList.getLeftImageButton().setOnClickListener(this.headerLeftButtonListener);
        }
        if (this.headerRightButtonListener != null) {
            this.binding.abvChannelList.getRightImageButton().setOnClickListener(this.headerRightButtonListener);
        } else {
            this.binding.abvChannelList.getRightImageButton().setOnClickListener(v -> {
                if (this.getContext() != null) {
                    if (Available.isSupportSuper() || Available.isSupportBroadcast()) {
                        SelectChannelTypeView layout2 = new SelectChannelTypeView(this.getContext());
                        layout2.canCreateSuperGroupChannel(Available.isSupportSuper());
                        layout2.canCreateBroadcastGroupChannel(Available.isSupportBroadcast());
                        PopupWindow popupWindow = DialogHelper.showPopupWindow((View)layout2);
                        layout2.setOnItemClickListener((view, position, channelType) -> {
                            Logger.dev("++ channelType : " + (Object)channelType);
                            if (popupWindow != null && popupWindow.isShowing()) {
                                popupWindow.dismiss();
                            }
                            if (this.isActive()) {
                                this.onSelectedChannelType((CreateableChannelType)((Object)((Object)channelType)));
                            }
                        });
                    } else if (this.isActive()) {
                        this.onSelectedChannelType(CreateableChannelType.Normal);
                    }
                }
            });
        }
    }

    protected void onSelectedChannelType(@NonNull CreateableChannelType channelType) {
        this.startActivity(CreateChannelActivity.newIntent(this.getContext(), channelType));
    }

    private void initChannelList() {
        Bundle args = this.getArguments();
        boolean includeEmpty = false;
        if (args != null) {
            includeEmpty = args.getBoolean("KEY_INCLUDE_EMPTY", false);
        }
        if (this.query == null) {
            this.query = GroupChannel.createMyGroupChannelListQuery();
            this.query.setIncludeEmpty(includeEmpty);
        }
        this.viewModel = (ChannelListViewModel)new ViewModelProvider((ViewModelStoreOwner)this, (ViewModelProvider.Factory)new ViewModelFactory(this, this.query)).get(ChannelListViewModel.class);
        this.getLifecycle().addObserver((LifecycleObserver)this.viewModel);
        this.initAdapter();
        this.binding.rvGroupChannelList.setAdapter(this.adapter);
        this.binding.rvGroupChannelList.setHasFixedSize(true);
        this.binding.rvGroupChannelList.setPager(this.viewModel);
        this.binding.rvGroupChannelList.setItemAnimator((RecyclerView.ItemAnimator)new ItemAnimator());
        this.binding.rvGroupChannelList.setThreshold(5);
        this.viewModel.getStatusFrame().observe((LifecycleOwner)this, this.binding.statusFrame::setStatus);
        this.viewModel.getChannelList().observe((LifecycleOwner)this, groupChannels -> {
            this.binding.rvGroupChannelList.setRefreshing(false);
            this.adapter.setItems((List<GroupChannel>)groupChannels);
        });
        this.adapter.registerAdapterDataObserver(new RecyclerView.AdapterDataObserver(){

            public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
                super.onItemRangeMoved(fromPosition, toPosition, itemCount);
                if (toPosition == 0 && ChannelListFragment.this.adapter != null && ((ChannelListFragment)ChannelListFragment.this).binding.rvGroupChannelList.findFirstVisibleItemPosition() == 0) {
                    ((ChannelListFragment)ChannelListFragment.this).binding.rvGroupChannelList.scrollToPosition(0);
                }
            }

            public void onItemRangeInserted(int positionStart, int itemCount) {
                if (positionStart == 0 && ChannelListFragment.this.adapter != null && ((ChannelListFragment)ChannelListFragment.this).binding.rvGroupChannelList.findFirstVisibleItemPosition() == 0) {
                    ((ChannelListFragment)ChannelListFragment.this).binding.rvGroupChannelList.scrollToPosition(0);
                }
            }
        });
    }

    protected void leaveChannel(@NonNull GroupChannel channel) {
        if (this.viewModel != null) {
            this.viewModel.leaveChannel(channel);
        }
    }

    private void initAdapter() {
        if (this.adapter == null) {
            this.adapter = new ChannelListAdapter();
        }
        if (this.itemClickListener == null) {
            this.itemClickListener = (view, position, channel) -> {
                Logger.d("++ ChannelListFragment::onItemClicked()");
                if (this.isActive()) {
                    this.startActivity(ChannelActivity.newIntent(this.getContext(), channel.getUrl()));
                }
            };
        }
        if (this.itemLongClickListener == null) {
            this.itemLongClickListener = (view1, position, channel) -> {
                Logger.d("++ ChannelListFragment::onItemLongClicked()");
                DialogHelper.DialogListItem pushOnOff = new DialogHelper.DialogListItem(ChannelUtils.isChannelPushOff(channel) ? R.string.sb_text_channel_list_push_on : R.string.sb_text_channel_list_push_off);
                DialogHelper.DialogListItem leaveChannel = new DialogHelper.DialogListItem(R.string.sb_text_channel_list_leave);
                DialogHelper.DialogListItem[] items = new DialogHelper.DialogListItem[]{pushOnOff, leaveChannel};
                if (this.isActive()) {
                    DialogHelper.showList(this.getContext(), ChannelUtils.makeTitleText(this.getContext(), channel), items, key -> {
                        if (key == R.string.sb_text_channel_list_leave) {
                            Logger.dev("leave channel");
                            this.leaveChannel((GroupChannel)channel);
                        } else {
                            Logger.dev("change push notifications");
                            this.viewModel.setPushNotification((GroupChannel)channel, ChannelUtils.isChannelPushOff(channel));
                        }
                    });
                }
            };
        }
        this.adapter.setOnItemClickListener(this.itemClickListener);
        this.adapter.setOnItemLongClickListener(this.itemLongClickListener);
    }

    private void setHeaderLeftButtonListener(View.OnClickListener listener) {
        this.headerLeftButtonListener = listener;
    }

    private void setHeaderRightButtonListener(View.OnClickListener listener) {
        this.headerRightButtonListener = listener;
    }

    private void setChannelListAdapter(ChannelListAdapter adapter) {
        this.adapter = adapter;
    }

    private void setItemClickListener(OnItemClickListener<GroupChannel> itemClickListener) {
        this.itemClickListener = itemClickListener;
    }

    private void setItemLongClickListener(OnItemLongClickListener<GroupChannel> itemLongClickListener) {
        this.itemLongClickListener = itemLongClickListener;
    }

    private void setGroupChannelListQuery(GroupChannelListQuery query) {
        this.query = query;
    }

    public static class Builder {
        private Bundle bundle = new Bundle();
        private ChannelListFragment customFragment;
        private View.OnClickListener headerLeftButtonListener;
        private View.OnClickListener headerRightButtonListener;
        private ChannelListAdapter adapter;
        private OnItemClickListener<GroupChannel> itemClickListener;
        private OnItemLongClickListener<GroupChannel> itemLongClickListener;
        private GroupChannelListQuery query;

        public Builder() {
            this(SendBirdUIKit.getDefaultThemeMode());
        }

        public Builder(SendBirdUIKit.ThemeMode themeMode) {
            this.bundle.putInt("KEY_THEME_RES_ID", themeMode.getResId());
        }

        public Builder(@StyleRes int customThemeResId) {
            this.bundle.putInt("KEY_THEME_RES_ID", customThemeResId);
        }

        public <T extends ChannelListFragment> Builder setCustomChannelListFragment(T fragment) {
            this.customFragment = fragment;
            return this;
        }

        public Builder setHeaderTitle(String title) {
            this.bundle.putString("KEY_HEADER_TITLE", title);
            return this;
        }

        public Builder setUseHeader(boolean useHeader) {
            this.bundle.putBoolean("KEY_USE_HEADER", useHeader);
            return this;
        }

        public Builder setUseHeaderRightButton(boolean useHeaderRightButton) {
            this.bundle.putBoolean("KEY_USE_HEADER_RIGHT_BUTTON", useHeaderRightButton);
            return this;
        }

        public Builder setUseHeaderLeftButton(boolean useHeaderLeftButton) {
            this.bundle.putBoolean("KEY_USE_HEADER_LEFT_BUTTON", useHeaderLeftButton);
            return this;
        }

        public Builder setHeaderLeftButtonIconResId(@DrawableRes int resId) {
            this.bundle.putInt("KEY_HEADER_LEFT_BUTTON_ICON_RES_ID", resId);
            return this;
        }

        public Builder setHeaderRightButtonIconResId(@DrawableRes int resId) {
            this.bundle.putInt("KEY_HEADER_RIGHT_BUTTON_ICON_RES_ID", resId);
            return this;
        }

        @Deprecated
        public Builder setIsIncludeEmpty(boolean isIncludeEmpty) {
            this.bundle.putBoolean("KEY_INCLUDE_EMPTY", isIncludeEmpty);
            return this;
        }

        public Builder setHeaderLeftButtonListener(View.OnClickListener listener) {
            this.headerLeftButtonListener = listener;
            return this;
        }

        public Builder setHeaderRightButtonListener(View.OnClickListener listener) {
            this.headerRightButtonListener = listener;
            return this;
        }

        public Builder setChannelListAdapter(ChannelListAdapter adapter) {
            this.adapter = adapter;
            return this;
        }

        public Builder setItemClickListener(OnItemClickListener<GroupChannel> itemClickListener) {
            this.itemClickListener = itemClickListener;
            return this;
        }

        public Builder setItemLongClickListener(OnItemLongClickListener<GroupChannel> itemLongClickListener) {
            this.itemLongClickListener = itemLongClickListener;
            return this;
        }

        public Builder setGroupChannelListQuery(GroupChannelListQuery query) {
            this.query = query;
            return this;
        }

        public ChannelListFragment build() {
            ChannelListFragment fragment = this.customFragment != null ? this.customFragment : new ChannelListFragment();
            fragment.setArguments(this.bundle);
            fragment.setChannelListAdapter(this.adapter);
            fragment.setHeaderLeftButtonListener(this.headerLeftButtonListener);
            fragment.setHeaderRightButtonListener(this.headerRightButtonListener);
            fragment.setItemClickListener(this.itemClickListener);
            fragment.setItemLongClickListener(this.itemLongClickListener);
            fragment.setGroupChannelListQuery(this.query);
            return fragment;
        }
    }
}

