/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.widgets;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.TextAppearanceSpan;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.CompoundButton;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.widget.CompoundButtonCompat;
import com.sendbird.android.SendBird;
import com.sendbird.uikit.R;
import com.sendbird.uikit.SendBirdUIKit;
import com.sendbird.uikit.databinding.SbViewUserListItemBinding;
import com.sendbird.uikit.interfaces.UserInfo;
import com.sendbird.uikit.utils.ChannelUtils;

public class UserPreview
extends FrameLayout {
    private SbViewUserListItemBinding binding;
    private CompoundButton.OnCheckedChangeListener onCheckedChangeListener;
    private View.OnClickListener clickListener;
    private View.OnLongClickListener longClickListener;

    public UserPreview(Context context) {
        this(context, null);
    }

    public UserPreview(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.sb_user_preview_style);
    }

    public UserPreview(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs, defStyle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs, int defStyle) {
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.UserPreview, defStyle, 0);
        try {
            this.binding = SbViewUserListItemBinding.inflate(LayoutInflater.from((Context)this.getContext()));
            this.addView(this.binding.getRoot(), -1, -2);
            int nicknameAppearance = a.getResourceId(R.styleable.UserPreview_sb_user_preview_nickname_appearance, R.style.SendbirdSubtitle2OnLight01);
            boolean useSelection = a.getBoolean(R.styleable.UserPreview_sb_user_preview_use_selection, false);
            this.binding.cbUserPreview.setVisibility(useSelection ? 0 : 8);
            this.binding.tvNickname.setTextAppearance(context, nicknameAppearance);
            this.binding.tvNickname.setEllipsize(TextUtils.TruncateAt.END);
            this.binding.tvNickname.setMaxLines(1);
            int checkBoxTint = SendBirdUIKit.isDarkMode() ? R.color.sb_checkbox_tint_dark : R.color.sb_checkbox_tint_light;
            CompoundButtonCompat.setButtonTintList((CompoundButton)this.binding.cbUserPreview, (ColorStateList)context.getResources().getColorStateList(checkBoxTint));
            this.binding.vgUserItem.setOnClickListener(v -> {
                this.binding.cbUserPreview.toggle();
                if (this.clickListener != null) {
                    this.clickListener.onClick(v);
                }
                if (this.onCheckedChangeListener != null) {
                    this.onCheckedChangeListener.onCheckedChanged((CompoundButton)this.binding.cbUserPreview, !this.isSelected());
                }
            });
            this.binding.cbUserPreview.setOnClickListener(v -> {
                if (this.clickListener != null) {
                    this.clickListener.onClick(v);
                }
                if (this.onCheckedChangeListener != null) {
                    this.onCheckedChangeListener.onCheckedChanged((CompoundButton)this.binding.cbUserPreview, !this.isSelected());
                }
            });
            this.binding.vgUserItem.setOnLongClickListener(v -> {
                if (this.longClickListener != null) {
                    this.longClickListener.onLongClick(v);
                }
                return false;
            });
        }
        finally {
            a.recycle();
        }
    }

    public View getLayout() {
        return this;
    }

    public SbViewUserListItemBinding getBinding() {
        return this.binding;
    }

    public void setOnClickListener(@Nullable View.OnClickListener listener) {
        this.clickListener = listener;
    }

    public void setOnLongClickListener(View.OnLongClickListener listener) {
        this.longClickListener = listener;
    }

    public void setOnSelectedStateChangedListener(CompoundButton.OnCheckedChangeListener listener) {
        this.onCheckedChangeListener = listener;
    }

    public boolean isSelected() {
        return this.binding.cbUserPreview.isChecked();
    }

    public void setUserSelected(boolean isSelected) {
        this.binding.cbUserPreview.setChecked(isSelected);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.binding.vgUserItem.setEnabled(enabled);
        this.binding.cbUserPreview.setEnabled(enabled);
        this.binding.tvNickname.setEnabled(enabled);
    }

    public void drawUser(@NonNull UserInfo userInfo, boolean isSelected, boolean isEnabled) {
        String nickname = TextUtils.isEmpty((CharSequence)userInfo.getNickname()) ? this.getContext().getString(R.string.sb_text_channel_list_title_unknown) : userInfo.getNickname();
        this.binding.tvNickname.setText((CharSequence)nickname);
        ChannelUtils.loadImage(this.binding.ivUserCover, userInfo.getProfileUrl());
        if (userInfo.getUserId().equals(SendBird.getCurrentUser().getUserId())) {
            String meBadge = this.getResources().getString(R.string.sb_text_user_list_badge_me);
            SpannableString spannable = new SpannableString((CharSequence)meBadge);
            int badgeAppearance = SendBirdUIKit.isDarkMode() ? R.style.SendbirdSubtitle2OnDark02 : R.style.SendbirdSubtitle2OnLight02;
            spannable.setSpan((Object)new TextAppearanceSpan(this.getContext(), badgeAppearance), 0, meBadge.length(), 33);
            this.binding.tvNickname.append((CharSequence)spannable);
        }
        this.setUserSelected(isSelected);
        this.setEnabled(isEnabled);
    }
}

