/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.fragments;

import android.os.Bundle;
import android.view.View;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.StyleRes;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.GroupChannelParams;
import com.sendbird.android.SendBird;
import com.sendbird.uikit.R;
import com.sendbird.uikit.SendBirdUIKit;
import com.sendbird.uikit.activities.ChannelActivity;
import com.sendbird.uikit.activities.adapter.UserListAdapter;
import com.sendbird.uikit.consts.CreateableChannelType;
import com.sendbird.uikit.fragments.SelectUserFragment;
import com.sendbird.uikit.interfaces.CustomUserListQueryHandler;
import com.sendbird.uikit.log.Logger;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;

public class CreateChannelFragment
extends SelectUserFragment {
    private boolean isDistinct;
    private CreateableChannelType selectedChannelType;

    @Override
    protected void onConfigure() {
        Bundle args = this.getArguments();
        this.selectedChannelType = args != null && args.containsKey("KEY_SELECTED_CHANNEL_TYPE") ? (CreateableChannelType)((Object)args.getSerializable("KEY_SELECTED_CHANNEL_TYPE")) : CreateableChannelType.Normal;
        this.isDistinct = args != null && args.getBoolean("KEY_DISTINCT", false);
    }

    @Override
    protected void onUserSelectComplete(List<String> selectedUsers) {
        GroupChannelParams params = new GroupChannelParams();
        params.addUserIds(selectedUsers);
        params.setDistinct(this.isDistinct);
        params.setName("");
        params.setCoverUrl("");
        params.setOperators(Collections.singletonList(SendBird.getCurrentUser()));
        Logger.d("=++ selected channel type : " + (Object)((Object)this.selectedChannelType));
        switch (this.selectedChannelType) {
            case Super: {
                params.setSuper(true);
                break;
            }
            case Broadcast: {
                params.setBroadcast(true);
                break;
            }
        }
        this.createGroupChannel(params);
    }

    protected void onBeforeCreateGroupChannel(@NonNull GroupChannelParams params) {
    }

    protected void createGroupChannel(@NonNull GroupChannelParams params) {
        Logger.dev(">> CreateChannelFragment::createGroupChannel()");
        this.onBeforeCreateGroupChannel(params);
        Logger.dev("++ createGroupChannel params : " + params);
        GroupChannel.createChannel((GroupChannelParams)params, (channel, e) -> {
            if (e != null) {
                this.toastError(R.string.sb_text_error_create_channel);
                Logger.e((Throwable)e);
                return;
            }
            this.onNewChannelCreated(channel);
        });
    }

    protected void onNewChannelCreated(@NonNull GroupChannel channel) {
        if (this.isActive()) {
            this.startActivity(ChannelActivity.newIntent(this.getContext(), channel.getUrl()));
            this.finish();
        }
    }

    protected void setCreateButtonText(CharSequence text) {
        this.setRightButtonText(text);
    }

    protected void setCreateButtonEnabled(boolean enabled) {
        this.setRightButtonEnabed(enabled);
    }

    public static class Builder {
        private Bundle bundle = new Bundle();
        private CreateChannelFragment customFragment;
        private CustomUserListQueryHandler customUserListQueryHandler = null;
        private UserListAdapter adapter;
        private View.OnClickListener headerLeftButtonListener;

        public Builder() {
            this(SendBirdUIKit.getDefaultThemeMode());
        }

        public Builder(SendBirdUIKit.ThemeMode themeMode) {
            this(themeMode.getResId());
        }

        public Builder(@NonNull CreateableChannelType type) {
            this(SendBirdUIKit.getDefaultThemeMode().getResId(), type);
        }

        public Builder(@StyleRes int customThemeResId) {
            this(customThemeResId, CreateableChannelType.Normal);
        }

        public Builder(@StyleRes int customThemeResId, @NonNull CreateableChannelType type) {
            this.bundle.putInt("KEY_THEME_RES_ID", customThemeResId);
            this.bundle.putSerializable("KEY_SELECTED_CHANNEL_TYPE", (Serializable)((Object)type));
        }

        public <T extends CreateChannelFragment> Builder setCustomCreateChannelFragment(T fragment) {
            this.customFragment = fragment;
            return this;
        }

        public Builder setCreateButtonText(String createButtonText) {
            this.bundle.putString("KEY_HEADER_LEFT_BUTTON_TEXT", createButtonText);
            return this;
        }

        public Builder setCustomUserListQueryHandler(CustomUserListQueryHandler handler) {
            this.customUserListQueryHandler = handler;
            return this;
        }

        public Builder setHeaderTitle(String title) {
            this.bundle.putString("KEY_HEADER_TITLE", title);
            return this;
        }

        public Builder setUseHeader(boolean useHeader) {
            this.bundle.putBoolean("KEY_USE_HEADER", useHeader);
            return this;
        }

        public Builder setUseHeaderLeftButton(boolean useHeaderLeftButton) {
            this.bundle.putBoolean("KEY_USE_HEADER_LEFT_BUTTON", useHeaderLeftButton);
            return this;
        }

        public Builder setHeaderLeftButtonIconResId(@DrawableRes int resId) {
            this.bundle.putInt("KEY_HEADER_LEFT_BUTTON_ICON_RES_ID", resId);
            return this;
        }

        public Builder setIsDistinct(boolean isDistinct) {
            this.bundle.putBoolean("KEY_DISTINCT", isDistinct);
            return this;
        }

        public Builder setUserListAdapter(UserListAdapter adapter) {
            this.adapter = adapter;
            return this;
        }

        public Builder setHeaderLeftButtonListener(View.OnClickListener listener) {
            this.headerLeftButtonListener = listener;
            return this;
        }

        public CreateChannelFragment build() {
            CreateChannelFragment fragment = this.customFragment != null ? this.customFragment : new CreateChannelFragment();
            fragment.setArguments(this.bundle);
            fragment.setCustomUserListQueryHandler(this.customUserListQueryHandler);
            fragment.setUserListAdapter(this.adapter);
            fragment.setHeaderLeftButtonListener(this.headerLeftButtonListener);
            return fragment;
        }
    }
}

