/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.widgets;

import android.content.Context;
import android.content.res.TypedArray;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.TextAppearanceSpan;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.sendbird.android.Member;
import com.sendbird.android.SendBird;
import com.sendbird.android.User;
import com.sendbird.uikit.R;
import com.sendbird.uikit.SendBirdUIKit;
import com.sendbird.uikit.databinding.SbViewMemberListItemBinding;
import com.sendbird.uikit.utils.DrawableUtils;
import java.util.Collections;

public class MemberPreview
extends FrameLayout {
    private SbViewMemberListItemBinding binding;

    public MemberPreview(Context context) {
        this(context, null);
    }

    public MemberPreview(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.sb_member_preview_style);
    }

    public MemberPreview(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs, defStyle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs, int defStyle) {
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.MemberPreview, defStyle, 0);
        try {
            this.binding = SbViewMemberListItemBinding.inflate(LayoutInflater.from((Context)this.getContext()));
            this.addView(this.binding.getRoot(), -1, -2);
            int nicknameAppearance = a.getResourceId(R.styleable.MemberPreview_sb_member_preview_nickname_appearance, R.style.SendbirdSubtitle2OnLight01);
            int descAppearance = a.getResourceId(R.styleable.MemberPreview_sb_member_preview_description_appearance, R.style.SendbirdBody3OnLight02);
            int actionMenuBgResId = a.getResourceId(R.styleable.MemberPreview_sb_member_preview_action_menu_background, R.drawable.sb_button_uncontained_background_light);
            this.binding.tvNickname.setTextAppearance(context, nicknameAppearance);
            this.binding.tvNickname.setEllipsize(TextUtils.TruncateAt.END);
            this.binding.tvNickname.setMaxLines(1);
            this.binding.tvDescription.setTextAppearance(context, descAppearance);
            this.binding.ivAction.setBackgroundResource(actionMenuBgResId);
            int moreTint = SendBirdUIKit.isDarkMode() ? R.color.ondark_01 : R.color.onlight_01;
            this.binding.ivAction.setImageDrawable(DrawableUtils.setTintList(this.binding.ivAction.getDrawable(), context.getResources().getColorStateList(moreTint)));
        }
        finally {
            a.recycle();
        }
    }

    public View getLayout() {
        return this;
    }

    public SbViewMemberListItemBinding getBinding() {
        return this.binding;
    }

    public void setOnClickListener(@Nullable View.OnClickListener listener) {
        this.binding.vgMemberItem.setOnClickListener(listener);
    }

    public void setOnLongClickListener(View.OnLongClickListener listener) {
        this.binding.vgMemberItem.setOnLongClickListener(listener);
    }

    public void useActionMenu(boolean use) {
        this.binding.ivAction.setVisibility(use ? 0 : 8);
    }

    public void setOnActionMenuClickListener(View.OnClickListener listener) {
        this.binding.ivAction.setOnClickListener(listener);
    }

    public void setDescription(CharSequence text) {
        this.binding.tvDescription.setText(text);
    }

    public void setName(CharSequence name) {
        this.binding.tvNickname.setText(name);
    }

    public void setImageFromUrl(String url) {
        this.binding.ivMemberCover.loadImages(Collections.singletonList(url));
    }

    public void setVisibleOverlay(int visiblility) {
        this.binding.vgMemberCoverOveray.setVisibility(visiblility);
    }

    public void enableActionMenu(boolean enabled) {
        this.binding.ivAction.setEnabled(enabled);
    }

    public static void drawMember(@NonNull MemberPreview preview, @NonNull Member member) {
        Context context = preview.getContext();
        boolean isOperatorMember = member.getRole() == Member.Role.OPERATOR;
        boolean isMe = member.getUserId().equals(SendBird.getCurrentUser().getUserId());
        String nickname = TextUtils.isEmpty((CharSequence)member.getNickname()) ? context.getString(R.string.sb_text_channel_list_title_unknown) : member.getNickname();
        preview.setName(nickname);
        String description = isOperatorMember ? context.getString(R.string.sb_text_operator) : "";
        preview.setDescription(description);
        preview.setImageFromUrl(member.getProfileUrl());
        preview.enableActionMenu(!isMe);
        preview.setVisibleOverlay(member.isMuted() ? 0 : 8);
        if (isMe) {
            String meBadge = nickname + context.getResources().getString(R.string.sb_text_user_list_badge_me);
            SpannableString spannable = new SpannableString((CharSequence)meBadge);
            int badgeAppearance = SendBirdUIKit.isDarkMode() ? R.style.SendbirdSubtitle2OnDark02 : R.style.SendbirdSubtitle2OnLight02;
            int originLen = nickname.length();
            spannable.setSpan((Object)new TextAppearanceSpan(context, badgeAppearance), originLen, meBadge.length(), 33);
            preview.setName((CharSequence)spannable);
        }
    }

    public static void drawMemberFromUser(@NonNull MemberPreview preview, @NonNull User user) {
        Context context = preview.getContext();
        boolean isMe = user.getUserId().equals(SendBird.getCurrentUser().getUserId());
        String nickname = TextUtils.isEmpty((CharSequence)user.getNickname()) ? context.getString(R.string.sb_text_channel_list_title_unknown) : user.getNickname();
        preview.setName(nickname);
        preview.setDescription("");
        preview.setImageFromUrl(user.getProfileUrl());
        preview.enableActionMenu(!isMe);
        if (isMe) {
            String meBadge = nickname + context.getResources().getString(R.string.sb_text_user_list_badge_me);
            SpannableString spannable = new SpannableString((CharSequence)meBadge);
            int badgeAppearance = SendBirdUIKit.isDarkMode() ? R.style.SendbirdSubtitle2OnDark02 : R.style.SendbirdSubtitle2OnLight02;
            int originLen = nickname.length();
            spannable.setSpan((Object)new TextAppearanceSpan(context, badgeAppearance), originLen, meBadge.length(), 33);
            preview.setName((CharSequence)spannable);
        }
    }
}

