/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.fragments;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.databinding.DataBindingUtil;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import com.sendbird.android.User;
import com.sendbird.uikit.R;
import com.sendbird.uikit.SendBirdUIKit;
import com.sendbird.uikit.activities.adapter.UserListAdapter;
import com.sendbird.uikit.databinding.SbFragmentSelectUsersBinding;
import com.sendbird.uikit.fragments.BaseFragment;
import com.sendbird.uikit.interfaces.CustomUserListQueryHandler;
import com.sendbird.uikit.interfaces.UserInfo;
import com.sendbird.uikit.log.Logger;
import com.sendbird.uikit.model.ReadyStatus;
import com.sendbird.uikit.vm.SelectableUserInfoListViewModel;
import com.sendbird.uikit.vm.ViewModelFactory;
import com.sendbird.uikit.widgets.StatusFrameView;
import java.util.Collections;
import java.util.List;

public abstract class SelectUserFragment
extends BaseFragment {
    private SbFragmentSelectUsersBinding binding;
    private SelectableUserInfoListViewModel viewModel;
    protected UserListAdapter adapter;
    protected View.OnClickListener headerLeftButtonListener;
    protected CustomUserListQueryHandler customUserListQueryHandler;
    protected String headerRightButtonText = "";

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Logger.i(">> SelectUserFragment::onCreate()", new Object[0]);
        Bundle args = this.getArguments();
        int themeResId = SendBirdUIKit.getDefaultThemeMode().getResId();
        if (args != null) {
            themeResId = args.getInt("KEY_THEME_RES_ID");
        }
        if (this.getActivity() != null) {
            this.getActivity().setTheme(themeResId);
        }
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.binding = (SbFragmentSelectUsersBinding)DataBindingUtil.inflate((LayoutInflater)inflater, (int)R.layout.sb_fragment_select_users, (ViewGroup)container, (boolean)false);
        return this.binding.getRoot();
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.binding.statusFrame.setStatus(StatusFrameView.Status.LOADING);
        this.initHeaderOnCreated();
    }

    @Override
    public void onReady(User user, ReadyStatus status) {
        Logger.i(">> SelectUserFragment::onReady()", new Object[0]);
        if (status == ReadyStatus.ERROR) {
            this.setErrorFrame();
            return;
        }
        this.onConfigure();
        this.onDrawPage();
    }

    protected void onConfigure() {
    }

    protected void onDrawPage() {
        this.viewModel = (SelectableUserInfoListViewModel)new ViewModelProvider((ViewModelStoreOwner)this, (ViewModelProvider.Factory)new ViewModelFactory(this, this.customUserListQueryHandler)).get(SelectableUserInfoListViewModel.class);
        this.initHeaderOnReady();
        this.initUserList();
    }

    protected void setErrorFrame() {
        this.binding.statusFrame.setStatus(StatusFrameView.Status.CONNECTION_ERROR);
        this.binding.statusFrame.setOnActionEventListener(v -> {
            this.binding.statusFrame.setStatus(StatusFrameView.Status.LOADING);
            this.connect();
        });
    }

    private void initHeaderOnCreated() {
        Bundle args = this.getArguments();
        String headerTitle = this.getString(R.string.sb_text_header_select_members);
        this.headerRightButtonText = this.getString(R.string.sb_text_button_selected);
        boolean useHeader = false;
        boolean useHeaderLeftButton = true;
        int headerLeftButtonIconResId = R.drawable.icon_arrow_left;
        if (args != null) {
            headerTitle = args.getString("KEY_HEADER_TITLE", headerTitle);
            this.headerRightButtonText = args.getString("KEY_HEADER_LEFT_BUTTON_TEXT", this.headerRightButtonText);
            useHeader = args.getBoolean("KEY_USE_HEADER", false);
            useHeaderLeftButton = args.getBoolean("KEY_USE_HEADER_LEFT_BUTTON", true);
            headerLeftButtonIconResId = args.getInt("KEY_HEADER_LEFT_BUTTON_ICON_RES_ID", R.drawable.icon_arrow_left);
        }
        this.setRightButtonText(this.headerRightButtonText);
        this.binding.abvSelectUsers.setVisibility(useHeader ? 0 : 8);
        this.binding.abvSelectUsers.getTitleTextView().setText((CharSequence)headerTitle);
        this.binding.abvSelectUsers.getLeftImageButton().setVisibility(useHeaderLeftButton ? 0 : 8);
        this.binding.abvSelectUsers.getLeftImageButton().setImageResource(headerLeftButtonIconResId);
        this.binding.abvSelectUsers.getLeftImageButton().setOnClickListener(v -> this.finish());
    }

    private void initHeaderOnReady() {
        if (this.headerLeftButtonListener != null) {
            this.binding.abvSelectUsers.getLeftImageButton().setOnClickListener(this.headerLeftButtonListener);
        }
        this.setRightButtonEnabed(false);
        this.binding.abvSelectUsers.getRightTextButton().setOnClickListener(v -> {
            if (this.adapter != null) {
                this.onUserSelectComplete(this.adapter.getSelectedUserList());
            }
        });
    }

    protected void onUserSelectComplete(List<String> selectedUsers) {
    }

    protected void setRightButtonText(CharSequence text) {
        if (this.binding != null) {
            this.binding.abvSelectUsers.getRightTextButton().setText(text);
        }
    }

    protected void setRightButtonEnabed(boolean enabled) {
        if (this.binding != null) {
            this.binding.abvSelectUsers.getRightTextButton().setEnabled(enabled);
        }
    }

    protected List<String> getDisabledUserIds() {
        return Collections.emptyList();
    }

    private void initUserList() {
        if (this.adapter == null) {
            this.adapter = new UserListAdapter();
        }
        this.adapter.setDisabledUserList(this.getDisabledUserIds());
        this.adapter.setOnUserSelectChangedListener((selectedUsers, isChecked) -> {
            int count = selectedUsers == null ? 0 : selectedUsers.size();
            this.setRightButtonEnabed(selectedUsers != null && count > 0);
            this.setRightButtonText(count > 0 ? count + " " + this.headerRightButtonText : this.headerRightButtonText);
        });
        this.binding.rvSelectableUserList.setAdapter(this.adapter);
        this.binding.rvSelectableUserList.setHasFixedSize(true);
        this.binding.rvSelectableUserList.setPager(this.viewModel);
        this.binding.rvSelectableUserList.setThreshold(5);
        this.viewModel.getStatusFrame().observe((LifecycleOwner)this, this.binding.statusFrame::setStatus);
        this.viewModel.getUserList().observe((LifecycleOwner)this, users -> {
            Logger.dev("++ users size : %s", users.size());
            this.binding.rvSelectableUserList.setRefreshing(false);
            this.adapter.setItems((List<UserInfo>)users);
        });
    }

    protected <T extends UserListAdapter> void setUserListAdapter(T adapter) {
        this.adapter = adapter;
    }

    protected void setHeaderLeftButtonListener(View.OnClickListener listener) {
        this.headerLeftButtonListener = listener;
    }

    protected void setCustomUserListQueryHandler(CustomUserListQueryHandler handler) {
        this.customUserListQueryHandler = handler;
    }
}

