/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.fragments;

import android.os.Bundle;
import android.view.View;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.StringRes;
import androidx.annotation.StyleRes;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.GroupChannelMemberListQuery;
import com.sendbird.android.Member;
import com.sendbird.uikit.R;
import com.sendbird.uikit.SendBirdUIKit;
import com.sendbird.uikit.activities.InviteChannelActivity;
import com.sendbird.uikit.activities.adapter.MemberListAdapter;
import com.sendbird.uikit.dialogs.DialogHelper;
import com.sendbird.uikit.fragments.MemberTypeListFragment;
import com.sendbird.uikit.interfaces.CustomMemberListQueryHandler;
import com.sendbird.uikit.interfaces.OnItemClickListener;
import com.sendbird.uikit.interfaces.OnItemLongClickListener;
import com.sendbird.uikit.interfaces.OnListResultHandler;
import java.util.Collections;

public class MemberListFragment
extends MemberTypeListFragment {
    @Override
    protected void onConfigure() {
        if (this.customQueryHandler == null) {
            MemberListQuery query = new MemberListQuery(this.channel);
            this.setCustomQueryHandler(query);
        }
        if (this.headerRightButtonListener == null) {
            this.setHeaderRightButtonListener(v -> {
                if (this.isActive() && this.getContext() != null) {
                    this.startActivity(InviteChannelActivity.newIntent(this.getContext(), this.channel.getUrl()));
                }
            });
        }
    }

    @Override
    protected void onActionItemClicked(View view, int position, Member member) {
        DialogHelper.DialogListItem[] dialogListItemArray;
        if (member == null) {
            return;
        }
        boolean isMuted = member.isMuted();
        boolean isOperator = member.getRole() == Member.Role.OPERATOR;
        DialogHelper.DialogListItem promoteOperator = new DialogHelper.DialogListItem(isOperator ? R.string.sb_text_dismiss_operator : R.string.sb_text_promote_operator);
        DialogHelper.DialogListItem muteMember = new DialogHelper.DialogListItem(isMuted ? R.string.sb_text_unmute_member : R.string.sb_text_mute_member);
        DialogHelper.DialogListItem banMember = new DialogHelper.DialogListItem(R.string.sb_text_ban_member, 0, true);
        if (!this.channel.isBroadcast()) {
            DialogHelper.DialogListItem[] dialogListItemArray2 = new DialogHelper.DialogListItem[3];
            dialogListItemArray2[0] = promoteOperator;
            dialogListItemArray2[1] = muteMember;
            dialogListItemArray = dialogListItemArray2;
            dialogListItemArray2[2] = banMember;
        } else {
            DialogHelper.DialogListItem[] dialogListItemArray3 = new DialogHelper.DialogListItem[2];
            dialogListItemArray3[0] = promoteOperator;
            dialogListItemArray = dialogListItemArray3;
            dialogListItemArray3[1] = banMember;
        }
        DialogHelper.DialogListItem[] items = dialogListItemArray;
        DialogHelper.showList(this.getContext(), member.getNickname(), items, key -> {
            if (key == R.string.sb_text_promote_operator) {
                this.addOperator(member.getUserId());
            } else if (key == R.string.sb_text_dismiss_operator) {
                this.removeOperator(member.getUserId());
            } else if (key == R.string.sb_text_mute_member) {
                this.muteUser(member.getUserId());
            } else if (key == R.string.sb_text_unmute_member) {
                this.unmuteUser(member.getUserId());
            } else if (key == R.string.sb_text_ban_member) {
                this.banUser(member.getUserId());
            }
        });
    }

    private void addOperator(@NonNull String userId) {
        this.showWaitingDialog();
        this.channel.addOperators(Collections.singletonList(userId), e -> {
            this.dismissWaitingDialog();
            if (e != null) {
                this.toastError(R.string.sb_text_error_promote_operator);
            }
        });
    }

    private void removeOperator(@NonNull String userId) {
        this.showWaitingDialog();
        this.channel.removeOperators(Collections.singletonList(userId), e -> {
            this.dismissWaitingDialog();
            if (e != null) {
                this.toastError(R.string.sb_text_error_dismiss_operator);
            }
        });
    }

    private void muteUser(@NonNull String userId) {
        this.showWaitingDialog();
        this.channel.muteUserWithUserId(userId, e -> {
            this.dismissWaitingDialog();
            if (e != null) {
                this.toastError(R.string.sb_text_error_mute_member);
            }
        });
    }

    private void unmuteUser(@NonNull String userId) {
        this.showWaitingDialog();
        this.channel.unmuteUserWithUserId(userId, e -> {
            this.dismissWaitingDialog();
            if (e != null) {
                this.toastError(R.string.sb_text_error_unmute_member);
            }
        });
    }

    private void banUser(@NonNull String userId) {
        this.showWaitingDialog();
        this.channel.banUserWithUserId(userId, null, -1, e -> {
            this.dismissWaitingDialog();
            if (e != null) {
                this.toastError(R.string.sb_text_error_ban_member);
            }
        });
    }

    public static class Builder {
        private Bundle bundle = new Bundle();
        private MemberListFragment customFragment;
        private View.OnClickListener headerLeftButtonListener;
        private View.OnClickListener headerRightButtonListener;
        private MemberListAdapter adapter;
        private OnItemClickListener<Member> itemClickListener;
        private OnItemLongClickListener<Member> itemLongClickListener;
        private OnItemClickListener<Member> actionItemClickListener;

        public Builder(@NonNull String channelUrl) {
            this(channelUrl, SendBirdUIKit.getDefaultThemeMode());
        }

        public Builder(@NonNull String channelUrl, SendBirdUIKit.ThemeMode themeMode) {
            this(channelUrl, themeMode.getResId());
        }

        public Builder(@NonNull String channelUrl, @StyleRes int customThemeResId) {
            this.bundle.putInt("KEY_THEME_RES_ID", customThemeResId);
            this.bundle.putString("KEY_CHANNEL_URL", channelUrl);
        }

        public <T extends MemberListFragment> Builder setCustomMemberListFragment(T fragment) {
            this.customFragment = fragment;
            return this;
        }

        public Builder setHeaderTitle(String title) {
            this.bundle.putString("KEY_HEADER_TITLE", title);
            return this;
        }

        public Builder setUseHeader(boolean useHeader) {
            this.bundle.putBoolean("KEY_USE_HEADER", useHeader);
            return this;
        }

        public Builder setUseHeaderRightButton(boolean useHeaderRightButton) {
            this.bundle.putBoolean("KEY_USE_HEADER_RIGHT_BUTTON", useHeaderRightButton);
            return this;
        }

        public Builder setUseHeaderLeftButton(boolean useHeaderLeftButton) {
            this.bundle.putBoolean("KEY_USE_HEADER_LEFT_BUTTON", useHeaderLeftButton);
            return this;
        }

        public Builder setHeaderLeftButtonIconResId(@DrawableRes int resId) {
            this.bundle.putInt("KEY_HEADER_LEFT_BUTTON_ICON_RES_ID", resId);
            return this;
        }

        public Builder setHeaderRightButtonIconResId(@DrawableRes int resId) {
            this.bundle.putInt("KEY_HEADER_RIGHT_BUTTON_ICON_RES_ID", resId);
            return this;
        }

        public Builder setEmptyIcon(@DrawableRes int resId) {
            this.bundle.putInt("KEY_EMPTY_ICON_RES_ID", resId);
            return this;
        }

        public Builder setEmptyText(@StringRes int resId) {
            this.bundle.putInt("KEY_EMPTY_TEXT_RES_ID", resId);
            return this;
        }

        public Builder setHeaderLeftButtonListener(View.OnClickListener listener) {
            this.headerLeftButtonListener = listener;
            return this;
        }

        public Builder setHeaderRightButtonListener(View.OnClickListener listener) {
            this.headerRightButtonListener = listener;
            return this;
        }

        public <T extends MemberListAdapter> Builder setMemberListAdapter(T adapter) {
            this.adapter = adapter;
            return this;
        }

        public Builder setItemClickListener(OnItemClickListener<Member> itemClickListener) {
            this.itemClickListener = itemClickListener;
            return this;
        }

        public Builder setItemLongClickListener(OnItemLongClickListener<Member> itemLongClickListener) {
            this.itemLongClickListener = itemLongClickListener;
            return this;
        }

        public Builder setActionItemClickListener(OnItemClickListener<Member> actionItemClickListener) {
            this.actionItemClickListener = actionItemClickListener;
            return this;
        }

        public MemberListFragment build() {
            MemberListFragment fragment = this.customFragment != null ? this.customFragment : new MemberListFragment();
            fragment.setArguments(this.bundle);
            fragment.setHeaderLeftButtonListener(this.headerLeftButtonListener);
            fragment.setHeaderRightButtonListener(this.headerRightButtonListener);
            fragment.setItemClickListener(this.itemClickListener);
            fragment.setItemLongClickListener(this.itemLongClickListener);
            fragment.setMemberListAdapter(this.adapter);
            fragment.setActionItemClickListener(this.actionItemClickListener);
            return fragment;
        }
    }

    private static class MemberListQuery
    implements CustomMemberListQueryHandler<Member> {
        private final GroupChannel channel;
        private GroupChannelMemberListQuery query;

        MemberListQuery(@NonNull GroupChannel channel) {
            this.channel = channel;
        }

        @Override
        public void loadInitial(OnListResultHandler<Member> handler) {
            this.query = this.channel.createMemberListQuery();
            this.query.setLimit(30);
            this.load(handler);
        }

        @Override
        public void load(OnListResultHandler<Member> handler) {
            this.query.next(handler::onResult);
        }

        @Override
        public boolean hasMore() {
            return this.query.hasNext();
        }
    }
}

