/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.activities;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import com.sendbird.uikit.R;
import com.sendbird.uikit.SendBirdUIKit;
import com.sendbird.uikit.dialogs.DialogHelper;
import com.sendbird.uikit.fragments.OperatorListFragment;
import com.sendbird.uikit.utils.TextUtils;

public class OperatorListActivity
extends AppCompatActivity {
    public static Intent newIntent(@NonNull Context context, @NonNull String channelUrl) {
        return OperatorListActivity.newIntentFromCustomActivity(context, OperatorListActivity.class, channelUrl);
    }

    public static Intent newIntentFromCustomActivity(@NonNull Context context, @NonNull Class<? extends OperatorListActivity> cls, @NonNull String channelUrl) {
        Intent intent = new Intent(context, cls);
        intent.putExtra("KEY_CHANNEL_URL", channelUrl);
        return intent;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setTheme(SendBirdUIKit.isDarkMode() ? R.style.SendBird_Dark : R.style.SendBird);
        this.setContentView(R.layout.sb_activity);
        String url = this.getIntent().getStringExtra("KEY_CHANNEL_URL");
        if (TextUtils.isEmpty(url)) {
            DialogHelper.toastError((Context)this, R.string.sb_text_error_get_channel);
        } else {
            Fragment fragment = this.createOperatorListFragment(url);
            FragmentManager manager = this.getSupportFragmentManager();
            manager.popBackStack();
            manager.beginTransaction().replace(R.id.sb_fragment_container, fragment).commit();
        }
    }

    protected Fragment createOperatorListFragment(@NonNull String channelUrl) {
        return new OperatorListFragment.Builder(channelUrl).setUseHeader(true).setUseHeaderRightButton(true).setHeaderTitle(this.getString(R.string.sb_text_menu_operators)).setEmptyIcon(R.drawable.icon_chat).setEmptyText(R.string.sb_text_empty_no_operator_member).build();
    }
}

