/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.widgets;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.os.Build;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.widget.ImageViewCompat;
import androidx.databinding.DataBindingUtil;
import com.sendbird.uikit.R;
import com.sendbird.uikit.databinding.SbViewMessageInputBinding;
import com.sendbird.uikit.log.Logger;
import com.sendbird.uikit.utils.TextUtils;
import java.lang.reflect.Field;

public class MessageInputView
extends FrameLayout {
    private SbViewMessageInputBinding binding;

    public MessageInputView(@NonNull Context context) {
        this(context, null);
    }

    public MessageInputView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.sb_message_input_style);
    }

    public MessageInputView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.MessageInput, defStyleAttr, 0);
        try {
            this.binding = (SbViewMessageInputBinding)DataBindingUtil.inflate((LayoutInflater)LayoutInflater.from((Context)this.getContext()), (int)R.layout.sb_view_message_input, (ViewGroup)this, (boolean)true);
            int backgroundId = a.getResourceId(R.styleable.MessageInput_sb_message_input_background, R.color.background_100);
            int textBackgroundId = a.getResourceId(R.styleable.MessageInput_sb_message_input_text_background, R.drawable.sb_message_input_text_background_light);
            int textAppearance = a.getResourceId(R.styleable.MessageInput_sb_message_input_text_appearance, R.style.SendbirdBody2OnLight01);
            ColorStateList hintColor = a.getColorStateList(R.styleable.MessageInput_sb_message_input_text_hint_color);
            int textCursorDrawable = a.getResourceId(R.styleable.MessageInput_sb_message_input_text_cursor_drawable, R.drawable.sb_message_input_cursor_light);
            boolean isEnabled = a.getBoolean(R.styleable.MessageInput_sb_message_input_enable, true);
            int leftButtonTint = a.getResourceId(R.styleable.MessageInput_sb_message_input_left_button_tint, R.color.primary_300);
            int leftButtonBackground = a.getResourceId(R.styleable.MessageInput_sb_message_input_left_button_background, R.drawable.sb_button_uncontained_background_light);
            int rightButtonTint = a.getResourceId(R.styleable.MessageInput_sb_message_input_right_button_tint, R.color.primary_300);
            int rightButtonBackground = a.getResourceId(R.styleable.MessageInput_sb_message_input_right_button_background, R.drawable.sb_button_uncontained_background_light);
            int editSaveButtonTextAppearance = a.getResourceId(R.styleable.MessageInput_sb_message_input_edit_save_button_text_appearance, R.style.SendbirdButtonOnDark01);
            int editSaveButtonTextColor = a.getResourceId(R.styleable.MessageInput_sb_message_input_edit_save_button_text_color, R.color.sb_button_contained_text_color_light);
            int editSaveButtonBackground = a.getResourceId(R.styleable.MessageInput_sb_message_input_edit_save_button_background, R.drawable.sb_button_contained_background_light);
            int editCancelButtonTextAppearance = a.getResourceId(R.styleable.MessageInput_sb_message_input_edit_cancel_button_text_appearance, R.style.SendbirdButtonPrimary300);
            int editCancelButtonTextColor = a.getResourceId(R.styleable.MessageInput_sb_message_input_edit_cancel_button_text_color, R.color.sb_button_uncontained_text_color_light);
            int editCancelButtonBackground = a.getResourceId(R.styleable.MessageInput_sb_message_input_edit_cancel_button_background, R.drawable.sb_button_uncontained_background_light);
            this.binding.messageInputParent.setBackgroundResource(backgroundId);
            this.binding.etInputText.setBackgroundResource(textBackgroundId);
            this.binding.etInputText.setTextAppearance(context, textAppearance);
            if (hintColor != null) {
                this.binding.etInputText.setHintTextColor(hintColor);
            }
            if (Build.VERSION.SDK_INT >= 29) {
                this.binding.etInputText.setTextCursorDrawable(textCursorDrawable);
            } else {
                Field f = TextView.class.getDeclaredField("mCursorDrawableRes");
                f.setAccessible(true);
                f.set(this.binding.etInputText, textCursorDrawable);
            }
            this.setEnabled(isEnabled);
            this.binding.ibtnAdd.setBackgroundResource(leftButtonBackground);
            ImageViewCompat.setImageTintList((ImageView)this.binding.ibtnAdd, (ColorStateList)this.getResources().getColorStateList(leftButtonTint));
            this.binding.ibtnSend.setBackgroundResource(rightButtonBackground);
            ImageViewCompat.setImageTintList((ImageView)this.binding.ibtnSend, (ColorStateList)this.getResources().getColorStateList(rightButtonTint));
            this.binding.btnSave.setTextAppearance(context, editSaveButtonTextAppearance);
            this.binding.btnSave.setTextColor(context.getResources().getColorStateList(editSaveButtonTextColor));
            this.binding.btnSave.setBackgroundResource(editSaveButtonBackground);
            this.binding.btnCancel.setTextAppearance(context, editCancelButtonTextAppearance);
            this.binding.btnCancel.setTextColor(context.getResources().getColorStateList(editCancelButtonTextColor));
            this.binding.btnCancel.setBackgroundResource(editCancelButtonBackground);
        }
        catch (Exception e) {
            Logger.e(e);
        }
        finally {
            a.recycle();
        }
    }

    public void showEditMode(CharSequence text) {
        this.binding.etInputText.setText(text);
        this.binding.ibtnAdd.setVisibility(8);
        this.binding.editPanel.setVisibility(0);
        if (!TextUtils.isEmpty(text)) {
            this.binding.etInputText.setSelection(text.length());
        }
    }

    public void hideEditMode() {
        this.binding.etInputText.setText((CharSequence)"");
        this.binding.ibtnAdd.setVisibility(0);
        this.binding.editPanel.setVisibility(8);
    }

    public SbViewMessageInputBinding getBinding() {
        return this.binding;
    }

    public View getLayout() {
        return this;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.binding.ibtnAdd.setEnabled(enabled);
        this.binding.etInputText.setEnabled(enabled);
        this.binding.ibtnSend.setEnabled(enabled);
    }
}

