/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.utils;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.TextAppearanceSpan;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.databinding.BindingAdapter;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.Key;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.engine.GlideException;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.signature.ObjectKey;
import com.sendbird.android.AdminMessage;
import com.sendbird.android.BaseChannel;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.Emoji;
import com.sendbird.android.FileMessage;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.Reaction;
import com.sendbird.android.SendBird;
import com.sendbird.android.Sender;
import com.sendbird.android.User;
import com.sendbird.uikit.BR;
import com.sendbird.uikit.R;
import com.sendbird.uikit.SendBirdUIKit;
import com.sendbird.uikit.interfaces.UserInfo;
import com.sendbird.uikit.log.Logger;
import com.sendbird.uikit.model.EmojiManager;
import com.sendbird.uikit.model.FileInfo;
import com.sendbird.uikit.utils.ChannelUtils;
import com.sendbird.uikit.utils.DrawableUtils;
import com.sendbird.uikit.utils.MessageUtils;
import com.sendbird.uikit.utils.ReactionUtils;
import com.sendbird.uikit.vm.PendingMessageRepository;
import com.sendbird.uikit.vm.UserListViewModel;
import com.sendbird.uikit.widgets.AdminMessageView;
import com.sendbird.uikit.widgets.BaseMessageView;
import com.sendbird.uikit.widgets.EmoijReactionUserView;
import com.sendbird.uikit.widgets.EmojiReactionCountView;
import com.sendbird.uikit.widgets.EmojiReactionListView;
import com.sendbird.uikit.widgets.EmojiReactionView;
import com.sendbird.uikit.widgets.EmojiView;
import com.sendbird.uikit.widgets.MyMessageStatusView;
import com.sendbird.uikit.widgets.RoundCornerView;
import com.sendbird.uikit.widgets.TimelineMessageView;
import com.sendbird.uikit.widgets.UserPreview;
import java.util.ArrayList;
import java.util.List;

public class BindUtils {
    @BindingAdapter(value={"message", "channel"})
    public static void drawMessageWithChannel(BaseMessageView view, BaseMessage message, BaseChannel channel) {
        view.getBinding().setVariable(BR.message, (Object)message);
        view.getBinding().setVariable(BR.channel, (Object)channel);
        view.getBinding().executePendingBindings();
    }

    @BindingAdapter(value={"channel"})
    public static void drawReactionEnabled(EmojiReactionListView view, BaseChannel channel) {
        boolean canSendReaction = ReactionUtils.canSendReaction(channel);
        view.setClickable(canSendReaction);
        if (view.useMoreButton() != canSendReaction) {
            view.setUseMoreButton(canSendReaction);
            view.refresh();
        }
    }

    @BindingAdapter(value={"draw_message"})
    public static void drawMessage(TextView view, BaseMessage message) {
        if (message == null) {
            return;
        }
        if (MessageUtils.isUnknownType(message)) {
            BindUtils.drawUnknownMessage(view, MessageUtils.isMine(message));
            return;
        }
        view.setText((CharSequence)message.getMessage());
        if (message.getUpdatedAt() <= 0L) {
            return;
        }
        boolean isMine = MessageUtils.isMine(message);
        int editedAppearance = SendBirdUIKit.isDarkMode() ? (isMine ? R.style.SendbirdBody1OnLight02 : R.style.SendbirdBody1OnDark02) : (isMine ? R.style.SendbirdBody1OnDark02 : R.style.SendbirdBody1OnLight02);
        String edited = view.getResources().getString(R.string.sb_text_channel_message_badge_edited);
        SpannableString spannable = new SpannableString((CharSequence)edited);
        spannable.setSpan((Object)new TextAppearanceSpan(view.getContext(), editedAppearance), 0, edited.length(), 33);
        view.append((CharSequence)spannable);
    }

    private static void drawUnknownMessage(TextView view, boolean isMine) {
        int unknownHintAppearance = isMine ? (SendBirdUIKit.isDarkMode() ? R.style.SendbirdBody1OnLight02 : R.style.SendbirdBody1OnDark02) : (SendBirdUIKit.isDarkMode() ? R.style.SendbirdBody1OnDark03 : R.style.SendbirdBody1OnLight02);
        int sizeOfFirstLine = 23;
        String unknownHintText = view.getContext().getResources().getString(R.string.sb_text_channel_unknown_type_text);
        SpannableString spannable = new SpannableString((CharSequence)unknownHintText);
        spannable.setSpan((Object)new TextAppearanceSpan(view.getContext(), unknownHintAppearance), 23, spannable.length(), 33);
        view.setText((CharSequence)spannable);
    }

    @BindingAdapter(value={"draw_thumbnail"})
    public static void drawThumbnail(final RoundCornerView view, FileMessage message) {
        String url = message.getUrl();
        Context context = view.getContext();
        RequestOptions options = (RequestOptions)new RequestOptions().diskCacheStrategy(DiskCacheStrategy.ALL);
        RequestBuilder builder = Glide.with((Context)context).asDrawable().apply((BaseRequestOptions)options);
        int width = context.getResources().getDimensionPixelSize(R.dimen.sb_default_thumbnail_width);
        int height = context.getResources().getDimensionPixelSize(R.dimen.sb_default_thumbnail_height);
        FileInfo fileInfo = PendingMessageRepository.getInstance().getFileInfo((BaseMessage)message);
        if (fileInfo != null) {
            width = fileInfo.getThumbnailWidth();
            height = fileInfo.getThumbnailHeight();
            builder = (RequestBuilder)builder.override(width, height);
            if (!TextUtils.isEmpty((CharSequence)fileInfo.getThumbnailPath())) {
                url = fileInfo.getThumbnailPath();
            }
        } else {
            List thumbnails = message.getThumbnails();
            FileMessage.Thumbnail thumbnail = null;
            if (thumbnails.size() > 0) {
                thumbnail = (FileMessage.Thumbnail)thumbnails.get(0);
            }
            if (thumbnail != null) {
                Logger.dev("++ thumbnail width : %s, thumbnail height : %s", thumbnail.getRealWidth(), thumbnail.getRealHeight());
                width = thumbnail.getRealWidth();
                height = thumbnail.getRealHeight();
                url = thumbnail.getUrl();
            }
            builder = (RequestBuilder)builder.override(width, height);
        }
        if (message.getType().toLowerCase().contains("image") && !message.getType().toLowerCase().contains("gif")) {
            view.getContent().setScaleType(ImageView.ScaleType.CENTER);
            builder = (RequestBuilder)((RequestBuilder)builder.placeholder(SendBirdUIKit.isDarkMode() ? R.drawable.icon_thumbnail_dark : R.drawable.icon_thumbnail_light)).error(SendBirdUIKit.isDarkMode() ? R.drawable.icon_no_thumbnail_dark : R.drawable.icon_no_thumbnail_light);
        }
        ((RequestBuilder)builder.load(url).centerCrop()).thumbnail(0.3f).listener((RequestListener)new RequestListener<Drawable>(){

            public boolean onLoadFailed(@Nullable GlideException e, Object model, Target<Drawable> target, boolean isFirstResource) {
                return false;
            }

            public boolean onResourceReady(Drawable resource, Object model, Target<Drawable> target, DataSource dataSource, boolean isFirstResource) {
                view.getContent().setScaleType(ImageView.ScaleType.CENTER_CROP);
                return false;
            }
        }).into(view.getContent());
    }

    @BindingAdapter(value={"thumbnail_icon"})
    public static void drawThumbnailIcon(ImageView imageView, FileMessage fileMessage) {
        String type = fileMessage.getType();
        if (type.toLowerCase().contains("gif")) {
            imageView.setImageResource(R.drawable.icon_gif);
        } else if (type.toLowerCase().contains("video")) {
            imageView.setImageResource(R.drawable.icon_play);
        } else {
            imageView.setImageResource(17170445);
        }
    }

    @BindingAdapter(value={"file_icon"})
    public static void drawFileIcon(ImageView imageView, FileMessage fileMessage) {
        SendBirdUIKit.ThemeMode theme = SendBirdUIKit.getDefaultThemeMode();
        if (fileMessage.getType().toLowerCase().startsWith("audio")) {
            imageView.setImageDrawable(DrawableUtils.setTintList(imageView.getContext(), R.drawable.icon_file_audio, theme.getTintResId()));
        } else {
            imageView.setImageDrawable(DrawableUtils.setTintList(imageView.getContext(), R.drawable.icon_file_document, theme.getTintResId()));
        }
    }

    @BindingAdapter(value={"message"})
    public static void drawTimeline(TimelineMessageView view, BaseMessage message) {
        view.getBinding().setMessage(message);
        view.getBinding().executePendingBindings();
    }

    @BindingAdapter(value={"message"})
    public static void drawMessage(AdminMessageView view, AdminMessage message) {
        view.getBinding().setMessage(message);
        view.getBinding().executePendingBindings();
    }

    @BindingAdapter(value={"user", "user_list_view_model"})
    public static void drawUser(UserPreview userPreview, UserInfo user, UserListViewModel viewModel) {
        Context context = userPreview.getContext();
        String nickname = TextUtils.isEmpty((CharSequence)user.getNickname()) ? context.getString(R.string.sb_text_channel_list_title_unknown) : user.getNickname();
        userPreview.getBinding().tvNickname.setText((CharSequence)nickname);
        ChannelUtils.loadImage(userPreview.getBinding().ivUserCover, user);
        if (user.getUserId().equals(SendBird.getCurrentUser().getUserId())) {
            String meBadge = userPreview.getResources().getString(R.string.sb_text_user_list_badge_me);
            SpannableString spannable = new SpannableString((CharSequence)meBadge);
            int badgeAppearance = SendBirdUIKit.isDarkMode() ? R.style.SendbirdSubtitle2OnDark02 : R.style.SendbirdSubtitle2OnLight02;
            spannable.setSpan((Object)new TextAppearanceSpan(userPreview.getContext(), badgeAppearance), 0, meBadge.length(), 33);
            userPreview.getBinding().tvNickname.append((CharSequence)spannable);
            userPreview.setEnabled(false);
            userPreview.getBinding().cbUserPreview.setEnabled(false);
            return;
        }
        userPreview.setOnCheckedChangeListener((buttonView, isChecked) -> viewModel.setSelectedUser(user.getUserId(), isChecked));
        userPreview.setOnClickListener(v -> userPreview.setChecked(!userPreview.isChecked()));
        userPreview.setInvited(viewModel.isInvited(user.getUserId()));
        userPreview.setChecked(viewModel.isUserChecked(user.getUserId()));
        userPreview.getBinding().executePendingBindings();
    }

    @BindingAdapter(value={"user"})
    public static void drawMember(UserPreview userPreview, UserInfo user) {
        userPreview.getBinding().cbUserPreview.setVisibility(8);
        Context context = userPreview.getContext();
        String nickname = TextUtils.isEmpty((CharSequence)user.getNickname()) ? context.getString(R.string.sb_text_channel_list_title_unknown) : user.getNickname();
        userPreview.getBinding().tvNickname.setText((CharSequence)nickname);
        ChannelUtils.loadImage(userPreview.getBinding().ivUserCover, user);
        if (user.getUserId().equals(SendBird.getCurrentUser().getUserId())) {
            String meBadge = userPreview.getResources().getString(R.string.sb_text_user_list_badge_me);
            SpannableString spannable = new SpannableString((CharSequence)meBadge);
            int badgeAppearance = SendBirdUIKit.isDarkMode() ? R.style.SendbirdSubtitle2OnDark02 : R.style.SendbirdSubtitle2OnLight02;
            spannable.setSpan((Object)new TextAppearanceSpan(userPreview.getContext(), badgeAppearance), 0, meBadge.length(), 33);
            userPreview.getBinding().tvNickname.append((CharSequence)spannable);
        }
    }

    @BindingAdapter(value={"user"})
    public static void drawUser(EmoijReactionUserView userView, User user) {
        Context context = userView.getContext();
        String nickname = context.getString(R.string.sb_text_channel_list_title_unknown);
        ArrayList<String> urls = new ArrayList<String>();
        if (user != null) {
            nickname = TextUtils.isEmpty((CharSequence)user.getNickname()) ? context.getString(R.string.sb_text_channel_list_title_unknown) : user.getNickname();
            urls.add(user.getProfileUrl());
        }
        userView.getBinding().tvNickname.setText((CharSequence)nickname);
        userView.getBinding().ivUserCover.loadImages(urls);
        if (user != null && user.getUserId().equals(SendBird.getCurrentUser().getUserId())) {
            String meBadge = userView.getResources().getString(R.string.sb_text_user_list_badge_me);
            SpannableString spannable = new SpannableString((CharSequence)meBadge);
            int badgeAppearance = SendBirdUIKit.isDarkMode() ? R.style.SendbirdSubtitle2OnDark02 : R.style.SendbirdSubtitle2OnLight02;
            spannable.setSpan((Object)new TextAppearanceSpan(userView.getContext(), badgeAppearance), 0, meBadge.length(), 33);
            userView.getBinding().tvNickname.append((CharSequence)spannable);
        }
    }

    @BindingAdapter(value={"draw_user_nickname"})
    public static void drawNickname(TextView tvNickname, BaseMessage message) {
        if (message == null) {
            return;
        }
        Sender sender = message.getSender();
        String nickname = sender == null || TextUtils.isEmpty((CharSequence)sender.getNickname()) ? tvNickname.getContext().getString(R.string.sb_text_channel_list_title_unknown) : sender.getNickname();
        tvNickname.setText((CharSequence)nickname);
    }

    @BindingAdapter(value={"draw_user_profile"})
    public static void drawProfile(ImageView ivProfile, BaseMessage message) {
        if (message == null) {
            return;
        }
        Sender sender = message.getSender();
        String url = "";
        if (sender != null && !TextUtils.isEmpty((CharSequence)sender.getProfileUrl())) {
            url = sender.getProfileUrl();
        }
        ((RequestBuilder)((RequestBuilder)((RequestBuilder)Glide.with((Context)ivProfile.getContext()).load(url).diskCacheStrategy(DiskCacheStrategy.ALL)).signature((Key)new ObjectKey((Object)url))).error(SendBirdUIKit.isDarkMode() ? R.drawable.icon_avatar_dark : R.drawable.icon_avatar_light)).apply((BaseRequestOptions)RequestOptions.circleCropTransform()).into(ivProfile);
    }

    @BindingAdapter(value={"status", "channel"})
    public static void drawStatus(MyMessageStatusView statusView, BaseMessage message, GroupChannel channel) {
        if (message == null) {
            return;
        }
        BaseMessage.SendingStatus status = message.getSendingStatus();
        switch (status) {
            case CANCELED: 
            case FAILED: {
                statusView.drawError();
                break;
            }
            case SUCCEEDED: {
                int unreadMemberCount = channel.getUnreadMemberCount(message);
                int unDeliveredMemberCount = channel.getUndeliveredMemberCount(message);
                if (unreadMemberCount == 0) {
                    statusView.drawRead();
                    break;
                }
                if (unDeliveredMemberCount == 0) {
                    statusView.drawDelivered();
                    break;
                }
                statusView.drawSent();
                break;
            }
            default: {
                statusView.drawProgress();
            }
        }
    }

    @BindingAdapter(value={"reaction"})
    public static void drawReaction(@NonNull EmojiReactionView view, Reaction reaction) {
        if (reaction == null || reaction.getUserIds() == null) {
            return;
        }
        view.setCount(reaction.getUserIds().size());
        view.setEmojiUrl(EmojiManager.getInstance().getEmojiUrl(reaction.getKey()));
    }

    @BindingAdapter(value={"reaction"})
    public static void drawReaction(EmojiReactionCountView view, Reaction reaction) {
        if (reaction == null || reaction.getUserIds() == null) {
            return;
        }
        view.setCount(reaction.getUserIds().size());
        view.setEmojiUrl(EmojiManager.getInstance().getEmojiUrl(reaction.getKey()));
    }

    @BindingAdapter(value={"emoji"})
    public static void drawEmoji(@NonNull EmojiView view, Emoji emoji) {
        if (emoji == null) {
            return;
        }
        view.setEmojiUrl(EmojiManager.getInstance().getEmojiUrl(emoji.getKey()));
    }
}

