/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.dialogs;

import android.app.Dialog;
import android.content.Context;
import android.view.View;
import android.widget.PopupWindow;
import android.widget.Toast;
import androidx.annotation.StringRes;
import androidx.appcompat.app.AlertDialog;
import androidx.core.content.ContextCompat;
import com.sendbird.uikit.R;
import com.sendbird.uikit.dialogs.DialogListAdapter;
import com.sendbird.uikit.dialogs.DialogView;
import com.sendbird.uikit.dialogs.ToastView;

public class DialogHelper {
    private static Toast toast;
    private static PopupWindow popup;
    private static AlertDialog dialog;

    public static void showList(Context context, int title, DialogListItem[] items, DialogResultListener listener) {
        DialogHelper.showList(context, context.getString(title), items, listener);
    }

    public static void showList(Context context, CharSequence title, DialogListItem[] items, DialogResultListener listener) {
        if (dialog != null && dialog.isShowing()) {
            dialog.dismiss();
        }
        AlertDialog.Builder builder = DialogHelper.createDialogBuilder(context, R.style.SendBird_Dialog);
        DialogView dialogView = DialogHelper.createDialogView(context);
        DialogListAdapter adapter = DialogHelper.createDialogListAdapter(items, listener, false);
        dialogView.setTitle(title);
        dialogView.setAdapter(adapter);
        builder.setView((View)dialogView);
        dialog = builder.create();
        adapter.setDialog((Dialog)dialog);
        dialog.show();
        int width = (int)context.getResources().getDimension(R.dimen.sb_dialog_width_280);
        if (dialog.getWindow() != null) {
            dialog.getWindow().setLayout(width, -2);
        }
    }

    public static void showMessageConfirm(Context context, int message, int leftButtonText, View.OnClickListener leftButtonListener, int rightButtonText, View.OnClickListener rightButtonListener) {
        if (dialog != null && dialog.isShowing()) {
            dialog.dismiss();
        }
        AlertDialog.Builder builder = DialogHelper.createDialogBuilder(context, R.style.SendBird_Dialog);
        DialogView dialogView = DialogHelper.createDialogView(context);
        dialogView.setMessage(message);
        dialogView.setLeftButton(leftButtonText, leftButtonListener);
        dialogView.setRightButton(rightButtonText, rightButtonListener);
        builder.setView((View)dialogView);
        dialog = builder.create();
        dialogView.setDialog((Dialog)dialog);
        dialog.show();
        int width = (int)context.getResources().getDimension(R.dimen.sb_dialog_width_280);
        if (dialog.getWindow() != null) {
            dialog.getWindow().setLayout(width, -2);
        }
    }

    public static void showConfirm(Context context, int title, int leftButtonText, View.OnClickListener leftButtonListener, int rightButtonText, View.OnClickListener rightButtonListener) {
        if (dialog != null && dialog.isShowing()) {
            dialog.dismiss();
        }
        AlertDialog.Builder builder = DialogHelper.createDialogBuilder(context, R.style.SendBird_Dialog);
        DialogView dialogView = DialogHelper.createDialogView(context);
        dialogView.setTitle(title);
        dialogView.setLeftButton(leftButtonText, leftButtonListener);
        dialogView.setRightButton(rightButtonText, rightButtonListener);
        builder.setView((View)dialogView);
        dialog = builder.create();
        dialogView.setDialog((Dialog)dialog);
        dialog.show();
        int width = (int)context.getResources().getDimension(R.dimen.sb_dialog_width_280);
        if (dialog.getWindow() != null) {
            dialog.getWindow().setLayout(width, -2);
        }
    }

    public static void showWarning(Context context, int title, int cancelButtonText, View.OnClickListener cancelButtonListener, int warningButtonText, View.OnClickListener warningButtonListener) {
        if (dialog != null && dialog.isShowing()) {
            dialog.dismiss();
        }
        if (context == null) {
            return;
        }
        AlertDialog.Builder builder = DialogHelper.createDialogBuilder(context, R.style.SendBird_Dialog);
        DialogView dialogView = DialogHelper.createDialogView(context);
        dialogView.setTitle(title);
        dialogView.setCancelButton(cancelButtonText, cancelButtonListener);
        dialogView.setWarningButton(warningButtonText, warningButtonListener);
        builder.setView((View)dialogView);
        dialog = builder.create();
        dialogView.setDialog((Dialog)dialog);
        dialog.show();
        int width = (int)context.getResources().getDimension(R.dimen.sb_dialog_width_280);
        if (dialog.getWindow() != null) {
            dialog.getWindow().setLayout(width, -2);
        }
    }

    public static void showEditText(Context context, int title, int hint, int leftButtonText, View.OnClickListener leftButtonListener, int rightButtonText, OnEditTextResultListener onTextResultListener) {
        if (dialog != null && dialog.isShowing()) {
            dialog.dismiss();
        }
        AlertDialog.Builder builder = DialogHelper.createDialogBuilder(context, R.style.SendBird_Dialog);
        DialogView dialogView = DialogHelper.createDialogView(context);
        dialogView.setTitle(title);
        dialogView.setEditText(hint);
        dialogView.setLeftButton(leftButtonText, leftButtonListener);
        dialogView.setRightButton(rightButtonText, v -> onTextResultListener.onEditTextResult(dialogView.getEditText()));
        builder.setView((View)dialogView);
        dialog = builder.create();
        dialogView.setDialog((Dialog)dialog);
        dialog.show();
        int width = (int)context.getResources().getDimension(R.dimen.sb_dialog_width_280);
        if (dialog.getWindow() != null) {
            dialog.getWindow().setLayout(width, -2);
        }
    }

    public static void showBottomList(Context context, DialogListItem[] items, DialogResultListener listener) {
        if (dialog != null && dialog.isShowing()) {
            dialog.dismiss();
        }
        AlertDialog.Builder builder = DialogHelper.createDialogBuilder(context, R.style.SendBird_Dialog_Bottom);
        DialogView dialogView = DialogHelper.createDialogView(context);
        DialogListAdapter adapter = DialogHelper.createDialogListAdapter(items, listener, true);
        dialogView.setAdapter(adapter);
        dialogView.setBackgroundBottom();
        builder.setView((View)dialogView);
        dialog = builder.create();
        adapter.setDialog((Dialog)dialog);
        dialog.show();
        if (dialog.getWindow() != null) {
            dialog.getWindow().setGravity(80);
            dialog.getWindow().setLayout(-1, -2);
        }
    }

    public static void showAnchorList(View anchorView, View parent, DialogListItem[] items, DialogResultListener listener, boolean isRight) {
        if (popup != null) {
            popup.dismiss();
        }
        Context context = anchorView.getContext();
        popup = new PopupWindow(context);
        DialogView dialogView = DialogHelper.createDialogView(context);
        DialogListAdapter adapter = DialogHelper.createDialogListAdapter(items, key -> {
            if (popup != null) {
                popup.dismiss();
            }
            if (listener != null) {
                listener.onResult(key);
            }
        }, false);
        adapter.setNameMarginLeft(R.dimen.sb_size_16);
        dialogView.setAdapter(adapter);
        dialogView.setBackgroundAnchor();
        popup.setContentView((View)dialogView);
        popup.setHeight(-2);
        int width = (int)context.getResources().getDimension(R.dimen.sb_dialog_width_212);
        popup.setWidth(width);
        popup.setOutsideTouchable(true);
        popup.setFocusable(true);
        popup.setBackgroundDrawable(ContextCompat.getDrawable((Context)context, (int)17170445));
        int x = DialogHelper.getXoff(parent, anchorView, isRight);
        int y = DialogHelper.getYoff(parent, anchorView, (View)dialogView);
        popup.showAtLocation(anchorView, 0x800033, x, y);
    }

    public static AlertDialog showBottomListWithTopView(Context context, View topView, DialogListItem[] items, DialogResultListener listener) {
        if (dialog != null && dialog.isShowing()) {
            dialog.dismiss();
        }
        AlertDialog.Builder builder = DialogHelper.createDialogBuilder(context, R.style.SendBird_Dialog_Bottom);
        DialogView dialogView = DialogHelper.createDialogView(context);
        DialogListAdapter adapter = DialogHelper.createDialogListAdapter(items, listener, true);
        dialogView.setTopView(topView);
        dialogView.setAdapter(adapter);
        dialogView.setBackgroundBottom();
        builder.setView((View)dialogView);
        dialog = builder.create();
        adapter.setDialog((Dialog)dialog);
        dialog.show();
        if (dialog.getWindow() != null) {
            dialog.getWindow().setGravity(80);
            dialog.getWindow().setLayout(-1, -2);
        }
        return dialog;
    }

    public static AlertDialog showBottomView(Context context, View view) {
        if (dialog != null && dialog.isShowing()) {
            dialog.dismiss();
        }
        AlertDialog.Builder builder = DialogHelper.createDialogBuilder(context, R.style.SendBird_Dialog_Bottom);
        DialogView dialogView = DialogHelper.createDialogView(context);
        dialogView.setTopView(view);
        dialogView.setBackgroundBottom();
        builder.setView((View)dialogView);
        dialog = builder.create();
        dialog.show();
        if (dialog.getWindow() != null) {
            dialog.getWindow().setGravity(80);
            dialog.getWindow().setLayout(-1, -2);
        }
        return dialog;
    }

    public static boolean isAnchorShowing() {
        if (popup == null) {
            return false;
        }
        return popup.isShowing();
    }

    private static AlertDialog.Builder createDialogBuilder(Context context, int defStyleRes) {
        return new AlertDialog.Builder(context, defStyleRes);
    }

    private static DialogView createDialogView(Context context) {
        return new DialogView(context);
    }

    private static DialogListAdapter createDialogListAdapter(DialogListItem[] items, DialogResultListener listener, boolean isLeft) {
        return new DialogListAdapter(items, listener, isLeft);
    }

    private static int getXoff(View parent, View anchorView, boolean isRight) {
        if (!isRight) {
            return 0;
        }
        return parent.getMeasuredWidth() - anchorView.getMeasuredWidth();
    }

    private static int getYoff(View parent, View anchorView, View contentView) {
        contentView.measure(0, 0);
        int contentViewMeasuredHeight = contentView.getMeasuredHeight();
        int[] loc = new int[2];
        anchorView.getLocationOnScreen(loc);
        if (DialogHelper.isDropDown(parent, anchorView)) {
            return loc[1] + anchorView.getMeasuredHeight();
        }
        return loc[1] - contentViewMeasuredHeight;
    }

    private static boolean isDropDown(View parent, View anchorView) {
        int[] loc = new int[2];
        int[] parentLoc = new int[2];
        anchorView.getLocationOnScreen(loc);
        parent.getLocationOnScreen(parentLoc);
        int parentHeight = parent.getMeasuredHeight();
        return parentHeight / 2 > loc[1] - parentLoc[1];
    }

    public static void toastSuccess(Context context, @StringRes int text) {
        if (context == null) {
            return;
        }
        ToastView toastView = new ToastView(context);
        toastView.setStauts(ToastView.ToastStatus.SUCCESS);
        toastView.setText(text);
        DialogHelper.showToast(context, (View)toastView);
    }

    public static void toastSuccess(Context context, CharSequence text) {
        if (context == null) {
            return;
        }
        ToastView toastView = new ToastView(context);
        toastView.setStauts(ToastView.ToastStatus.SUCCESS);
        toastView.setText(text);
        DialogHelper.showToast(context, (View)toastView);
    }

    public static void toastError(Context context, @StringRes int resId) {
        if (context == null) {
            return;
        }
        ToastView toastView = new ToastView(context);
        toastView.setStauts(ToastView.ToastStatus.ERROR);
        toastView.setText(resId);
        DialogHelper.showToast(context, (View)toastView);
    }

    public static void toastError(Context context, String message) {
        if (context == null) {
            return;
        }
        ToastView toastView = new ToastView(context);
        toastView.setStauts(ToastView.ToastStatus.ERROR);
        toastView.setText(message);
        DialogHelper.showToast(context, (View)toastView);
    }

    private static void showToast(Context context, View toastView) {
        if (toast != null) {
            toast.cancel();
        }
        toast = new Toast(context);
        toast.setGravity(81, 0, 200);
        toast.setDuration(1);
        toast.setView(toastView);
        toast.show();
    }

    public static interface DialogResultListener {
        public void onResult(int var1);
    }

    public static class DialogListItem {
        private int key;
        private int icon;

        public DialogListItem(int key) {
            this.key = key;
        }

        public DialogListItem(int key, int icon) {
            this.key = key;
            this.icon = icon;
        }

        public int getKey() {
            return this.key;
        }

        public int getIcon() {
            return this.icon;
        }
    }

    public static interface OnEditTextResultListener {
        public void onEditTextResult(String var1);
    }
}

