/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.widgets;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.appcompat.widget.AppCompatImageView;
import com.sendbird.uikit.R;
import com.sendbird.uikit.SendBirdUIKit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

class ImageWaffleView
extends ViewGroup {
    protected final int DIVIDER_WIDTH = 1;
    private final int ROUNDING_RADIUS = 1;
    private static final int ROUND_BORDER = 1;
    private final Paint roundingPaint = new Paint();
    private final Paint borderPaint = new Paint();
    private final RectF canvasBounds = new RectF();
    private final Canvas tempCanvas = new Canvas();
    private Bitmap tempBitmap;

    public ImageWaffleView(Context context) {
        this(context, null);
    }

    public ImageWaffleView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ImageWaffleView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.roundingPaint.setAntiAlias(true);
        this.roundingPaint.setFilterBitmap(true);
        this.borderPaint.setAntiAlias(true);
    }

    protected ImageView prepareSingleImageView() {
        return this.prepareImageViews(1).get(0);
    }

    protected List<ImageView> prepareImageViews(int length) {
        ImageView toBeRemoved;
        if (length > 4 || length < 0) {
            throw new IllegalArgumentException("Invalid length : " + length);
        }
        LinkedList<ImageView> prevImageViews = new LinkedList<ImageView>();
        if (this.getChildCount() == length) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                prevImageViews.add((ImageView)this.getChildAt(i));
            }
        } else {
            this.removeAllViews();
        }
        ArrayList<ImageView> prepared = new ArrayList<ImageView>(length);
        for (int i = 0; i < length; ++i) {
            prepared.add(this.pollOrNewImageView(prevImageViews));
        }
        while ((toBeRemoved = (ImageView)prevImageViews.poll()) != null) {
            this.removeView((View)toBeRemoved);
        }
        return Collections.unmodifiableList(prepared);
    }

    private ImageView pollOrNewImageView(Queue<ImageView> prevImageViews) {
        ImageView polled = prevImageViews.poll();
        if (polled != null) {
            return polled;
        }
        KillerWaffleChildImageView imageView = new KillerWaffleChildImageView(this);
        this.addView((View)imageView);
        return imageView;
    }

    protected void dispatchDraw(Canvas canvas) {
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.isInEditMode()) {
            Paint debugPaint = new Paint(1);
            debugPaint.setColor(this.getResources().getColor(R.color.background_400));
            canvas.drawRoundRect(new RectF(0.0f, 0.0f, (float)width, (float)height), 1.0f, 1.0f, debugPaint);
            return;
        }
        if (this.tempBitmap == null || this.tempBitmap.isRecycled() || this.tempBitmap.getWidth() != this.getWidth() || this.tempBitmap.getHeight() != this.getHeight()) {
            if (this.tempBitmap != null) {
                this.tempBitmap.recycle();
            }
            try {
                this.tempBitmap = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            }
            catch (OutOfMemoryError e) {
                this.tempBitmap = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.RGB_565);
            }
        } else {
            this.tempBitmap.eraseColor(0);
        }
        this.tempCanvas.setBitmap(this.tempBitmap);
        super.dispatchDraw(this.tempCanvas);
        this.roundingPaint.setShader((Shader)new BitmapShader(this.tempBitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP));
        int paddingLeft = this.getPaddingLeft();
        int paddingRight = this.getPaddingRight();
        int paddingTop = this.getPaddingTop();
        int paddingBottom = this.getPaddingBottom();
        this.canvasBounds.set(0.0f, 0.0f, (float)width, (float)height);
        this.borderPaint.setColor(this.getResources().getColor(SendBirdUIKit.isDarkMode() ? R.color.ondark_04 : R.color.onlight_04));
        canvas.drawRoundRect(this.canvasBounds, (float)(width / 2), (float)(height / 2), this.borderPaint);
        this.canvasBounds.set((float)(1 + paddingLeft), (float)(1 + paddingTop), (float)(width - 1 - paddingRight), (float)(height - 1 - paddingBottom));
        canvas.drawRoundRect(this.canvasBounds, (float)(width / 2), (float)(height / 2), this.roundingPaint);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int specWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int specHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int halfWidth = (specWidth - 1 + 1) / 2;
        int halfHeight = (specHeight - 1 + 1) / 2;
        switch (this.getChildCount()) {
            case 1: {
                this.measureInGrid(this.getChildAt(0), specWidth, specHeight);
                break;
            }
            case 2: {
                this.measureInGrid(this.getChildAt(0), halfWidth, specHeight);
                this.measureInGrid(this.getChildAt(1), halfWidth, specHeight);
                break;
            }
            case 3: {
                this.measureInGrid(this.getChildAt(0), specWidth, halfHeight);
                this.measureInGrid(this.getChildAt(1), halfWidth, halfHeight);
                this.measureInGrid(this.getChildAt(2), halfWidth, halfHeight);
                break;
            }
            case 4: {
                this.measureInGrid(this.getChildAt(0), halfWidth, halfHeight);
                this.measureInGrid(this.getChildAt(1), halfWidth, halfHeight);
                this.measureInGrid(this.getChildAt(2), halfWidth, halfHeight);
                this.measureInGrid(this.getChildAt(3), halfWidth, halfHeight);
            }
        }
        this.setMeasuredDimension(specWidth, specHeight);
    }

    private void measureInGrid(View view, int width, int height) {
        view.measure(View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000));
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int halfWidth = (this.getMeasuredWidth() - 1 - 1) / 2;
        int halfHeight = (this.getMeasuredHeight() - 1 - 1) / 2;
        switch (this.getChildCount()) {
            case 1: {
                this.getChildAt(0).layout(0, 0, this.getMeasuredWidth(), this.getMeasuredHeight());
                break;
            }
            case 2: {
                this.getChildAt(0).layout(0, 0, halfWidth, this.getMeasuredHeight());
                this.getChildAt(1).layout(this.getMeasuredWidth() - halfWidth, 0, this.getMeasuredWidth(), this.getMeasuredHeight());
                break;
            }
            case 3: {
                this.getChildAt(0).layout(0, 0, this.getMeasuredWidth(), halfHeight);
                this.getChildAt(1).layout(0, this.getMeasuredHeight() - halfHeight, halfWidth, this.getMeasuredHeight());
                this.getChildAt(2).layout(this.getMeasuredWidth() - halfWidth, this.getMeasuredHeight() - halfHeight, this.getMeasuredWidth(), this.getMeasuredHeight());
                break;
            }
            case 4: {
                this.getChildAt(0).layout(0, 0, halfWidth, halfHeight);
                this.getChildAt(1).layout(this.getMeasuredWidth() - halfWidth, 0, this.getMeasuredWidth(), halfHeight);
                this.getChildAt(2).layout(0, this.getMeasuredHeight() - halfHeight, halfWidth, this.getMeasuredHeight());
                this.getChildAt(3).layout(this.getMeasuredWidth() - halfWidth, this.getMeasuredHeight() - halfHeight, this.getMeasuredWidth(), this.getMeasuredHeight());
            }
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.tempBitmap != null) {
            this.tempBitmap.recycle();
        }
    }

    private static class KillerWaffleChildImageView
    extends AppCompatImageView {
        final ImageWaffleView imageWaffleView;

        KillerWaffleChildImageView(ImageWaffleView imageWaffleView) {
            super(imageWaffleView.getContext());
            this.imageWaffleView = imageWaffleView;
            this.setScaleType(ImageView.ScaleType.CENTER_CROP);
        }

        public void requestLayout() {
            super.requestLayout();
            this.imageWaffleView.forceLayout();
        }

        public void invalidate() {
            super.invalidate();
            this.imageWaffleView.invalidate();
        }
    }
}

