/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.widgets;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.databinding.DataBindingUtil;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.sendbird.android.Reaction;
import com.sendbird.uikit.R;
import com.sendbird.uikit.activities.adapter.EmojiReactionListAdapter;
import com.sendbird.uikit.databinding.SbViewEmojiReactionListBinding;
import com.sendbird.uikit.interfaces.OnItemClickListener;
import com.sendbird.uikit.interfaces.OnItemLongClickListener;
import java.util.List;

public class EmojiReactionListView
extends FrameLayout {
    private SbViewEmojiReactionListBinding binding;
    private EmojiReactionListAdapter adapter;
    private GridLayoutManager layoutManager;
    private static final int MAX_SPAN_SIZE = 4;

    public EmojiReactionListView(@NonNull Context context) {
        this(context, null);
    }

    public EmojiReactionListView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.sb_emoji_reaction_style);
    }

    public EmojiReactionListView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.binding = (SbViewEmojiReactionListBinding)DataBindingUtil.inflate((LayoutInflater)LayoutInflater.from((Context)this.getContext()), (int)R.layout.sb_view_emoji_reaction_list, (ViewGroup)this, (boolean)true);
        this.layoutManager = new GridLayoutManager(this.getContext(), 4);
        this.binding.rvEmojiReactionList.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
        this.binding.rvEmojiReactionList.setHasFixedSize(true);
        this.adapter = new EmojiReactionListAdapter();
        this.binding.rvEmojiReactionList.setAdapter(this.adapter);
    }

    public void setReactionList(List<Reaction> reactionList) {
        if (this.adapter != null) {
            this.adapter.setReactionList(reactionList);
            this.resetSpanSize();
        }
    }

    private void resetSpanSize() {
        int itemSize = this.adapter.getItemCount();
        if (itemSize > 0) {
            this.layoutManager.setSpanCount(Math.min(itemSize, 4));
        }
    }

    public void setEmojiReactionClickListener(@Nullable OnItemClickListener<String> emojiReactionClickListener) {
        if (this.adapter != null) {
            this.adapter.setEmojiReactionClickListener(emojiReactionClickListener);
        }
    }

    public void setEmojiReactionLongClickListener(@Nullable OnItemLongClickListener<String> emojiReactionLongClickListener) {
        if (this.adapter != null) {
            this.adapter.setEmojiReactionLongClickListener(emojiReactionLongClickListener);
        }
    }

    public void setMoreButtonClickListener(@Nullable View.OnClickListener moreButtonClickListener) {
        if (this.adapter != null) {
            this.adapter.setMoreButtonClickListener(moreButtonClickListener);
        }
    }

    public EmojiReactionListView getLayout() {
        return this;
    }

    public SbViewEmojiReactionListBinding getBinding() {
        return this.binding;
    }
}

