/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.widgets;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.databinding.DataBindingUtil;
import com.sendbird.android.Emoji;
import com.sendbird.android.Reaction;
import com.sendbird.uikit.R;
import com.sendbird.uikit.activities.adapter.EmojiListAdapter;
import com.sendbird.uikit.databinding.SbViewEmojiListBinding;
import com.sendbird.uikit.interfaces.OnItemClickListener;
import java.util.List;

public class EmojiListView
extends FrameLayout {
    private SbViewEmojiListBinding binding;
    private EmojiListAdapter adapter;
    private int maxHeight = Integer.MAX_VALUE;

    public EmojiListView(@NonNull Context context) {
        this(context, null);
    }

    public EmojiListView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.sb_emoji_reaction_style);
    }

    public EmojiListView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    public void init(@NonNull Context context) {
        this.binding = (SbViewEmojiListBinding)DataBindingUtil.inflate((LayoutInflater)LayoutInflater.from((Context)context), (int)R.layout.sb_view_emoji_list, (ViewGroup)this, (boolean)true);
        this.maxHeight = (int)context.getResources().getDimension(R.dimen.sb_emoji_reaction_dialog_max_height);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.maxHeight > 0) {
            int hSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
            int hMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
            switch (hMode) {
                case -2147483648: {
                    heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)Math.min(hSize, this.maxHeight), (int)Integer.MIN_VALUE);
                    break;
                }
                case 0: {
                    heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.maxHeight, (int)Integer.MIN_VALUE);
                    break;
                }
                case 0x40000000: {
                    heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)Math.min(hSize, this.maxHeight), (int)0x40000000);
                }
            }
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    public void initAdapter(@NonNull Params params) {
        this.adapter = new EmojiListAdapter(params.emojiList, params.reactionList, params.showMoreButton);
        this.binding.rvEmojiList.setAdapter(this.adapter);
    }

    public void setEmojiClickListener(OnItemClickListener<String> emojiClickListener) {
        if (this.adapter != null) {
            this.adapter.setEmojiClickListener(emojiClickListener);
        }
    }

    public void setMoreButtonClickListener(View.OnClickListener moreButtonClickListener) {
        if (this.adapter != null) {
            this.adapter.setMoreButtonClickListener(moreButtonClickListener);
        }
    }

    static class Params {
        Context context;
        List<Emoji> emojiList;
        List<Reaction> reactionList;
        boolean showMoreButton;

        Params(Context context) {
            this.context = context;
        }
    }

    public static class Builder {
        Params params;

        public Builder(Context context) {
            this.params = new Params(context);
        }

        public Builder setReactionList(List<Reaction> reactionList) {
            this.params.reactionList = reactionList;
            return this;
        }

        public Builder setEmojiList(List<Emoji> emojiList) {
            this.params.emojiList = emojiList;
            return this;
        }

        public Builder setShowMoreButton(boolean showMoreButton) {
            this.params.showMoreButton = showMoreButton;
            return this;
        }

        public EmojiListView create() {
            EmojiListView emojiListView = new EmojiListView(this.params.context);
            emojiListView.initAdapter(this.params);
            return emojiListView;
        }
    }
}

