/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.vm;

import androidx.annotation.NonNull;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import com.sendbird.android.ApplicationUserListQuery;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.GroupChannelParams;
import com.sendbird.android.SendBird;
import com.sendbird.android.User;
import com.sendbird.uikit.R;
import com.sendbird.uikit.SendBirdUIKit;
import com.sendbird.uikit.interfaces.CustomUserListQueryHandler;
import com.sendbird.uikit.interfaces.DialogProvider;
import com.sendbird.uikit.interfaces.UserInfo;
import com.sendbird.uikit.interfaces.UserListResultHandler;
import com.sendbird.uikit.log.Logger;
import com.sendbird.uikit.vm.BaseViewModel;
import com.sendbird.uikit.widgets.PagerRecyclerView;
import com.sendbird.uikit.widgets.StatusFrameView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public class UserListViewModel
extends BaseViewModel
implements PagerRecyclerView.Pageable,
UserListResultHandler {
    private static final int USER_LIST_LIMIT = 15;
    private final ApplicationUserListQuery userListQuery;
    private final MutableLiveData<List<UserInfo>> userList = new MutableLiveData();
    private final MutableLiveData<Set<String>> selectedUserSet = new MutableLiveData();
    private Set<String> invitedUserSet = new HashSet<String>();
    private final MutableLiveData<StatusFrameView.Status> statusFrame = new MutableLiveData();
    private final AtomicBoolean hasMore = new AtomicBoolean();
    private final CustomUserListQueryHandler customUserListQueryHandler;
    private final MutableLiveData<GroupChannel> channelCreated = new MutableLiveData();

    @Override
    public void onResult(List<? extends UserInfo> userList, Exception e) {
        if (e != null) {
            Logger.e(e);
            this.changeAlertStatus(StatusFrameView.Status.ERROR);
            this.notifyDataSetChanged((List)this.userList.getValue());
        } else {
            ArrayList<UserInfo> newUsers = new ArrayList<UserInfo>(userList);
            List origin = (List)this.userList.getValue();
            if (origin != null) {
                newUsers.addAll(0, origin);
            }
            this.applyUserList(newUsers);
        }
    }

    UserListViewModel(DialogProvider provider, CustomUserListQueryHandler customUserListQueryHandler) {
        super(provider);
        this.userListQuery = SendBird.createApplicationUserListQuery();
        this.userListQuery.setLimit(15);
        this.customUserListQueryHandler = customUserListQueryHandler == null ? SendBirdUIKit.getCustomUserListQueryHandler() : customUserListQueryHandler;
    }

    public LiveData<List<UserInfo>> getUserList() {
        this.loadInitial();
        return this.userList;
    }

    public MutableLiveData<StatusFrameView.Status> getStatusFrame() {
        return this.statusFrame;
    }

    public MutableLiveData<Set<String>> getSelectedUserSet() {
        return this.selectedUserSet;
    }

    public MutableLiveData<GroupChannel> getChannelCreated() {
        return this.channelCreated;
    }

    public void setInvitedUser(Set<String> invitedUserSet) {
        this.invitedUserSet = invitedUserSet;
    }

    public void setSelectedUser(String userId, boolean isChecked) {
        HashSet<String> origin = (HashSet<String>)this.selectedUserSet.getValue();
        if (origin == null) {
            origin = new HashSet<String>();
        }
        if (isChecked) {
            if (!this.isInvited(userId)) {
                Logger.i("++ selected userId : %s", userId);
                origin.add(userId);
            }
        } else {
            Logger.i("++ deselected userId : %s", userId);
            origin.remove(userId);
        }
        this.selectedUserSet.postValue(origin);
    }

    public boolean isUserChecked(@NonNull String userId) {
        return this.isUserSelected(userId) || this.isInvited(userId) || this.isMe(userId);
    }

    private boolean isUserSelected(@NonNull String userId) {
        if (this.selectedUserSet.getValue() == null) {
            return false;
        }
        return ((Set)this.selectedUserSet.getValue()).contains(userId);
    }

    public boolean isMe(@NonNull String userId) {
        return userId.equals(SendBird.getCurrentUser().getUserId());
    }

    public boolean isInvited(@NonNull String userId) {
        if (this.invitedUserSet == null) {
            return false;
        }
        return this.invitedUserSet.contains(userId);
    }

    public void inviteMembers(@NonNull GroupChannel channel, @NonNull List<String> userIds, GroupChannel.GroupChannelInviteHandler handler) {
        Logger.dev(">> UserListViewModel::inviteMembers()");
        ArrayList inviteList = new ArrayList();
        if (this.selectedUserSet.getValue() != null) {
            inviteList.addAll(new ArrayList((Collection)this.selectedUserSet.getValue()));
        }
        inviteList.addAll(userIds);
        channel.inviteWithUserIds(inviteList, handler);
    }

    public void createGroupChannel(@NonNull GroupChannelParams params) {
        Logger.dev(">> UserListViewModel::createGroupChannel()");
        GroupChannel.createChannel((GroupChannelParams)params, (channel, e) -> {
            if (e != null) {
                this.provider.toastError(R.string.sb_text_error_create_channel);
                Logger.e(e);
                return;
            }
            this.channelCreated.postValue((Object)channel);
        });
    }

    @Override
    public boolean hasMore() {
        if (this.customUserListQueryHandler != null) {
            return this.customUserListQueryHandler.hasMore();
        }
        return this.hasMore.get();
    }

    @Override
    public void loadMore() {
        this.loadNext();
    }

    private void changeAlertStatus(StatusFrameView.Status status) {
        boolean hasData;
        List origin = (List)this.userList.getValue();
        boolean bl = hasData = origin != null && origin.size() > 0;
        if (!hasData || status == StatusFrameView.Status.NONE) {
            this.statusFrame.postValue((Object)status);
        }
    }

    private void applyUserList(List<UserInfo> newUserList) {
        this.changeAlertStatus(newUserList.size() == 0 ? StatusFrameView.Status.EMPTY : StatusFrameView.Status.NONE);
        this.notifyDataSetChanged(newUserList);
    }

    private void notifyDataSetChanged(List<UserInfo> newList) {
        this.userList.postValue((Object)(newList == null ? new ArrayList() : newList));
    }

    private void loadInitial() {
        if (this.customUserListQueryHandler != null) {
            this.customUserListQueryHandler.loadInitial(this);
        } else {
            this.loadFromSendBird();
        }
    }

    private void loadNext() {
        if (this.customUserListQueryHandler != null) {
            this.customUserListQueryHandler.loadNext(this);
        } else {
            this.loadFromSendBird();
        }
    }

    private void loadFromSendBird() {
        this.userListQuery.next((list, ex) -> {
            if (ex != null) {
                this.onResult(null, (Exception)((Object)ex));
                return;
            }
            this.hasMore.set(!list.isEmpty());
            Logger.dev("++ list : %s", list);
            ArrayList<1> newUsers = new ArrayList<1>();
            for (final User user : list) {
                newUsers.add(new UserInfo(){

                    @Override
                    public String getUserId() {
                        return user.getUserId();
                    }

                    @Override
                    public String getNickname() {
                        return user.getNickname();
                    }

                    @Override
                    public String getProfileUrl() {
                        return user.getProfileUrl();
                    }
                });
            }
            this.onResult(newUsers, null);
        });
    }
}

