/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.utils;

import android.content.Context;
import android.graphics.RectF;
import android.util.DisplayMetrics;
import android.util.TypedValue;

public class MetricsUtils {
    private static final int DEFAULT_DENSITY_DPI = 240;
    private static final float DEFAULT_DENSITY = 1.5f;

    private MetricsUtils() {
    }

    public static int getDensityDpi(Context context) {
        return context.getResources().getDisplayMetrics().densityDpi;
    }

    public static float getDensity(Context context) {
        return context.getResources().getDisplayMetrics().density;
    }

    public static int getDefaultDensity() {
        return 240;
    }

    public static int dipToPixel(Context context, float dip) {
        return (int)(dip * MetricsUtils.getDensity(context));
    }

    public static float pixelInDensityF(Context context, int pixel) {
        return (float)pixel / 1.5f * MetricsUtils.getDensity(context);
    }

    public static int pixelInDensity(Context context, int pixel) {
        return (int)MetricsUtils.pixelInDensityF(context, pixel);
    }

    public static float spToPixel(Context context, float sp) {
        return TypedValue.applyDimension((int)2, (float)sp, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public static RectF rotateRect(RectF originRect, float pivotX, float pivotY, double degree) {
        double angle = Math.toRadians(degree);
        float pointLeftTopX = (originRect.left - pivotX) * (float)Math.cos(angle) - (originRect.top - pivotY) * (float)Math.sin(angle) + pivotX;
        float pointLeftTopY = (originRect.left - pivotX) * (float)Math.sin(angle) + (originRect.top - pivotY) * (float)Math.cos(angle) + pivotY;
        float pointRightBottomX = (originRect.right - pivotX) * (float)Math.cos(angle) - (originRect.bottom - pivotY) * (float)Math.sin(angle) + pivotX;
        float pointRightBottomY = (originRect.right - pivotX) * (float)Math.sin(angle) + (originRect.bottom - pivotY) * (float)Math.cos(angle) + pivotY;
        return new RectF(Math.min(pointLeftTopX, pointRightBottomX), Math.min(pointLeftTopY, pointRightBottomY), Math.max(pointLeftTopX, pointRightBottomX), Math.max(pointLeftTopY, pointRightBottomY));
    }
}

