/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.utils;

import android.content.ClipData;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import java.util.List;

public class IntentUtils {
    public static boolean hasIntent(@NonNull Context context, @NonNull Intent intent) {
        return intent.resolveActivity(context.getPackageManager()) != null;
    }

    public static Intent getCameraIntent(@NonNull Context context, @NonNull Uri uri) {
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        intent.putExtra("output", (Parcelable)uri);
        IntentUtils.grantWritePermission(context, intent, uri);
        if (Build.VERSION.SDK_INT <= 21) {
            intent.setClipData(ClipData.newRawUri((CharSequence)"", (Uri)uri));
            intent.addFlags(3);
        }
        intent.addFlags(0x24000000);
        return intent;
    }

    public static Intent getGalleryIntent() {
        Intent intent = new Intent();
        intent.setAction("android.intent.action.GET_CONTENT");
        if (Build.VERSION.SDK_INT > 19) {
            intent.setType("*/*");
            String[] mimetypes = new String[]{"image/*", "video/*"};
            intent.putExtra("android.intent.extra.MIME_TYPES", mimetypes);
        } else {
            intent.setType("image/*|video/*");
        }
        intent.addFlags(0x24000000);
        return Intent.createChooser((Intent)intent, null);
    }

    public static Intent getFileChooserIntent() {
        Intent intent = new Intent();
        intent.setType("*/*");
        intent.setAction("android.intent.action.GET_CONTENT");
        intent.addCategory("android.intent.category.OPENABLE");
        intent.addFlags(0x24000000);
        return intent;
    }

    public static Intent getFileViewerIntent(@NonNull Uri uri, @NonNull String mimeType) {
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setDataAndType(uri, mimeType);
        intent.addFlags(0x10000000);
        intent.addFlags(1);
        intent.addFlags(2);
        return Intent.createChooser((Intent)intent, null);
    }

    private static void grantWritePermission(Context context, Intent intent, Uri uri) {
        List resInfoList = context.getPackageManager().queryIntentActivities(intent, 65536);
        for (ResolveInfo resolveInfo : resInfoList) {
            String packageName = resolveInfo.activityInfo.packageName;
            context.grantUriPermission(packageName, uri, 3);
        }
    }
}

