/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.vm;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.FileMessage;
import com.sendbird.uikit.model.FileInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PendingMessageRepository {
    private final Map<String, List<BaseMessage>> pendingMessageMap = new ConcurrentHashMap<String, List<BaseMessage>>();
    private final Map<String, FileInfo> cachedFileInfos = new ConcurrentHashMap<String, FileInfo>();

    private PendingMessageRepository() {
    }

    public static PendingMessageRepository getInstance() {
        return PendingMessageManagerHolder.INSTANCE;
    }

    public FileInfo getFileInfo(@NonNull BaseMessage message) {
        return this.cachedFileInfos.get(message.getRequestId());
    }

    public void addFileInfo(@NonNull FileMessage message, @NonNull FileInfo fileInfo) {
        this.cachedFileInfos.put(message.getRequestId(), fileInfo);
    }

    void addPendingMessage(@NonNull String channelUrl, @NonNull BaseMessage message) {
        List<BaseMessage> pendingMessages = this.pendingMessageMap.get(channelUrl);
        if (pendingMessages == null) {
            pendingMessages = new ArrayList<BaseMessage>();
        }
        pendingMessages.add(0, message);
        this.pendingMessageMap.put(channelUrl, pendingMessages);
    }

    void updatePendingMessage(@NonNull String channelUrl, @Nullable BaseMessage message) {
        if (message == null) {
            return;
        }
        List<BaseMessage> pendingMessages = this.pendingMessageMap.get(channelUrl);
        if (pendingMessages != null) {
            for (int i = pendingMessages.size() - 1; i >= 0; --i) {
                BaseMessage msg = pendingMessages.get(i);
                if (!msg.getRequestId().equals(message.getRequestId())) continue;
                pendingMessages.set(i, message);
                break;
            }
            this.pendingMessageMap.put(channelUrl, pendingMessages);
        }
    }

    void removePendingMessage(@NonNull String channelUrl, @NonNull BaseMessage message) {
        List<BaseMessage> pendingMessages = this.pendingMessageMap.get(channelUrl);
        String reqId = message.getRequestId();
        if (pendingMessages != null && reqId != null) {
            for (BaseMessage pendingMessage : pendingMessages) {
                String pendingMessageReqId;
                if (message.getClass() != pendingMessage.getClass() || !reqId.equals(pendingMessageReqId = pendingMessage.getRequestId())) continue;
                pendingMessages.remove(pendingMessage);
                break;
            }
            this.pendingMessageMap.put(channelUrl, pendingMessages);
        }
    }

    @NonNull
    List<BaseMessage> getPendingMessageList(@NonNull String channelUrl) {
        ArrayList pendingList = this.pendingMessageMap.get(channelUrl);
        return pendingList == null ? new ArrayList() : pendingList;
    }

    private static class PendingMessageManagerHolder {
        static final PendingMessageRepository INSTANCE = new PendingMessageRepository();

        private PendingMessageManagerHolder() {
        }
    }
}

