/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.fragments;

import android.os.Bundle;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.sendbird.android.SendBird;
import com.sendbird.android.User;
import com.sendbird.uikit.SendBirdUIKit;
import com.sendbird.uikit.dialogs.DialogHelper;
import com.sendbird.uikit.interfaces.DialogProvider;
import com.sendbird.uikit.model.ReadyStatus;
import com.sendbird.uikit.utils.EventProvider;
import com.sendbird.uikit.widgets.WaitingDialog;

abstract class BaseFragment
extends Fragment
implements DialogProvider {
    private final String CONNECTION_HANDLER_ID = this.getClass().getName();

    BaseFragment() {
    }

    public abstract void onReady(User var1, ReadyStatus var2);

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.connect();
    }

    protected boolean isActive() {
        boolean isDeactive = this.isRemoving() || this.isDetached() || this.getContext() == null;
        return !isDeactive;
    }

    protected void connect() {
        SendBirdUIKit.connect((user, e) -> {
            ReadyStatus status = ReadyStatus.PENDING;
            if (e != null) {
                if (SendBird.getCurrentUser() == null) {
                    status = ReadyStatus.ERROR;
                } else {
                    SendBird.addConnectionHandler((String)this.CONNECTION_HANDLER_ID, (SendBird.ConnectionHandler)new SendBird.ConnectionHandler(){

                        public void onReconnectStarted() {
                        }

                        public void onReconnectSucceeded() {
                            if (!BaseFragment.this.isActive()) {
                                return;
                            }
                            BaseFragment.this.onReady(SendBird.getCurrentUser(), ReadyStatus.READY);
                            SendBird.removeConnectionHandler((String)BaseFragment.this.CONNECTION_HANDLER_ID);
                        }

                        public void onReconnectFailed() {
                        }
                    });
                }
            } else {
                status = ReadyStatus.READY;
            }
            if (!this.isActive()) {
                return;
            }
            this.onReady(user, status);
        });
    }

    public void onDestroy() {
        super.onDestroy();
        SendBird.removeConnectionHandler((String)this.CONNECTION_HANDLER_ID);
        EventProvider.getInstance().unRegister(this.getClass());
    }

    @Override
    public void showWaitingDialog() {
        WaitingDialog.show(this.getContext());
    }

    @Override
    public void toastError(int messageRes) {
        DialogHelper.toastError(this.getContext(), messageRes);
    }

    @Override
    public void toastError(@NonNull String message) {
        DialogHelper.toastError(this.getContext(), message);
    }

    @Override
    public void toastSuccess(@NonNull int messageRes) {
        DialogHelper.toastSuccess(this.getContext(), messageRes);
    }
}

