/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.activities.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.databinding.DataBindingUtil;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.RecyclerView;
import com.sendbird.android.Reaction;
import com.sendbird.uikit.R;
import com.sendbird.uikit.SendBirdUIKit;
import com.sendbird.uikit.activities.adapter.BaseAdapter;
import com.sendbird.uikit.activities.adapter.EmojiReactionDiffCallback;
import com.sendbird.uikit.activities.viewholder.BaseViewHolder;
import com.sendbird.uikit.activities.viewholder.EmojiReactionMoreViewHolder;
import com.sendbird.uikit.activities.viewholder.EmojiReactionViewHolder;
import com.sendbird.uikit.databinding.SbViewEmojiReactionBinding;
import com.sendbird.uikit.interfaces.OnItemClickListener;
import com.sendbird.uikit.interfaces.OnItemLongClickListener;
import com.sendbird.uikit.model.EmojiManager;
import com.sendbird.uikit.widgets.EmojiReactionView;
import java.util.ArrayList;
import java.util.List;

public class EmojiReactionListAdapter
extends BaseAdapter<Reaction, BaseViewHolder<Reaction>> {
    private static final int VIEW_EMOJI_REACTION = 0;
    private static final int VIEW_EMOJI_REACTION_MORE = 1;
    private List<Reaction> reactionList = new ArrayList<Reaction>();
    private OnItemClickListener<String> emojiReactionClickListener;
    private OnItemLongClickListener<String> emojiReactionLongClickListener;
    private View.OnClickListener moreButtonClickListener;

    @NonNull
    public BaseViewHolder<Reaction> onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        LayoutInflater inflater = LayoutInflater.from((Context)parent.getContext());
        if (viewType == 0) {
            return new EmojiReactionViewHolder((SbViewEmojiReactionBinding)DataBindingUtil.inflate((LayoutInflater)inflater, (int)R.layout.sb_view_emoji_reaction, (ViewGroup)parent, (boolean)false));
        }
        return new EmojiReactionMoreViewHolder(new EmojiReactionView(parent.getContext()));
    }

    public void onBindViewHolder(@NonNull BaseViewHolder<Reaction> holder, int position) {
        int type = this.getItemViewType(position);
        if (type == 1) {
            holder.itemView.setOnClickListener(v -> {
                int reactionPosition = holder.getAdapterPosition();
                if (reactionPosition != -1 && this.moreButtonClickListener != null) {
                    this.moreButtonClickListener.onClick(v);
                }
            });
        } else {
            Reaction current = this.getItem(position);
            if (current != null) {
                List userIds = current.getUserIds();
                if (userIds != null && userIds.contains(SendBirdUIKit.getAdapter().getUserInfo().getUserId())) {
                    holder.itemView.setSelected(true);
                } else {
                    holder.itemView.setSelected(false);
                }
            }
            holder.itemView.setOnClickListener(v -> {
                int reactionPosition = holder.getAdapterPosition();
                if (reactionPosition != -1 && this.emojiReactionClickListener != null) {
                    this.emojiReactionClickListener.onItemClick(v, reactionPosition, this.getItem(reactionPosition) != null ? this.getItem(reactionPosition).getKey() : "");
                }
            });
            holder.itemView.setOnLongClickListener(v -> {
                int reactionPosition = holder.getAdapterPosition();
                if (reactionPosition != -1 && this.emojiReactionLongClickListener != null) {
                    this.emojiReactionLongClickListener.onItemLongClick(v, reactionPosition, this.getItem(reactionPosition) != null ? this.getItem(reactionPosition).getKey() : "");
                    return true;
                }
                return false;
            });
            holder.bind(current);
        }
    }

    public int getItemCount() {
        if (this.reactionList == null) {
            return 0;
        }
        if (this.reactionList.size() >= EmojiManager.getInstance().getAllEmojis().size()) {
            return this.reactionList.size();
        }
        return this.reactionList.size() + 1;
    }

    @Override
    public Reaction getItem(int position) {
        if (this.reactionList == null || position >= this.reactionList.size()) {
            return null;
        }
        return this.reactionList.get(position);
    }

    @Override
    public List<Reaction> getItems() {
        return this.reactionList;
    }

    public int getItemViewType(int position) {
        if (this.reactionList == null || position >= this.reactionList.size()) {
            return 1;
        }
        return 0;
    }

    public void setReactionList(List<Reaction> reactionList) {
        EmojiReactionDiffCallback diffCallback = new EmojiReactionDiffCallback(this.reactionList, reactionList);
        DiffUtil.DiffResult diffResult = DiffUtil.calculateDiff((DiffUtil.Callback)diffCallback);
        this.reactionList.clear();
        this.reactionList.addAll(reactionList);
        diffResult.dispatchUpdatesTo((RecyclerView.Adapter)this);
    }

    public void setEmojiReactionClickListener(@Nullable OnItemClickListener<String> emojiReactionClickListener) {
        this.emojiReactionClickListener = emojiReactionClickListener;
    }

    public void setEmojiReactionLongClickListener(@Nullable OnItemLongClickListener<String> emojiReactionLongClickListener) {
        this.emojiReactionLongClickListener = emojiReactionLongClickListener;
    }

    public void setMoreButtonClickListener(@Nullable View.OnClickListener moreButtonClickListener) {
        this.moreButtonClickListener = moreButtonClickListener;
    }
}

