/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.activities.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.RecyclerView;
import com.sendbird.android.BaseChannel;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.FileMessage;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.UserMessage;
import com.sendbird.uikit.activities.adapter.BaseMessageAdapter;
import com.sendbird.uikit.activities.adapter.MessageDiffCallback;
import com.sendbird.uikit.activities.viewholder.MessageType;
import com.sendbird.uikit.activities.viewholder.MessageViewHolder;
import com.sendbird.uikit.activities.viewholder.MessageViewHolderFactory;
import com.sendbird.uikit.interfaces.OnItemClickListener;
import com.sendbird.uikit.interfaces.OnItemLongClickListener;
import com.sendbird.uikit.utils.TextUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MessageListAdapter
extends BaseMessageAdapter<BaseMessage, MessageViewHolder> {
    private List<BaseMessage> messageList = new ArrayList<BaseMessage>();
    private GroupChannel channel;
    private OnItemClickListener<BaseMessage> listener;
    private OnItemLongClickListener<BaseMessage> longClickListener;

    public MessageListAdapter(GroupChannel channel) {
        this(channel, null, null);
    }

    public MessageListAdapter(GroupChannel channel, OnItemClickListener<BaseMessage> listener) {
        this(channel, listener, null);
    }

    public MessageListAdapter(GroupChannel channel, OnItemClickListener<BaseMessage> listener, OnItemLongClickListener<BaseMessage> longClickListener) {
        this.channel = channel;
        this.listener = listener;
        this.longClickListener = longClickListener;
        this.setHasStableIds(true);
    }

    @NonNull
    public MessageViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        LayoutInflater inflater = LayoutInflater.from((Context)parent.getContext());
        return MessageViewHolderFactory.createViewHolder(inflater, parent, MessageType.from(viewType));
    }

    public void onBindViewHolder(@NonNull MessageViewHolder holder, int position) {
        BaseMessage prev = null;
        BaseMessage next = null;
        BaseMessage current = this.getItem(position);
        int itemCount = this.getItemCount();
        if (position < itemCount - 1) {
            prev = this.getItem(position + 1);
        }
        if (position > 0) {
            next = this.getItem(position - 1);
        }
        if (current instanceof UserMessage || current instanceof FileMessage) {
            holder.getClickableView().setOnClickListener(v -> {
                if (this.listener != null) {
                    this.listener.onItemClick(v, position, current);
                }
            });
            holder.getClickableView().setOnLongClickListener(v -> {
                if (this.longClickListener != null) {
                    this.longClickListener.onItemLongClick(v, position, current);
                }
                return false;
            });
        }
        holder.onBindViewHolder((BaseChannel)this.channel, prev, current, next);
    }

    public int getItemViewType(int position) {
        BaseMessage message = this.getItem(position);
        return MessageViewHolderFactory.getViewType(message);
    }

    @Override
    public long getItemId(int position) {
        BaseMessage item = this.getItem(position);
        if (TextUtils.isEmpty(item.getRequestId())) {
            return item.getMessageId();
        }
        try {
            return Long.parseLong(item.getRequestId());
        }
        catch (Exception e) {
            return item.getMessageId();
        }
    }

    public void setChannel(@NonNull GroupChannel channel) {
        this.channel = GroupChannel.clone((GroupChannel)channel);
    }

    public void setItems(GroupChannel channel, List<BaseMessage> messageList) {
        MessageDiffCallback diffCallback = new MessageDiffCallback(this.channel, channel, this.messageList, messageList);
        DiffUtil.DiffResult diffResult = DiffUtil.calculateDiff((DiffUtil.Callback)diffCallback);
        this.messageList.clear();
        this.messageList.addAll(messageList);
        this.channel = GroupChannel.clone((GroupChannel)channel);
        diffResult.dispatchUpdatesTo((RecyclerView.Adapter)this);
    }

    public void setOnItemClickListener(@Nullable OnItemClickListener<BaseMessage> listener) {
        this.listener = listener;
    }

    public void setOnItemLongClickListener(@Nullable OnItemLongClickListener<BaseMessage> listener) {
        this.longClickListener = listener;
    }

    public int getItemCount() {
        return this.messageList == null ? 0 : this.messageList.size();
    }

    @Override
    public BaseMessage getItem(int position) {
        return this.messageList.get(position);
    }

    @Override
    public List<BaseMessage> getItems() {
        return this.messageList != null ? Collections.unmodifiableList(this.messageList) : null;
    }
}

