/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.activities;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import com.sendbird.android.FileMessage;
import com.sendbird.uikit.R;
import com.sendbird.uikit.SendBirdUIKit;
import com.sendbird.uikit.fragments.PhotoViewFragment;

public class PhotoViewActivity
extends AppCompatActivity {
    public static Intent newIntent(@NonNull Context context, @NonNull FileMessage message) {
        Intent intent = new Intent(context, PhotoViewActivity.class);
        intent.putExtra("KEY_MESSAGE_ID", message.getMessageId());
        intent.putExtra("KEY_MESSAGE_FILENAME", message.getName());
        intent.putExtra("KEY_CHANNEL_URL", message.getChannelUrl());
        intent.putExtra("KEY_IMAGE_URL", message.getUrl());
        intent.putExtra("KEY_MESSAGE_MIMETYPE", message.getType());
        intent.putExtra("KEY_MESSAGE_CREATEDAT", message.getCreatedAt());
        intent.putExtra("KEY_SENDER_ID", message.getSender().getUserId());
        intent.putExtra("KEY_MESSAGE_SENDER_NAME", message.getSender().getNickname());
        return intent;
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setTheme(SendBirdUIKit.isDarkMode() ? R.style.SendBird_Dark : R.style.SendBird);
        this.setContentView(R.layout.sb_activity);
        Intent intent = this.getIntent();
        long messageId = intent.getLongExtra("KEY_MESSAGE_ID", 0L);
        String senderId = intent.getStringExtra("KEY_SENDER_ID");
        String channelUrl = intent.getStringExtra("KEY_CHANNEL_URL");
        String fileName = intent.getStringExtra("KEY_MESSAGE_FILENAME");
        String url = intent.getStringExtra("KEY_IMAGE_URL");
        String mimeType = intent.getStringExtra("KEY_MESSAGE_MIMETYPE");
        String senderNickname = intent.getStringExtra("KEY_MESSAGE_SENDER_NAME");
        long createdAt = intent.getLongExtra("KEY_MESSAGE_CREATEDAT", 0L);
        PhotoViewFragment fragment = new PhotoViewFragment.Builder(senderId, fileName, channelUrl, url, mimeType, senderNickname, createdAt, messageId, SendBirdUIKit.getDefaultThemeMode()).build();
        FragmentManager manager = this.getSupportFragmentManager();
        manager.popBackStack();
        manager.beginTransaction().replace(R.id.sb_fragment_container, (Fragment)fragment).commit();
    }
}

