/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.activities;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import com.sendbird.android.SendBird;
import com.sendbird.uikit.R;
import com.sendbird.uikit.SendBirdUIKit;
import com.sendbird.uikit.activities.ChannelActivity;
import com.sendbird.uikit.fragments.ChannelListFragment;

public class ChannelListActivity
extends AppCompatActivity {
    public static Intent newIntent(@NonNull Context context) {
        return new Intent(context, ChannelListActivity.class);
    }

    public static Intent newRedirectToChannelIntent(@NonNull Context context, @NonNull String channelUrl) {
        Intent intent = new Intent(context, ChannelListActivity.class);
        intent.putExtra("KEY_CHANNEL_URL", channelUrl);
        return intent;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setTheme(SendBirdUIKit.isDarkMode() ? R.style.SendBird_Dark : R.style.SendBird);
        this.setContentView(R.layout.sb_activity);
        ChannelListFragment fragment = this.createChannelListFragment();
        FragmentManager manager = this.getSupportFragmentManager();
        manager.popBackStack();
        manager.beginTransaction().replace(R.id.sb_fragment_container, (Fragment)fragment).commit();
        this.redirectChannelIfNeeded(this.getIntent());
    }

    protected ChannelListFragment createChannelListFragment() {
        return new ChannelListFragment.Builder().setUseHeader(true).build();
    }

    protected Intent createRedirectChannelActivityIntent(@NonNull String channelUrl) {
        return ChannelActivity.newIntent((Context)this, channelUrl);
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        this.redirectChannelIfNeeded(intent);
    }

    private void redirectChannelIfNeeded(Intent intent) {
        if (intent == null) {
            return;
        }
        if (SendBird.getCurrentUser() == null) {
            return;
        }
        if ((intent.getFlags() & 0x100000) == 0x100000) {
            this.getIntent().removeExtra("KEY_CHANNEL_URL");
        }
        if (intent.hasExtra("KEY_CHANNEL_URL")) {
            String channelUrl = intent.getStringExtra("KEY_CHANNEL_URL");
            this.startActivity(this.createRedirectChannelActivityIntent(channelUrl));
            intent.removeExtra("KEY_CHANNEL_URL");
        }
    }
}

