/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.widgets;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.databinding.DataBindingUtil;
import com.sendbird.uikit.R;
import com.sendbird.uikit.SendBirdUIKit;
import com.sendbird.uikit.databinding.SbViewChannelSettingsBinding;
import com.sendbird.uikit.utils.DrawableUtils;

public class ChannelSettingsView
extends FrameLayout {
    private SbViewChannelSettingsBinding binding;

    public ChannelSettingsView(@NonNull Context context) {
        this(context, null);
    }

    public ChannelSettingsView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.sb_channel_settings_style);
    }

    public ChannelSettingsView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs, int defStyle) {
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.ChannelSettings, defStyle, 0);
        try {
            this.binding = (SbViewChannelSettingsBinding)DataBindingUtil.inflate((LayoutInflater)LayoutInflater.from((Context)this.getContext()), (int)R.layout.sb_view_channel_settings, (ViewGroup)this, (boolean)true);
            int background = a.getResourceId(R.styleable.ChannelSettings_sb_channel_settings_background, R.color.background_100);
            int itemBackground = a.getResourceId(R.styleable.ChannelSettings_sb_channel_settings_item_background, R.drawable.selector_rectangle_light);
            int nameAppearance = a.getResourceId(R.styleable.ChannelSettings_sb_channel_settings_name_appearance, R.style.SendbirdSubtitle1OnLight01);
            int itemAppearance = a.getResourceId(R.styleable.ChannelSettings_sb_channel_settings_name_appearance, R.style.SendbirdSubtitle2OnLight01);
            boolean useDarkTheme = SendBirdUIKit.isDarkMode();
            int nextTint = useDarkTheme ? R.color.ondark_01 : R.color.onlight_01;
            int switchTrackTint = useDarkTheme ? R.color.sb_switch_track_dark : R.color.sb_switch_track_light;
            int switchThumbTint = useDarkTheme ? R.color.sb_switch_thumb_dark : R.color.sb_switch_thumb_light;
            int divider = useDarkTheme ? R.drawable.sb_line_divider_dark : R.drawable.sb_line_divider_light;
            int iconTint = useDarkTheme ? R.color.primary_200 : R.color.primary_300;
            this.setBackgroundResource(background);
            this.binding.ivNotiIcon.setImageDrawable(DrawableUtils.setTintList(this.binding.ivNotiIcon.getDrawable(), context.getResources().getColorStateList(iconTint)));
            this.binding.ivMembersIcon.setImageDrawable(DrawableUtils.setTintList(this.binding.ivMembersIcon.getDrawable(), context.getResources().getColorStateList(iconTint)));
            this.binding.ivNext.setImageDrawable(DrawableUtils.setTintList(this.binding.ivNext.getDrawable(), context.getResources().getColorStateList(nextTint)));
            this.binding.scSwitch.setTrackTintList(context.getResources().getColorStateList(switchTrackTint));
            this.binding.scSwitch.setThumbTintList(context.getResources().getColorStateList(switchThumbTint));
            this.binding.notiItem.setBackgroundResource(itemBackground);
            this.binding.membersItem.setBackgroundResource(itemBackground);
            this.binding.leaveItem.setBackgroundResource(itemBackground);
            this.binding.tvNotiName.setTextAppearance(context, itemAppearance);
            this.binding.tvMembersName.setTextAppearance(context, itemAppearance);
            this.binding.tvLeaveName.setTextAppearance(context, itemAppearance);
            this.binding.tvChannelName.setTextAppearance(context, nameAppearance);
            this.binding.divider1.setBackgroundResource(divider);
            this.binding.divider2.setBackgroundResource(divider);
            this.binding.divider3.setBackgroundResource(divider);
            this.binding.divider4.setBackgroundResource(divider);
        }
        finally {
            a.recycle();
        }
    }

    public ChannelSettingsView getLayout() {
        return this;
    }

    public SbViewChannelSettingsBinding getBinding() {
        return this.binding;
    }
}

