/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.widgets;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.TextView;
import androidx.databinding.DataBindingUtil;
import com.sendbird.uikit.R;
import com.sendbird.uikit.databinding.SbViewAppBarBinding;
import com.sendbird.uikit.utils.DrawableUtils;
import com.sendbird.uikit.widgets.ChannelCoverView;

public class AppBarView
extends FrameLayout {
    private SbViewAppBarBinding binding;

    public AppBarView(Context context) {
        this(context, null);
    }

    public AppBarView(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.sb_appbar_style);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AppBarView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.AppBarView, defStyleAttr, 0);
        try {
            this.binding = (SbViewAppBarBinding)DataBindingUtil.inflate((LayoutInflater)LayoutInflater.from((Context)this.getContext()), (int)R.layout.sb_view_app_bar, (ViewGroup)this, (boolean)true);
            String titleText = a.getString(R.styleable.AppBarView_sb_appbar_title);
            int titleTextAppearance = a.getResourceId(R.styleable.AppBarView_sb_appbar_title_appearance, R.style.SendbirdH2OnLight01);
            String descText = a.getString(R.styleable.AppBarView_sb_appbar_description);
            int descTextAppearance = a.getResourceId(R.styleable.AppBarView_sb_appbar_description_appearance, R.style.SendbirdCaption2OnLight02);
            String leftButtonText = a.getString(R.styleable.AppBarView_sb_appbar_left_button_text);
            int leftButtonIconRedId = a.getResourceId(R.styleable.AppBarView_sb_appbar_left_button_icon, 0);
            String rightButtonText = a.getString(R.styleable.AppBarView_sb_appbar_right_button_text);
            int rightButtonIconRedId = a.getResourceId(R.styleable.AppBarView_sb_appbar_right_button_icon, 0);
            ColorStateList buttonTint = a.getColorStateList(R.styleable.AppBarView_sb_appbar_button_tint);
            int dividerColorId = a.getResourceId(R.styleable.AppBarView_sb_appbar_divider_color, R.color.onlight_04);
            this.binding.tvAppBarTitle.setText((CharSequence)titleText);
            this.binding.tvAppBarTitle.setTextAppearance(context, titleTextAppearance);
            if (!TextUtils.isEmpty((CharSequence)descText)) {
                this.binding.tvAppBarDesc.setText((CharSequence)descText);
                this.binding.tvAppBarDesc.setTextAppearance(context, descTextAppearance);
            } else {
                this.binding.tvAppBarDesc.setVisibility(8);
            }
            if (!TextUtils.isEmpty((CharSequence)leftButtonText)) {
                this.binding.ibtnLeft.setVisibility(8);
                this.binding.btnLeft.setText((CharSequence)leftButtonText);
            } else if (leftButtonIconRedId != 0) {
                this.binding.btnLeft.setVisibility(8);
                this.binding.ibtnLeft.setImageDrawable(DrawableUtils.setTintList(context, leftButtonIconRedId, buttonTint));
            }
            if (!TextUtils.isEmpty((CharSequence)rightButtonText)) {
                this.binding.ibtnRight.setVisibility(8);
                this.binding.btnRight.setText((CharSequence)rightButtonText);
            } else if (rightButtonIconRedId != 0) {
                this.binding.btnRight.setVisibility(8);
                this.binding.ibtnRight.setImageDrawable(DrawableUtils.setTintList(context, rightButtonIconRedId, buttonTint));
            }
            this.binding.elevationView.setBackgroundResource(dividerColorId);
        }
        finally {
            a.recycle();
        }
    }

    public TextView getTitleTextView() {
        return this.binding.tvAppBarTitle;
    }

    public TextView getDescriptionTextView() {
        return this.binding.tvAppBarDesc;
    }

    public ImageButton getLeftImageButton() {
        return this.binding.ibtnLeft;
    }

    public TextView getRightTextButton() {
        return this.binding.btnRight;
    }

    public ImageButton getRightImageButton() {
        return this.binding.ibtnRight;
    }

    public ChannelCoverView getProfileView() {
        return this.binding.ccvProfileView;
    }
}

