/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.fragments;

import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import androidx.databinding.DataBindingUtil;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.GroupChannelParams;
import com.sendbird.android.SendBird;
import com.sendbird.android.User;
import com.sendbird.uikit.R;
import com.sendbird.uikit.SendBirdUIKit;
import com.sendbird.uikit.activities.MemberListActivity;
import com.sendbird.uikit.databinding.SbFragmentChannelSettingsBinding;
import com.sendbird.uikit.databinding.SbViewChannelSettingsBinding;
import com.sendbird.uikit.dialogs.DialogHelper;
import com.sendbird.uikit.fragments.PermissionFragment;
import com.sendbird.uikit.log.Logger;
import com.sendbird.uikit.model.ReadyStatus;
import com.sendbird.uikit.utils.ChannelUtils;
import com.sendbird.uikit.utils.EventProvider;
import com.sendbird.uikit.utils.FileUtils;
import com.sendbird.uikit.utils.IntentUtils;
import java.io.File;

public class ChannelSettingsFragment
extends PermissionFragment
implements PermissionFragment.IPermissionHandler {
    private static final int CAPTURE_IMAGE_PERMISSIONS_REQUEST_CODE = 2001;
    private static final int PICK_IMAGE_PERMISSIONS_REQUEST_CODE = 2002;
    private final String[] REQUIRED_PERMISSIONS = new String[]{"android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.CAMERA"};
    private SbFragmentChannelSettingsBinding binding;
    private SbViewChannelSettingsBinding channelSettingsBinding;
    private GroupChannel groupChannel;
    private Uri mediaUri;
    private View.OnClickListener headerLeftButtonListener;

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Logger.i(">> ChannelSettingsFragment::onCreate()", new Object[0]);
        Bundle args = this.getArguments();
        int themeResId = SendBirdUIKit.getDefaultThemeMode().getResId();
        if (args != null) {
            themeResId = args.getInt("KEY_THEME_RES_ID");
        }
        if (this.getActivity() != null) {
            this.getActivity().setTheme(themeResId);
        }
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.binding = (SbFragmentChannelSettingsBinding)DataBindingUtil.inflate((LayoutInflater)inflater, (int)R.layout.sb_fragment_channel_settings, (ViewGroup)container, (boolean)false);
        return this.binding.getRoot();
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.initHeaderOnCreated();
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        SendBird.setAutoBackgroundDetection((boolean)true);
    }

    @Override
    public String[] getPermissions(int requestCode) {
        return this.REQUIRED_PERMISSIONS;
    }

    @Override
    public void onPermissionGranted(int requestCode) {
        this.showMediaSelectDialog();
    }

    private void initPage() {
        this.initHeaderOnReady();
        this.initChannelSetting();
    }

    private void initHeaderOnCreated() {
        Bundle args = this.getArguments();
        String headerTitle = this.getString(R.string.sb_text_header_channel_settings);
        boolean useHeader = false;
        boolean useHeaderLeftButton = true;
        int headerLeftButtonIconResId = R.drawable.icon_arrow_left;
        if (args != null) {
            headerTitle = args.getString("KEY_HEADER_TITLE", this.getString(R.string.sb_text_header_channel_settings));
            useHeader = args.getBoolean("KEY_USE_HEADER", false);
            useHeaderLeftButton = args.getBoolean("KEY_USE_HEADER_LEFT_BUTTON", true);
            headerLeftButtonIconResId = args.getInt("KEY_HEADER_LEFT_BUTTON_ICON_RES_ID", R.drawable.icon_arrow_left);
        }
        this.binding.abSettingsHeader.setVisibility(useHeader ? 0 : 8);
        this.binding.abSettingsHeader.getTitleTextView().setText((CharSequence)headerTitle);
        this.binding.abSettingsHeader.getLeftImageButton().setVisibility(useHeaderLeftButton ? 0 : 8);
        this.binding.abSettingsHeader.getLeftImageButton().setImageResource(headerLeftButtonIconResId);
        this.binding.abSettingsHeader.getLeftImageButton().setOnClickListener(v -> this.finish());
    }

    private void initHeaderOnReady() {
        if (this.headerLeftButtonListener != null) {
            this.binding.abSettingsHeader.getLeftImageButton().setOnClickListener(this.headerLeftButtonListener);
        }
        this.binding.abSettingsHeader.getRightTextButton().setOnClickListener(v -> {
            DialogHelper.DialogListItem[] items = new DialogHelper.DialogListItem[]{new DialogHelper.DialogListItem(R.string.sb_text_channel_settings_change_channel_name), new DialogHelper.DialogListItem(R.string.sb_text_channel_settings_change_channel_image)};
            DialogHelper.showBottomList(this.getContext(), items, key -> {
                if (key == R.string.sb_text_channel_settings_change_channel_name) {
                    Logger.dev("change channel name");
                    DialogHelper.OnEditTextResultListener listener = res -> {
                        GroupChannelParams params = new GroupChannelParams().setName(res);
                        this.groupChannel.updateChannel(params, (updatedChannel, e) -> {
                            if (e != null) {
                                Logger.e((Throwable)e);
                                this.toastError(R.string.sb_text_error_update_channel);
                                return;
                            }
                            Logger.i("++ updated channel name : %s", updatedChannel.getName());
                            if (this.isActive()) {
                                this.channelSettingsBinding.tvChannelName.setText((CharSequence)ChannelUtils.makeTitleText(this.getContext(), updatedChannel));
                            }
                        });
                    };
                    DialogHelper.showEditText(this.getContext(), R.string.sb_text_channel_settings_change_channel_name, R.string.sb_text_channel_settings_change_channel_name_hint, R.string.sb_text_button_cancel, v1 -> {}, R.string.sb_text_button_save, listener);
                } else if (key == R.string.sb_text_channel_settings_change_channel_image) {
                    Logger.dev("change channel image");
                    this.checkPermission(2002, this);
                }
            });
        });
    }

    private void initChannelSetting() {
        this.channelSettingsBinding = this.binding.csvSettings.getBinding();
        this.channelSettingsBinding.tvChannelName.setText((CharSequence)ChannelUtils.makeTitleText(this.getContext(), this.groupChannel));
        ChannelUtils.loadChannelCover(this.channelSettingsBinding.ccvChannelImage, this.groupChannel);
        this.channelSettingsBinding.tvMembersName.setText((CharSequence)String.format(this.getString(R.string.sb_text_channel_settings_members), this.groupChannel.getMemberCount()));
        GroupChannel.PushTriggerOption pushTriggerOption = this.groupChannel.getMyPushTriggerOption();
        if (pushTriggerOption == GroupChannel.PushTriggerOption.OFF) {
            this.channelSettingsBinding.scSwitch.setChecked(false);
        } else {
            this.channelSettingsBinding.scSwitch.setChecked(true);
        }
        this.channelSettingsBinding.notiItem.setOnClickListener(v -> {
            this.channelSettingsBinding.scSwitch.toggle();
            this.channelSettingsBinding.scSwitch.callOnClick();
        });
        this.channelSettingsBinding.scSwitch.setOnClickListener(v -> {
            Logger.dev("toggle push notification");
            GroupChannel.PushTriggerOption option = this.channelSettingsBinding.scSwitch.isChecked() ? GroupChannel.PushTriggerOption.ALL : GroupChannel.PushTriggerOption.OFF;
            this.groupChannel.setMyPushTriggerOption(option, e -> {
                if (e != null) {
                    Logger.e((Throwable)e);
                    this.channelSettingsBinding.scSwitch.toggle();
                    if (option == GroupChannel.PushTriggerOption.ALL) {
                        this.toastError(R.string.sb_text_error_push_notification_on);
                    } else {
                        this.toastError(R.string.sb_text_error_push_notification_off);
                    }
                }
                Logger.i("++ push notifications : %s", option);
            });
        });
        this.channelSettingsBinding.membersItem.setOnClickListener(v -> {
            Logger.dev("members");
            Logger.i("++ members", new Object[0]);
            this.startActivity(MemberListActivity.newIntent(this.getContext(), this.groupChannel.getUrl()));
        });
        this.channelSettingsBinding.leaveItem.setOnClickListener(v -> {
            Logger.dev("leave channel");
            this.groupChannel.leave(e -> {
                if (e != null) {
                    Logger.e((Throwable)e);
                    this.toastError(R.string.sb_text_error_leave_channel);
                    return;
                }
                Logger.i("++ leave channel", new Object[0]);
                EventProvider.getInstance().notify("EVENT_CHANNEL_DELETED", this.groupChannel.getUrl());
                this.finish();
            });
        });
    }

    private void showMediaSelectDialog() {
        DialogHelper.DialogListItem[] items = new DialogHelper.DialogListItem[]{new DialogHelper.DialogListItem(R.string.sb_text_channel_settings_change_channel_image_camera), new DialogHelper.DialogListItem(R.string.sb_text_channel_settings_change_channel_image_gallery)};
        DialogHelper.showList(this.getContext(), R.string.sb_text_channel_settings_change_channel_image, items, key -> {
            try {
                SendBird.setAutoBackgroundDetection((boolean)false);
                if (key == R.string.sb_text_channel_settings_change_channel_image_camera) {
                    this.takeCamera();
                } else if (key == R.string.sb_text_channel_settings_change_channel_image_gallery) {
                    this.pickImage();
                }
            }
            catch (Exception e) {
                Logger.e(e);
                this.toastError(R.string.sb_text_error_open_camera);
            }
        });
    }

    private void takeCamera() {
        this.mediaUri = FileUtils.createPictureImageUri(this.getContext());
        Intent intent = IntentUtils.getCameraIntent(this.getContext(), this.mediaUri);
        if (IntentUtils.hasIntent(this.getContext(), intent)) {
            this.startActivityForResult(intent, 2001);
        }
    }

    private void pickImage() {
        Intent intent = IntentUtils.getGalleryIntent();
        this.startActivityForResult(intent, 2002);
    }

    private void finish() {
        if (this.isActive() && this.getActivity() != null) {
            this.getActivity().finish();
        }
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        SendBird.setAutoBackgroundDetection((boolean)true);
        if (resultCode == -1) {
            switch (requestCode) {
                case 2001: {
                    break;
                }
                case 2002: {
                    this.mediaUri = data.getData();
                }
            }
            if (this.mediaUri != null && this.groupChannel != null) {
                File file = FileUtils.uriToFile(this.getContext().getApplicationContext(), this.mediaUri);
                GroupChannelParams params = new GroupChannelParams().setCoverImage(file);
                this.toastSuccess(R.string.sb_text_toast_success_start_upload_file);
                this.groupChannel.updateChannel(params, (channel, e) -> {
                    if (e != null) {
                        Logger.e((Throwable)e);
                        this.toastError(R.string.sb_text_error_update_channel);
                        return;
                    }
                    Logger.i("++ updated channel cover url : %s", channel.getCoverUrl());
                    if (this.isActive() && this.getActivity() != null) {
                        ChannelUtils.loadChannelCover(this.channelSettingsBinding.ccvChannelImage, channel);
                    }
                });
            }
        }
    }

    @Override
    public void onReady(User user, ReadyStatus status) {
        Logger.i(">> ChannelSettingsFragment::onReady()", new Object[0]);
        Bundle args = this.getArguments();
        String channelUrl = null;
        if (args != null) {
            channelUrl = args.getString("KEY_CHANNEL_URL");
        }
        if (channelUrl == null) {
            this.toastError(R.string.sb_text_error_get_channel);
        } else {
            GroupChannel.getChannel((String)channelUrl, (channel, e) -> {
                if (e != null) {
                    this.toastError(R.string.sb_text_error_get_channel);
                    Logger.e((Throwable)e);
                    return;
                }
                if (this.isActive()) {
                    this.groupChannel = channel;
                    this.initPage();
                }
            });
        }
    }

    private void setHeaderLeftButtonListener(View.OnClickListener listener) {
        this.headerLeftButtonListener = listener;
    }

    public static class Builder {
        private Bundle bundle = new Bundle();
        private View.OnClickListener headerLeftButtonListener;

        public Builder(@NonNull String channelUrl) {
            this(channelUrl, SendBirdUIKit.getDefaultThemeMode());
        }

        public Builder(@NonNull String channelUrl, SendBirdUIKit.ThemeMode themeMode) {
            this.bundle.putInt("KEY_THEME_RES_ID", themeMode.getResId());
            this.bundle.putString("KEY_CHANNEL_URL", channelUrl);
        }

        public Builder(@NonNull String channelUrl, @StyleRes int customThemeResId) {
            this.bundle.putInt("KEY_THEME_RES_ID", customThemeResId);
            this.bundle.putString("KEY_CHANNEL_URL", channelUrl);
        }

        public Builder setHeaderTitle(String title) {
            this.bundle.putString("KEY_HEADER_TITLE", title);
            return this;
        }

        public Builder setUseHeader(boolean useHeader) {
            this.bundle.putBoolean("KEY_USE_HEADER", useHeader);
            return this;
        }

        public Builder setUseHeaderLeftButton(boolean useHeaderLeftButton) {
            this.bundle.putBoolean("KEY_USE_HEADER_LEFT_BUTTON", useHeaderLeftButton);
            return this;
        }

        public Builder setHeaderLeftButtonIconResId(@DrawableRes int resId) {
            this.bundle.putInt("KEY_HEADER_LEFT_BUTTON_ICON_RES_ID", resId);
            return this;
        }

        public Builder setHeaderLeftButtonListener(View.OnClickListener listener) {
            this.headerLeftButtonListener = listener;
            return this;
        }

        public ChannelSettingsFragment build() {
            ChannelSettingsFragment fragment = new ChannelSettingsFragment();
            fragment.setArguments(this.bundle);
            fragment.setHeaderLeftButtonListener(this.headerLeftButtonListener);
            return fragment;
        }
    }
}

