/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.utils;

import android.content.Context;
import androidx.annotation.NonNull;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.FileMessage;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.Member;
import com.sendbird.android.SendBird;
import com.sendbird.android.Sender;
import com.sendbird.uikit.R;
import com.sendbird.uikit.interfaces.UserInfo;
import com.sendbird.uikit.utils.TextUtils;
import com.sendbird.uikit.widgets.ChannelCoverView;
import java.util.ArrayList;
import java.util.List;

public class ChannelUtils {
    public static String makeTitleText(@NonNull Context context, GroupChannel channel) {
        String result;
        String channelName = channel.getName();
        if (!TextUtils.isEmpty(channelName) && !channelName.equals("Group Channel")) {
            return channelName;
        }
        List members = channel.getMembers();
        if (members.size() < 2 || SendBird.getCurrentUser() == null) {
            result = context.getString(R.string.sb_text_channel_list_title_no_members);
        } else if (members.size() == 2) {
            StringBuilder names = new StringBuilder();
            for (Member member : members) {
                if (member.getUserId().equals(SendBird.getCurrentUser().getUserId())) continue;
                String nickName = member.getNickname();
                names.append(", ").append(TextUtils.isEmpty(nickName) ? context.getString(R.string.sb_text_channel_list_title_unknown) : nickName);
            }
            result = names.delete(0, 2).toString();
        } else {
            int count = 0;
            StringBuilder names = new StringBuilder();
            for (Member member : members) {
                if (member.getUserId().equals(SendBird.getCurrentUser().getUserId())) continue;
                String nickName = member.getNickname();
                names.append(", ").append(TextUtils.isEmpty(nickName) ? context.getString(R.string.sb_text_channel_list_title_unknown) : nickName);
                if (++count < 10) continue;
                break;
            }
            result = names.delete(0, 2).toString();
        }
        return result;
    }

    public static String getLastMessage(Context context, GroupChannel channel) {
        BaseMessage lastMessage = channel.getLastMessage();
        if (lastMessage == null) {
            return "";
        }
        if (lastMessage instanceof FileMessage) {
            Sender sender = lastMessage.getSender();
            return String.format(context.getString(R.string.sb_text_channel_list_last_message_file), sender != null ? sender.getNickname() : context.getString(R.string.sb_text_channel_list_last_message_file_unknown));
        }
        return lastMessage.getMessage();
    }

    public static void loadImage(ChannelCoverView coverView, UserInfo user) {
        ArrayList<String> urls = new ArrayList<String>();
        urls.add(user.getProfileUrl());
        coverView.loadImages(urls);
    }

    public static void loadChannelCover(ChannelCoverView coverView, GroupChannel channel) {
        List<String> urls = ChannelUtils.makeProfileUrlsFromChannel(channel);
        coverView.loadImages(urls);
    }

    public static List<String> makeProfileUrlsFromChannel(GroupChannel channel) {
        ArrayList<String> urls = new ArrayList<String>();
        if (!TextUtils.isEmpty(channel.getCoverUrl()) && !channel.getCoverUrl().contains("https://static.sendbird.com/sample/cover/cover_")) {
            urls.add(channel.getCoverUrl());
        } else {
            String myUserId = SendBird.getCurrentUser().getUserId();
            List memberList = channel.getMembers();
            for (int index = 0; index < memberList.size() && urls.size() < 4; ++index) {
                Member member = (Member)memberList.get(index);
                if (member.getUserId().equals(myUserId)) continue;
                urls.add(member.getProfileUrl());
            }
        }
        return urls;
    }

    public static String makeTypingText(Context context, List<Member> typingUsers) {
        if (typingUsers.size() == 1) {
            return String.format(context.getString(R.string.sb_text_channel_typing_indicator_single), typingUsers.get(0).getNickname());
        }
        if (typingUsers.size() == 2) {
            return String.format(context.getString(R.string.sb_text_channel_typing_indicator_double), typingUsers.get(0).getNickname(), typingUsers.get(1).getNickname());
        }
        return context.getString(R.string.sb_text_channel_typing_indicator_multiple);
    }

    public static boolean isChannelPushOff(GroupChannel channel) {
        return channel.getMyPushTriggerOption() == GroupChannel.PushTriggerOption.OFF;
    }
}

