/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.model;

import android.net.Uri;
import com.sendbird.android.FileMessage;
import com.sendbird.android.FileMessageParams;
import com.sendbird.uikit.log.Logger;
import com.sendbird.uikit.utils.TextUtils;
import java.io.File;
import java.util.ArrayList;

public final class FileInfo {
    private final String path;
    private final int size;
    private final String mimeType;
    private final String fileName;
    private final Uri uri;
    private final int thumbnailWidth;
    private final int thumbnailHeight;
    private final String thumbnailPath;

    public FileInfo(String path, int size, String mimeType, String fileName, Uri uri, int thumbnailWidth, int thumbnailHeight, String thumbnailPath) {
        this.path = path;
        this.size = size;
        this.mimeType = mimeType;
        this.fileName = fileName;
        this.uri = uri;
        this.thumbnailWidth = thumbnailWidth;
        this.thumbnailHeight = thumbnailHeight;
        this.thumbnailPath = thumbnailPath;
    }

    public String getPath() {
        return this.path;
    }

    public int getSize() {
        return this.size;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getFileName() {
        return this.fileName;
    }

    public Uri getUri() {
        return this.uri;
    }

    public int getThumbnailWidth() {
        return this.thumbnailWidth;
    }

    public int getThumbnailHeight() {
        return this.thumbnailHeight;
    }

    public String getThumbnailPath() {
        return this.thumbnailPath;
    }

    public File getThumbnailFile() {
        File file = null;
        if (!TextUtils.isEmpty(this.thumbnailPath) && (file = new File(this.thumbnailPath)).exists()) {
            return file;
        }
        return file;
    }

    public File getFile() {
        File file = null;
        if (!TextUtils.isEmpty(this.path) && (file = new File(this.path)).exists() && file.length() > 0L) {
            return file;
        }
        return file;
    }

    public FileMessageParams toFileParams() {
        FileMessageParams params = new FileMessageParams();
        params.setMimeType(this.getMimeType());
        params.setFileName(this.getFileName());
        params.setFileSize(this.getSize());
        File file = this.getFile();
        if (file != null) {
            params.setFile(file);
        }
        int thumbWidth = this.getThumbnailWidth();
        int thumbHeight = this.getThumbnailHeight();
        if (thumbWidth > 0 && thumbHeight > 0) {
            Logger.i("++ image width : %s, image height : %s", thumbWidth, thumbHeight);
            ArrayList<FileMessage.ThumbnailSize> thumbnailSizes = new ArrayList<FileMessage.ThumbnailSize>();
            thumbnailSizes.add(new FileMessage.ThumbnailSize(thumbWidth, thumbHeight));
            thumbnailSizes.add(new FileMessage.ThumbnailSize(thumbWidth / 2, thumbHeight / 2));
            params.setThumbnailSizes(thumbnailSizes);
        }
        return params;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileInfo fileInfo = (FileInfo)o;
        return this.uri.equals((Object)fileInfo.getUri());
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public String toString() {
        return "FileInfo{path='" + this.path + '\'' + ", size=" + this.size + ", mimeType='" + this.mimeType + '\'' + ", fileName='" + this.fileName + '\'' + ", uri=" + this.uri + ", thumbnailWidth=" + this.thumbnailWidth + ", thumbnailHeight=" + this.thumbnailHeight + '}';
    }
}

