/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.widgets;

import android.content.Context;
import android.content.res.TypedArray;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.databinding.BindingAdapter;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.FileMessage;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.UserMessage;
import com.sendbird.uikit.R;
import com.sendbird.uikit.SendBirdUIKit;
import com.sendbird.uikit.utils.ChannelUtils;
import com.sendbird.uikit.utils.DateUtils;
import com.sendbird.uikit.widgets.ChannelCoverView;

public class ChannelPreview
extends FrameLayout {
    private View layout;
    private ChannelCoverView coverView;
    private TextView tvTitle;
    private TextView tvMemberCount;
    private TextView tvUpdatedAt;
    private TextView tvLastMessage;
    private TextView tvUnreadCount;
    private ImageView ivPushEnabled;

    public ChannelPreview(Context context) {
        this(context, null);
    }

    public ChannelPreview(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.sb_channel_preview_style);
    }

    public ChannelPreview(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs, defStyle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs, int defStyle) {
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.ChannelPreview, defStyle, 0);
        try {
            this.layout = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.sb_view_channel_list_item, null);
            this.addView(this.layout, -1, -2);
            this.coverView = (ChannelCoverView)this.layout.findViewById(R.id.ivChannelCover);
            this.tvTitle = (TextView)this.layout.findViewById(R.id.tvTitle);
            this.tvMemberCount = (TextView)this.layout.findViewById(R.id.tvMemberCount);
            this.ivPushEnabled = (ImageView)this.layout.findViewById(R.id.ivPushEnabledIcon);
            this.tvUpdatedAt = (TextView)this.layout.findViewById(R.id.tvUpdatedAt);
            this.tvLastMessage = (TextView)this.layout.findViewById(R.id.tvLastMessage);
            this.tvUnreadCount = (TextView)this.layout.findViewById(R.id.tvUnreadCount);
            int titleAppearance = a.getResourceId(R.styleable.ChannelPreview_sb_channel_preview_title_appearance, R.style.SendbirdSubtitle1OnLight01);
            int memberCountAppearance = a.getResourceId(R.styleable.ChannelPreview_sb_channel_preview_member_count_appearance, R.style.SendbirdCaption1OnLight02);
            int updatedAtAppearance = a.getResourceId(R.styleable.ChannelPreview_sb_channel_preview_updated_at_appearance, R.style.SendbirdCaption2OnLight02);
            int unReadCountAppearance = a.getResourceId(R.styleable.ChannelPreview_sb_channel_preview_unread_count_appearance, R.style.SendbirdCaption1OnDark01);
            int lastMessageAppearance = a.getResourceId(R.styleable.ChannelPreview_sb_channel_preview_last_message_appearance, R.style.SendbirdBody2OnLight03);
            this.tvTitle.setTextAppearance(context, titleAppearance);
            this.tvTitle.setEllipsize(TextUtils.TruncateAt.END);
            this.tvTitle.setMaxLines(1);
            this.tvMemberCount.setTextAppearance(context, memberCountAppearance);
            this.tvUpdatedAt.setTextAppearance(context, updatedAtAppearance);
            this.tvUnreadCount.setTextAppearance(context, unReadCountAppearance);
            this.tvUnreadCount.setMaxLines(1);
            this.tvLastMessage.setTextAppearance(context, lastMessageAppearance);
            this.tvLastMessage.setEllipsize(TextUtils.TruncateAt.END);
            this.tvLastMessage.setMaxLines(2);
        }
        finally {
            a.recycle();
        }
    }

    public void setChannel(GroupChannel channel) {
        ChannelPreview.drawChannel(this, channel);
    }

    @BindingAdapter(value={"bind_channel"})
    public static void drawChannel(ChannelPreview channelPreview, GroupChannel channel) {
        BaseMessage lastMessage = channel.getLastMessage();
        int unreadMessageCount = channel.getUnreadMessageCount();
        boolean useDarkTheme = SendBirdUIKit.getDefaultThemeMode() == SendBirdUIKit.ThemeMode.Dark;
        channelPreview.ivPushEnabled.setVisibility(ChannelUtils.isChannelPushOff(channel) ? 0 : 8);
        channelPreview.ivPushEnabled.setImageResource(useDarkTheme ? R.drawable.icon_mute_dark : R.drawable.icon_mute);
        channelPreview.tvTitle.setText((CharSequence)ChannelUtils.makeTitleText(channel));
        channelPreview.tvUnreadCount.setText((CharSequence)(unreadMessageCount > 99 ? channelPreview.getContext().getString(R.string.sb_text_channel_list_unread_count_max) : String.valueOf(unreadMessageCount)));
        channelPreview.tvUnreadCount.setVisibility(unreadMessageCount > 0 ? 0 : 8);
        channelPreview.tvUnreadCount.setBackgroundResource(useDarkTheme ? R.drawable.sb_shape_unread_message_count_dark : R.drawable.sb_shape_unread_message_count);
        ChannelUtils.loadChannelCover(channelPreview.coverView, channel);
        int memberCount = channel.getMemberCount();
        channelPreview.tvMemberCount.setVisibility(memberCount > 2 ? 0 : 8);
        channelPreview.tvMemberCount.setText((CharSequence)String.valueOf(memberCount));
        channelPreview.tvUpdatedAt.setText((CharSequence)String.valueOf(DateUtils.formatDateTime(channelPreview.getContext(), lastMessage != null ? lastMessage.getCreatedAt() : channel.getCreatedAt())));
        ChannelPreview.setLastMessage(channelPreview.tvLastMessage, channel);
    }

    public View getLayout() {
        return this.layout;
    }

    private static void setLastMessage(TextView textView, GroupChannel channel) {
        String message = "";
        BaseMessage lastMessage = channel.getLastMessage();
        if (lastMessage instanceof UserMessage) {
            textView.setMaxLines(2);
            textView.setEllipsize(TextUtils.TruncateAt.END);
            message = lastMessage.getMessage();
        } else if (lastMessage instanceof FileMessage) {
            textView.setMaxLines(1);
            textView.setEllipsize(TextUtils.TruncateAt.MIDDLE);
            message = ((FileMessage)lastMessage).getName();
        }
        textView.setText((CharSequence)message);
    }
}

