/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.vm;

import androidx.annotation.NonNull;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.OnLifecycleEvent;
import com.sendbird.android.BaseChannel;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.GroupChannelListQuery;
import com.sendbird.android.SendBird;
import com.sendbird.android.SendBirdException;
import com.sendbird.android.User;
import com.sendbird.uikit.R;
import com.sendbird.uikit.interfaces.DialogProvider;
import com.sendbird.uikit.log.Logger;
import com.sendbird.uikit.vm.BaseViewModel;
import com.sendbird.uikit.vm.ChannelChangeLogsPager;
import com.sendbird.uikit.widgets.PagerRecyclerView;
import com.sendbird.uikit.widgets.StatusFrameView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public class ChannelListViewModel
extends BaseViewModel
implements PagerRecyclerView.Pageable,
LifecycleObserver {
    private static final String CONNECTION_HANDLER_ID = "CONNECTION_HANDLER_GROUP_CHANNEL_LIST";
    private static final String CHANNEL_HANDLER_ID = "CHANNEL_HANDLER_GROUP_CHANNEL_LIST";
    private final AtomicLong lastSyncTs = new AtomicLong(0L);
    private final MutableLiveData<List<GroupChannel>> channelList = new MutableLiveData();
    private final GroupChannelListQuery channelListQuery;
    private final Set<GroupChannel> channelListCache = new HashSet<GroupChannel>();
    private final AtomicBoolean hasMore = new AtomicBoolean();
    private final AtomicBoolean isIncludeEmpty = new AtomicBoolean();
    private final MutableLiveData<StatusFrameView.Status> statusFrame = new MutableLiveData();
    private final Comparator<GroupChannel> comparator = new Comparator<GroupChannel>(){

        @Override
        public int compare(GroupChannel groupChannel1, GroupChannel groupChannel2) {
            return GroupChannel.compareTo((GroupChannel)groupChannel1, (GroupChannel)groupChannel2, (GroupChannelListQuery.Order)ChannelListViewModel.this.channelListQuery.getOrder());
        }
    };

    ChannelListViewModel(DialogProvider provider, boolean isIncludeEmpty) {
        super(provider);
        this.channelListQuery = GroupChannel.createMyGroupChannelListQuery();
        this.channelListQuery.setIncludeEmpty(isIncludeEmpty);
        this.channelListQuery.setLimit(20);
        this.isIncludeEmpty.set(isIncludeEmpty);
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_RESUME)
    private void onResume() {
        Logger.d(">> ChannelListViewModel::onResume()");
        SendBird.addConnectionHandler((String)CONNECTION_HANDLER_ID, (SendBird.ConnectionHandler)new SendBird.ConnectionHandler(){

            public void onReconnectStarted() {
            }

            public void onReconnectSucceeded() {
                ChannelListViewModel.this.requestChangeLogs();
            }

            public void onReconnectFailed() {
            }
        });
        SendBird.addChannelHandler((String)CHANNEL_HANDLER_ID, (SendBird.ChannelHandler)new SendBird.ChannelHandler(){

            public void onMessageReceived(BaseChannel channel, BaseMessage message) {
                Logger.d(">> onMessageReceived");
            }

            public void onChannelChanged(BaseChannel channel) {
                Logger.d(">> onChannelChanged");
                ChannelListViewModel.this.updateOrInsert((GroupChannel)channel);
            }

            public void onUserLeft(GroupChannel channel, User user) {
                if (ChannelListViewModel.this.isIncludeEmpty.get()) {
                    ChannelListViewModel.this.updateOrInsert(channel);
                } else {
                    ChannelListViewModel.this.updateIfExist(channel);
                }
            }

            public void onUserJoined(GroupChannel channel, User user) {
                if (ChannelListViewModel.this.isIncludeEmpty.get()) {
                    ChannelListViewModel.this.updateOrInsert(channel);
                } else {
                    ChannelListViewModel.this.updateIfExist(channel);
                }
            }

            public void onChannelDeleted(String channelUrl, BaseChannel.ChannelType channelType) {
                if (channelType == BaseChannel.ChannelType.GROUP) {
                    GroupChannel.getChannel((String)channelUrl, (channel, e) -> {
                        if (e == null || channel != null) {
                            ChannelListViewModel.this.deleteChannel(channel);
                        }
                    });
                }
            }
        });
        this.requestChangeLogs();
        this.markChannelSyncTs();
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_PAUSE)
    private void onPause() {
        Logger.d(">> ChannelListViewModel::onPause()");
        SendBird.removeConnectionHandler((String)CONNECTION_HANDLER_ID);
        SendBird.removeChannelHandler((String)CHANNEL_HANDLER_ID);
    }

    public LiveData<List<GroupChannel>> getChannelList() {
        this.next();
        return this.channelList;
    }

    public MutableLiveData<StatusFrameView.Status> getStatusFrame() {
        return this.statusFrame;
    }

    private void markChannelSyncTs() {
        this.lastSyncTs.set(System.currentTimeMillis() - 60000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateIfExist(@NonNull GroupChannel channel) {
        Logger.d(">> updateIfExist()");
        Set<GroupChannel> set = this.channelListCache;
        synchronized (set) {
            if (this.channelListCache.contains(channel)) {
                this.channelListCache.remove(channel);
                this.channelListCache.add(channel);
                this.applyChannelList();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateOrInsert(@NonNull GroupChannel channel) {
        Logger.d(">> updateOrInsert()");
        Set<GroupChannel> set = this.channelListCache;
        synchronized (set) {
            this.channelListCache.remove(channel);
            this.channelListCache.add(channel);
        }
        this.applyChannelList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deleteChannel(@NonNull GroupChannel deletedChannel) {
        boolean deleted;
        Set<GroupChannel> set = this.channelListCache;
        synchronized (set) {
            deleted = this.channelListCache.remove(deletedChannel);
        }
        if (deleted) {
            this.applyChannelList();
        }
        return deleted;
    }

    private void requestChangeLogs() {
        Logger.d(">> ChannelListViewModel::requestChangeLogs(%s)", this.lastSyncTs.get());
        long lastTs = this.lastSyncTs.get();
        if (lastTs > 0L) {
            ChannelChangeLogsPager pager = new ChannelChangeLogsPager(lastTs, null, this.isIncludeEmpty.get());
            pager.load(new ChannelChangeLogsPager.ChannelChangeLogsResultHandler(){

                @Override
                public void onError(SendBirdException e) {
                    Logger.e(e);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onResult(List<GroupChannel> updatedChannels, List<String> deletedChannelUrls) {
                    Logger.i("updatedChannels size : %s, deletedChannelUrls size : %s", updatedChannels.size(), deletedChannelUrls.size());
                    Set set = ChannelListViewModel.this.channelListCache;
                    synchronized (set) {
                        ChannelListViewModel.this.channelListCache.removeAll(updatedChannels);
                        ChannelListViewModel.this.channelListCache.addAll(updatedChannels);
                        ArrayList<GroupChannel> willDeleteChannel = new ArrayList<GroupChannel>();
                        for (GroupChannel channel : ChannelListViewModel.this.channelListCache) {
                            if (!deletedChannelUrls.contains(channel.getUrl())) continue;
                            willDeleteChannel.add(channel);
                        }
                        ChannelListViewModel.this.channelListCache.removeAll(willDeleteChannel);
                    }
                    ChannelListViewModel.this.markChannelSyncTs();
                    ChannelListViewModel.this.applyChannelList();
                }
            });
        }
    }

    @Override
    public boolean hasMore() {
        return this.hasMore.get();
    }

    @Override
    public void loadMore() {
        this.next();
    }

    private void next() {
        this.channelListQuery.next((list, e) -> {
            boolean hasData;
            boolean bl = hasData = this.channelListCache.size() > 0;
            if (e != null) {
                Logger.e(e);
                this.provider.toastError(R.string.sb_text_error_get_channel_list);
                if (!hasData) {
                    this.changeAlertStatusIfEmpty(StatusFrameView.Status.ERROR);
                }
                this.notifyDataSetChanged((List)this.channelList.getValue());
                return;
            }
            Logger.d("++ list : %s", list);
            this.hasMore.set(!list.isEmpty());
            Set<GroupChannel> set = this.channelListCache;
            synchronized (set) {
                this.channelListCache.addAll(list);
            }
            this.applyChannelList();
        });
    }

    private void changeAlertStatusIfEmpty(StatusFrameView.Status status) {
        if (this.channelListCache.size() <= 0 || status == StatusFrameView.Status.NONE) {
            this.statusFrame.postValue((Object)status);
        }
    }

    private void applyChannelList() {
        ArrayList<GroupChannel> newList = new ArrayList<GroupChannel>(this.channelListCache);
        Collections.sort(newList, this.comparator);
        this.changeAlertStatusIfEmpty(newList.size() == 0 ? StatusFrameView.Status.EMPTY : StatusFrameView.Status.NONE);
        this.notifyDataSetChanged(newList);
    }

    private void notifyDataSetChanged(List<GroupChannel> newList) {
        this.channelList.postValue((Object)(newList == null ? new ArrayList() : newList));
    }

    public void setPushNotification(@NonNull GroupChannel channel, boolean enable) {
        channel.setMyPushTriggerOption(enable ? GroupChannel.PushTriggerOption.ALL : GroupChannel.PushTriggerOption.OFF, new GroupChannel.GroupChannelSetMyPushTriggerOptionHandler(){

            public void onResult(SendBirdException e) {
                Logger.d("++ setPushNotification result : %s", e == null ? "success" : "error");
            }
        });
    }

    public void leaveChannel(@NonNull GroupChannel channel) {
        channel.leave(e -> {
            if (e != null) {
                this.provider.toastError(R.string.sb_text_error_leave_channel);
            }
            if (e == null) {
                this.deleteChannel(channel);
            }
        });
    }
}

