/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.utils;

import android.os.Handler;
import android.os.Looper;
import com.sendbird.uikit.log.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class EventProvider {
    private final Map<String, List<OnEventListener>> subscriber = new ConcurrentHashMap<String, List<OnEventListener>>();
    private final Map<String, Map<String, OnEventListener>> callerMap = new ConcurrentHashMap<String, Map<String, OnEventListener>>();
    private final Handler mainHandler = new Handler(Looper.getMainLooper());

    private EventProvider() {
    }

    public static EventProvider getInstance() {
        return EventBusHolder.instance;
    }

    public <T> void register(Class<?> cls, String[] keys, OnEventListener<T> listener) {
        for (String key : keys) {
            this.register(cls, key, listener);
        }
    }

    public <T> void register(Class<?> cls, String key, OnEventListener<T> listener) {
        Map<String, OnEventListener> map;
        List<OnEventListener> listeners = this.subscriber.get(key);
        if (listeners == null) {
            listeners = new ArrayList<OnEventListener>();
        }
        if ((map = this.callerMap.get(cls.getSimpleName())) == null) {
            map = new ConcurrentHashMap<String, OnEventListener>();
        }
        listeners.add(listener);
        map.put(key, listener);
        this.subscriber.put(key, listeners);
        this.callerMap.put(cls.getSimpleName(), map);
    }

    public void unRegister(Class<?> cls) {
        Map<String, OnEventListener> map = this.callerMap.get(cls.getSimpleName());
        if (map == null) {
            return;
        }
        for (String key : map.keySet()) {
            List<OnEventListener> listeners = this.subscriber.get(key);
            if (listeners == null) continue;
            listeners.remove(map.get(key));
            if (listeners.size() > 0) continue;
            this.subscriber.remove(key);
        }
        this.callerMap.remove(cls.getSimpleName());
    }

    public synchronized void notify(String key) {
        this.notify(key, null);
    }

    public synchronized void notify(String key, long delay) {
        this.notify(key, null, delay);
    }

    public synchronized <T> void notify(String key, T event) {
        this.notify(key, event, 0L);
    }

    public synchronized <T> void notify(String key, T event, long delay) {
        this.mainHandler.postDelayed(() -> {
            List<OnEventListener> listeners;
            if (this.subscriber != null && (listeners = this.subscriber.get(key)) != null) {
                ArrayList<OnEventListener> copy = new ArrayList<OnEventListener>();
                copy.addAll(listeners);
                for (OnEventListener listener : copy) {
                    Logger.d("++ notify : %s", key);
                    listener.onEvent(key, event);
                }
            }
        }, delay);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("KEY : [");
        for (String key : this.subscriber.keySet()) {
            builder.append(key).append(" ");
        }
        builder.append("]");
        return builder.toString();
    }

    private static class EventBusHolder {
        static final EventProvider instance = new EventProvider();

        private EventBusHolder() {
        }
    }

    public static interface OnEventListener<T> {
        public void onEvent(String var1, T var2);
    }
}

