/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.fragments;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import androidx.databinding.DataBindingUtil;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.Member;
import com.sendbird.android.User;
import com.sendbird.uikit.R;
import com.sendbird.uikit.SendBirdUIKit;
import com.sendbird.uikit.activities.InviteChannelActivity;
import com.sendbird.uikit.activities.adapter.UserListAdapter;
import com.sendbird.uikit.databinding.SbFragmentMemberListBinding;
import com.sendbird.uikit.fragments.BaseFragment;
import com.sendbird.uikit.interfaces.CustomUserListQueryHandler;
import com.sendbird.uikit.interfaces.OnItemClickListener;
import com.sendbird.uikit.interfaces.OnItemLongClickListener;
import com.sendbird.uikit.interfaces.UserInfo;
import com.sendbird.uikit.interfaces.UserListResultHandler;
import com.sendbird.uikit.log.Logger;
import com.sendbird.uikit.model.ReadyStatus;
import com.sendbird.uikit.vm.UserListViewModel;
import com.sendbird.uikit.vm.ViewModelFactory;
import java.util.ArrayList;
import java.util.List;

public class MemberListFragment
extends BaseFragment {
    private SbFragmentMemberListBinding binding;
    private UserListViewModel viewModel;
    private View.OnClickListener headerLeftButtonListener;
    private View.OnClickListener headerRightButtonListener;
    private UserListAdapter adapter;
    private OnItemClickListener<UserInfo> itemClickListener;
    private OnItemLongClickListener<UserInfo> itemLongClickListener;

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle args = this.getArguments();
        int themeResId = SendBirdUIKit.getDefaultThemeMode().getResId();
        if (args != null) {
            themeResId = args.getInt("KEY_THEME_RES_ID");
        }
        if (this.getActivity() != null) {
            this.getActivity().setTheme(themeResId);
        }
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.binding = (SbFragmentMemberListBinding)DataBindingUtil.inflate((LayoutInflater)inflater, (int)R.layout.sb_fragment_member_list, (ViewGroup)container, (boolean)false);
        return this.binding.getRoot();
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.initHeaderOnCreated();
    }

    private void initPage(GroupChannel channel) {
        final List members = channel.getMembers();
        final int size = members.size();
        CustomUserListQueryHandler customHandler = new CustomUserListQueryHandler(){
            private int limit = 100;
            private int count = 0;

            @Override
            public void loadInitial(UserListResultHandler handler) {
                Logger.d("__ loadInitial(%s)", this.count);
                this.count = 0;
                this.loadNext(handler);
            }

            @Override
            public void loadNext(UserListResultHandler handler) {
                Logger.d("__ loadNext(%s)", this.count);
                ArrayList<UserInfo> userInfos = new ArrayList<UserInfo>();
                for (int i = 0; i < Math.min(this.limit, size - this.count); ++i) {
                    Member member = (Member)members.get(this.count + i);
                    userInfos.add(MemberListFragment.this.generateUserInfo(member));
                }
                this.count += userInfos.size();
                handler.onResult(userInfos, null);
            }

            @Override
            public boolean hasMore() {
                return this.count < size;
            }
        };
        this.viewModel = (UserListViewModel)new ViewModelProvider((ViewModelStoreOwner)this, (ViewModelProvider.Factory)new ViewModelFactory(this, customHandler)).get(UserListViewModel.class);
        this.initHeaderOnReady(channel);
        this.initMemberList();
    }

    private UserInfo generateUserInfo(final @NonNull Member member) {
        return new UserInfo(){

            @Override
            public String getUserId() {
                return member.getUserId();
            }

            @Override
            public String getNickname() {
                return member.getNickname();
            }

            @Override
            public String getProfileUrl() {
                return member.getProfileUrl();
            }
        };
    }

    private void initHeaderOnCreated() {
        Bundle args = this.getArguments();
        String headerTitle = this.getString(R.string.sb_text_header_member_list);
        boolean useHeader = false;
        boolean useHeaderLeftButton = true;
        boolean useHeaderRightButton = true;
        int headerLeftButtonIconResId = R.drawable.icon_arrow_left;
        int headerRightButtonIconResId = R.drawable.icon_plus;
        if (args != null) {
            headerTitle = args.getString("KEY_HEADER_TITLE", this.getString(R.string.sb_text_header_member_list));
            useHeader = args.getBoolean("KEY_USE_HEADER", false);
            useHeaderLeftButton = args.getBoolean("KEY_USE_HEADER_LEFT_BUTTON", true);
            useHeaderRightButton = args.getBoolean("KEY_USE_HEADER_RIGHT_BUTTON", true);
            headerLeftButtonIconResId = args.getInt("KEY_HEADER_LEFT_BUTTON_ICON_RES_ID", R.drawable.icon_arrow_left);
            headerRightButtonIconResId = args.getInt("KEY_HEADER_RIGHT_BUTTON_ICON_RES_ID", R.drawable.icon_plus);
        }
        this.binding.abvMemberList.setVisibility(useHeader ? 0 : 8);
        this.binding.abvMemberList.getTitleTextView().setText((CharSequence)headerTitle);
        this.binding.abvMemberList.getLeftImageButton().setVisibility(useHeaderLeftButton ? 0 : 8);
        this.binding.abvMemberList.getRightImageButton().setVisibility(useHeaderRightButton ? 0 : 8);
        this.binding.abvMemberList.getLeftImageButton().setImageResource(headerLeftButtonIconResId);
        this.binding.abvMemberList.getRightImageButton().setImageResource(headerRightButtonIconResId);
        this.binding.abvMemberList.getLeftImageButton().setOnClickListener(v -> {
            if (this.getActivity() != null) {
                this.getActivity().finish();
            }
        });
    }

    private void initHeaderOnReady(GroupChannel channel) {
        if (this.headerLeftButtonListener != null) {
            this.binding.abvMemberList.getLeftImageButton().setOnClickListener(this.headerLeftButtonListener);
        }
        if (this.headerRightButtonListener != null) {
            this.binding.abvMemberList.getRightImageButton().setOnClickListener(this.headerRightButtonListener);
        } else {
            this.binding.abvMemberList.getRightImageButton().setOnClickListener(v -> {
                if (this.getContext() != null) {
                    this.startActivity(InviteChannelActivity.newIntent(this.getContext(), channel.getUrl()));
                }
            });
        }
    }

    private void initMemberList() {
        if (this.adapter == null) {
            this.adapter = new UserListAdapter(1);
        }
        if (this.itemClickListener != null) {
            this.adapter.setOnItemClickListener(this.itemClickListener);
        }
        if (this.itemLongClickListener != null) {
            this.adapter.setOnItemLongClickListener(this.itemLongClickListener);
        }
        this.adapter.setUserListViewModel(this.viewModel);
        this.binding.rvMemberList.setAdapter(this.adapter);
        this.binding.rvMemberList.setHasFixedSize(true);
        this.binding.rvMemberList.setPager(this.viewModel);
        this.binding.rvMemberList.setThreshold(5);
        this.viewModel.getUserList().observe((LifecycleOwner)this, users -> {
            Logger.d("++ observing result users size : %s", users.size());
            this.binding.rvMemberList.setRefreshing(false);
            this.adapter.setItems((List<UserInfo>)users);
        });
    }

    @Override
    public void onReady(User user, ReadyStatus status) {
        Bundle args = this.getArguments();
        String channelUrl = null;
        if (args != null) {
            channelUrl = args.getString("KEY_CHANNEL_URL");
        }
        if (channelUrl != null) {
            GroupChannel.getChannel((String)channelUrl, (channel, e) -> {
                if (e != null) {
                    this.toastError(R.string.sb_text_error_get_channel);
                    Logger.e((Throwable)e);
                    return;
                }
                if (this.isActive()) {
                    this.initPage(channel);
                }
            });
        } else {
            this.toastError(R.string.sb_text_error_get_channel);
        }
    }

    private void setHeaderLeftButtonListener(View.OnClickListener listener) {
        this.headerLeftButtonListener = listener;
    }

    private void setHeaderRightButtonListener(View.OnClickListener listener) {
        this.headerRightButtonListener = listener;
    }

    private void setUserListAdapter(UserListAdapter adapter) {
        this.adapter = adapter;
    }

    private void setItemClickListener(OnItemClickListener<UserInfo> itemClickListener) {
        this.itemClickListener = itemClickListener;
    }

    private void setItemLongClickListener(OnItemLongClickListener<UserInfo> itemLongClickListener) {
        this.itemLongClickListener = itemLongClickListener;
    }

    public static class Builder {
        private Bundle bundle = new Bundle();
        private View.OnClickListener headerLeftButtonListener;
        private View.OnClickListener headerRightButtonListener;
        private UserListAdapter adapter;
        private OnItemClickListener<UserInfo> itemClickListener;
        private OnItemLongClickListener<UserInfo> itemLongClickListener;

        public Builder(@NonNull String channelUrl) {
            this(channelUrl, SendBirdUIKit.getDefaultThemeMode());
        }

        public Builder(@NonNull String channelUrl, SendBirdUIKit.ThemeMode themeMode) {
            this.bundle.putInt("KEY_THEME_RES_ID", themeMode.getResId());
            this.bundle.putString("KEY_CHANNEL_URL", channelUrl);
        }

        public Builder(@NonNull String channelUrl, @StyleRes int customThemeResId) {
            this.bundle.putInt("KEY_THEME_RES_ID", customThemeResId);
            this.bundle.putString("KEY_CHANNEL_URL", channelUrl);
        }

        public Builder setHeaderTitle(String title) {
            this.bundle.putString("KEY_HEADER_TITLE", title);
            return this;
        }

        public Builder setUseHeader(boolean useHeader) {
            this.bundle.putBoolean("KEY_USE_HEADER", useHeader);
            return this;
        }

        public Builder setUseHeaderRightButton(boolean useHeaderRightButton) {
            this.bundle.putBoolean("KEY_USE_HEADER_RIGHT_BUTTON", useHeaderRightButton);
            return this;
        }

        public Builder setUseHeaderLeftButton(boolean useHeaderLeftButton) {
            this.bundle.putBoolean("KEY_USE_HEADER_LEFT_BUTTON", useHeaderLeftButton);
            return this;
        }

        public Builder setHeaderLeftButtonIconResId(@DrawableRes int resId) {
            this.bundle.putInt("KEY_HEADER_LEFT_BUTTON_ICON_RES_ID", resId);
            return this;
        }

        public Builder setHeaderRightButtonIconResId(@DrawableRes int resId) {
            this.bundle.putInt("KEY_HEADER_RIGHT_BUTTON_ICON_RES_ID", resId);
            return this;
        }

        public Builder setHeaderLeftButtonListener(View.OnClickListener listener) {
            this.headerLeftButtonListener = listener;
            return this;
        }

        public Builder setHeaderRightButtonListener(View.OnClickListener listener) {
            this.headerRightButtonListener = listener;
            return this;
        }

        public Builder setUserListAdapter(UserListAdapter adapter) {
            this.adapter = adapter;
            return this;
        }

        public Builder setItemClickListener(OnItemClickListener<UserInfo> itemClickListener) {
            this.itemClickListener = itemClickListener;
            return this;
        }

        public Builder setItemLongClickListener(OnItemLongClickListener<UserInfo> itemLongClickListener) {
            this.itemLongClickListener = itemLongClickListener;
            return this;
        }

        public MemberListFragment build() {
            MemberListFragment fragment = new MemberListFragment();
            fragment.setArguments(this.bundle);
            fragment.setHeaderLeftButtonListener(this.headerLeftButtonListener);
            fragment.setHeaderRightButtonListener(this.headerRightButtonListener);
            fragment.setItemClickListener(this.itemClickListener);
            fragment.setItemLongClickListener(this.itemLongClickListener);
            fragment.setUserListAdapter(this.adapter);
            return fragment;
        }
    }
}

