/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.syncmanager;

import android.util.Log;
import com.sendbird.android.BaseChannel;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.SendBird;
import com.sendbird.android.SendBirdException;
import com.sendbird.syncmanager.FailedMessageDispatcher;
import com.sendbird.syncmanager.FailedMessageEventActionReason;
import com.sendbird.syncmanager.Logger;
import com.sendbird.syncmanager.MessageChunk;
import com.sendbird.syncmanager.MessageChunkContainer;
import com.sendbird.syncmanager.MessageCollection;
import com.sendbird.syncmanager.MessageContainer;
import com.sendbird.syncmanager.MessageSynchronizer;
import com.sendbird.syncmanager.SyncManagerError;
import com.sendbird.syncmanager.handler.CompletionHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;

class MessageManager {
    private static final String TAG = MessageManager.class.getSimpleName();
    private static MessageManager sInstance;
    private String mIdentifier;
    private List<MessageCollection> mMessageCollections = new ArrayList<MessageCollection>();
    private MessageContainer mMessageContainer;
    private MessageChunkContainer mMessageChunkContainer;
    private SendBird.ChannelHandler mChannelHandler = new SendBird.ChannelHandler(){

        public void onMessageReceived(BaseChannel channel, BaseMessage message) {
            Logger.d(TAG, "onMessageReceived, channelUrl = " + this.getChannelUrl(channel) + ", messageId = " + this.getMessageId(message));
            MessageManager.this.appendSucceededMessages(this.getChannelUrl(channel), Collections.singletonList(message));
        }

        public void onMessageDeleted(BaseChannel channel, long msgId) {
            Logger.d(TAG, "onMessageDeleted, channelUrl = " + this.getChannelUrl(channel) + ", messageId = " + msgId);
            if (channel != null) {
                MessageManager.this.deleteSucceededMessages(channel.getUrl(), Collections.singletonList(msgId));
            }
        }

        public void onMessageUpdated(BaseChannel channel, BaseMessage message) {
            Logger.d(TAG, "onMessageUpdated, channelUrl = " + this.getChannelUrl(channel) + ", messageId = " + this.getMessageId(message));
            MessageManager.this.updateSucceededMessages(this.getChannelUrl(channel), true, Collections.singletonList(message));
        }

        private String getChannelUrl(BaseChannel channel) {
            return channel == null ? "null" : channel.getUrl();
        }

        private String getMessageId(BaseMessage message) {
            return message == null ? "null" : String.valueOf(message.getMessageId());
        }
    };

    private MessageManager() {
        this.mIdentifier = UUID.randomUUID().toString();
        this.mMessageContainer = new MessageContainer();
        this.mMessageChunkContainer = new MessageChunkContainer();
        SendBird.addChannelHandler((String)this.mIdentifier, (SendBird.ChannelHandler)this.mChannelHandler);
    }

    public static MessageManager getInstance() {
        if (sInstance == null) {
            throw new RuntimeException((Throwable)SyncManagerError.getException(810100));
        }
        return sInstance;
    }

    static void init() {
        if (sInstance == null) {
            sInstance = new MessageManager();
        }
    }

    static void deinit() {
        sInstance = null;
    }

    void setup(final CompletionHandler handler) {
        this.mMessageContainer.setup(new CompletionHandler(){

            @Override
            public void onCompleted(SendBirdException e) {
                MessageManager.this.mMessageChunkContainer.setup(new CompletionHandler(){

                    @Override
                    public void onCompleted(SendBirdException e) {
                        if (handler != null) {
                            handler.onCompleted(e);
                        }
                    }
                });
            }
        });
    }

    void addMessageCollection(MessageCollection collection) {
        MessageManager.getInstance().mMessageCollections.add(collection);
    }

    void removeMessageCollection(MessageCollection collection) {
        MessageManager.getInstance().mMessageCollections.remove(collection);
    }

    void broadcastFailedMessagesInserted(String channelUrl, List<BaseMessage> messages) {
        if (messages.size() == 0) {
            return;
        }
        for (MessageCollection collection : MessageManager.getInstance().getMessageCollections()) {
            if (!collection.getChannelUrl().equals(channelUrl)) continue;
            collection.onFailedMessagesInserted(messages);
        }
    }

    void broadcastFailedMessagesUpdated(String channelUrl, List<BaseMessage> messages, FailedMessageEventActionReason reason) {
        if (messages.size() == 0) {
            return;
        }
        for (MessageCollection collection : MessageManager.getInstance().getMessageCollections()) {
            if (!collection.getChannelUrl().equals(channelUrl)) continue;
            collection.onFailedMessagesUpdated(messages, reason);
        }
    }

    void broadcastFailedMessagesDeleted(String channelUrl, List<String> requestIds, FailedMessageEventActionReason reason) {
        if (requestIds == null || requestIds.size() == 0) {
            return;
        }
        for (MessageCollection collection : MessageManager.getInstance().getMessageCollections()) {
            if (!channelUrl.equals(collection.getChannelUrl())) continue;
            collection.onFailedMessagesDeleted(requestIds, reason);
        }
    }

    void appendSucceededMessages(final String channelUrl, final List<BaseMessage> messages) {
        MessageManager.getInstance().getMessageContainer().upsertSucceededMessages(messages, true, new MessageContainer.UpsertMessageHandler(){

            @Override
            public void onResult(List<BaseMessage> insertedMessages, List<BaseMessage> updatedMessages, SendBirdException e) {
                if (e == null) {
                    for (MessageCollection collection : MessageManager.getInstance().getMessageCollections()) {
                        if (!collection.getChannelUrl().equals(channelUrl)) continue;
                        collection.onSucceededMessagesInserted(messages);
                    }
                }
            }
        });
    }

    void updateSucceededMessages(final String channelUrl, boolean isVisible, final List<BaseMessage> messages) {
        MessageManager.getInstance().getMessageContainer().upsertSucceededMessages(messages, isVisible, new MessageContainer.UpsertMessageHandler(){

            @Override
            public void onResult(List<BaseMessage> insertedMessages, List<BaseMessage> updatedMessages, SendBirdException e) {
                if (e == null) {
                    for (MessageCollection collection : MessageManager.getInstance().getMessageCollections()) {
                        if (!collection.getChannelUrl().equals(channelUrl)) continue;
                        collection.onSucceededMessagesUpdated(messages);
                    }
                }
            }
        });
    }

    void deleteSucceededMessages(final String channelUrl, final List<Long> messageIds) {
        MessageManager.getInstance().getMessageContainer().removeSucceededMessages(messageIds, new MessageContainer.DeleteMessageHandler(){

            @Override
            public void onResult(List<BaseMessage> deletedMessages, SendBirdException e) {
                if (e == null && deletedMessages != null) {
                    for (BaseMessage deletedMessage : deletedMessages) {
                        List<MessageChunk> chunkList = MessageManager.this.mMessageChunkContainer.getChunksContainingMessageAsEdge(deletedMessage);
                        if (chunkList == null || chunkList.size() == 0) continue;
                        final CountDownLatch lock = new CountDownLatch(chunkList.size());
                        final CompletionHandler handler = new CompletionHandler(){

                            @Override
                            public void onCompleted(SendBirdException e) {
                                lock.countDown();
                            }
                        };
                        for (final MessageChunk chunk : chunkList) {
                            MessageManager.this.mMessageChunkContainer.getPreviousMessageInChunk(chunk, new MessageContainer.GetSingleMessageHandler(){

                                @Override
                                public void onResult(BaseMessage message, SendBirdException e) {
                                    if (e != null) {
                                        lock.countDown();
                                        return;
                                    }
                                    if (message != null) {
                                        chunk.setEndAt(message.getCreatedAt());
                                        MessageManager.this.mMessageChunkContainer.upsertChunk(chunk, handler);
                                    } else {
                                        MessageManager.this.mMessageChunkContainer.deleteChunks(Arrays.asList(chunk), handler);
                                    }
                                }
                            });
                        }
                        try {
                            lock.await();
                        }
                        catch (InterruptedException e1) {
                            Logger.e(TAG, Log.getStackTraceString((Throwable)e1));
                        }
                    }
                    for (MessageCollection collection : MessageManager.getInstance().getMessageCollections()) {
                        if (!channelUrl.equals(collection.getChannelUrl())) continue;
                        collection.onSucceededMessagesDeleted(messageIds);
                    }
                }
            }
        });
    }

    void broadcastChannelUpdated(List<GroupChannel> updatedChannels) {
        Logger.d(TAG, "broadcastChannelUpdated.");
        if (updatedChannels == null || updatedChannels.isEmpty()) {
            return;
        }
        for (GroupChannel updatedChannel : updatedChannels) {
            for (MessageCollection collection : this.getMessageCollections()) {
                if (!collection.getChannelUrl().equals(updatedChannel.getUrl())) continue;
                collection.onChannelUpdated(updatedChannel);
            }
        }
    }

    void broadcastChannelRemoved(List<String> removedChannelUrls) {
        Logger.d(TAG, "broadcastChannelRemoved.");
        if (removedChannelUrls == null || removedChannelUrls.isEmpty()) {
            return;
        }
        for (final String deletedChannelUrl : removedChannelUrls) {
            MessageManager.getInstance().getMessageContainer().removeAllMessagesInChannel(deletedChannelUrl, new CompletionHandler(){

                @Override
                public void onCompleted(SendBirdException e) {
                    for (MessageCollection collection : MessageManager.this.getMessageCollections()) {
                        if (!collection.getChannelUrl().equals(deletedChannelUrl)) continue;
                        collection.onChannelRemoved();
                    }
                }
            });
        }
    }

    void resumeSync() {
        FailedMessageDispatcher.getInstance().startFailedMessageRetentionChecker();
        List<MessageCollection> collections = this.getMessageCollections();
        Logger.e(TAG, "resumeSync. count : " + collections.size());
        final CountDownLatch counter = new CountDownLatch(collections.size());
        for (MessageCollection collection : collections) {
            collection.resumeSync(true, new MessageSynchronizer.MessageBackgroundSyncEventListener(){

                @Override
                public void onSynced(SendBirdException e) {
                    counter.countDown();
                    Logger.e(TAG, "resumeSync onSynced. count : " + counter.getCount());
                    if (counter.getCount() <= 0L) {
                        FailedMessageDispatcher.getInstance().resumeAllQueues();
                    }
                }
            });
        }
    }

    void pauseSync() {
        FailedMessageDispatcher.getInstance().pause();
        for (MessageCollection collection : this.getMessageCollections()) {
            collection.pauseSync();
        }
    }

    MessageContainer getMessageContainer() {
        return this.mMessageContainer;
    }

    MessageChunkContainer getMessageChunkContainer() {
        return this.mMessageChunkContainer;
    }

    private List<MessageCollection> getMessageCollections() {
        return new ArrayList<MessageCollection>(this.mMessageCollections);
    }

    public void clearCache() {
        Iterator<MessageCollection> iterator = this.mMessageCollections.iterator();
        while (iterator.hasNext()) {
            MessageCollection messageCollection = iterator.next();
            iterator.remove();
            messageCollection.remove();
        }
        this.mMessageChunkContainer.clear();
    }
}

