/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.syncmanager;

import com.sendbird.android.BaseChannel;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.SendBird;
import com.sendbird.android.SendBirdException;
import com.sendbird.android.User;
import com.sendbird.syncmanager.ChannelChangeLogSync;
import com.sendbird.syncmanager.ChannelCollection;
import com.sendbird.syncmanager.ChannelContainer;
import com.sendbird.syncmanager.ChannelSynchronizer;
import com.sendbird.syncmanager.Logger;
import com.sendbird.syncmanager.MessageManager;
import com.sendbird.syncmanager.SyncManagerError;
import com.sendbird.syncmanager.handler.CompletionHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;

class ChannelManager {
    private static final String TAG = ChannelManager.class.getSimpleName();
    private static ChannelManager sInstance;
    private String mIdentifier;
    private List<ChannelCollection> mCollections;
    private ChannelContainer mContainer;
    private SendBird.ChannelHandler mChannelHandler = new SendBird.ChannelHandler(){

        public void onMessageReceived(BaseChannel channel, BaseMessage message) {
            Logger.d(TAG, "onMessageReceived, channel url = " + this.getChannelUrl(channel) + ", messageId = " + this.getMessageId(message));
        }

        public void onReadReceiptUpdated(GroupChannel channel) {
            Logger.d(TAG, "onReadReceiptUpdated, channel url = " + this.getChannelUrl((BaseChannel)channel));
            ChannelManager.getInstance().upsertChannel(channel);
        }

        public void onUserReceivedInvitation(GroupChannel channel, User inviter, List<User> invitees) {
            Logger.d(TAG, "onUserReceivedInvitation, channel = " + this.getChannelUrl((BaseChannel)channel) + ", inviter = " + this.getUserId(inviter) + ", I am = " + this.getUserId(SendBird.getCurrentUser()));
            ChannelManager.getInstance().upsertChannel(channel);
        }

        public void onUserDeclinedInvitation(GroupChannel channel, User inviter, User invitee) {
            Logger.d(TAG, "onUserDeclinedInvitation, channel = " + this.getChannelUrl((BaseChannel)channel) + ", inviter = " + this.getUserId(inviter) + ", invitee = " + this.getUserId(invitee));
            if (SendBird.getCurrentUser() != null && invitee.getUserId().equals(SendBird.getCurrentUser().getUserId()) && channel != null) {
                ChannelManager.getInstance().removeChannelUrl(channel.getUrl());
            } else {
                ChannelManager.getInstance().upsertChannel(channel);
            }
        }

        public void onUserJoined(GroupChannel channel, User user) {
            Logger.d(TAG, "onUserJoined, channel = " + this.getChannelUrl((BaseChannel)channel) + ", user = " + this.getUserId(user));
            ChannelManager.getInstance().upsertChannel(channel);
        }

        public void onUserLeft(GroupChannel channel, User user) {
            Logger.d(TAG, "onUserLeft, channel = " + this.getChannelUrl((BaseChannel)channel) + ", user = " + this.getUserId(user));
            if (SendBird.getCurrentUser() != null && user.getUserId().equals(SendBird.getCurrentUser().getUserId()) && channel != null) {
                ChannelManager.getInstance().removeChannelUrl(channel.getUrl());
            } else {
                ChannelManager.getInstance().upsertChannel(channel);
            }
        }

        public void onUserMuted(BaseChannel channel, User user) {
            Logger.d(TAG, "onUserMuted, channel = " + this.getChannelUrl(channel) + ", user = " + this.getUserId(user));
            if (channel != null && channel.isGroupChannel()) {
                ChannelManager.getInstance().upsertChannel((GroupChannel)channel);
            }
        }

        public void onUserUnmuted(BaseChannel channel, User user) {
            Logger.d(TAG, "onUserUnmuted, channel = " + this.getChannelUrl(channel) + ", user = " + this.getUserId(user));
            if (channel != null && channel.isGroupChannel()) {
                ChannelManager.getInstance().upsertChannel((GroupChannel)channel);
            }
        }

        public void onUserBanned(BaseChannel channel, User user) {
            Logger.d(TAG, "onUserBanned, channel = " + this.getChannelUrl(channel) + ", user = " + this.getUserId(user));
            if (channel != null && channel.isGroupChannel()) {
                if (SendBird.getCurrentUser() != null && user.getUserId().equals(SendBird.getCurrentUser().getUserId())) {
                    ChannelManager.getInstance().removeChannelUrl(channel.getUrl());
                } else {
                    ChannelManager.getInstance().upsertChannel((GroupChannel)channel);
                }
            }
        }

        public void onUserUnbanned(BaseChannel channel, User user) {
            Logger.d(TAG, "onUserUnbanned, channel = " + this.getChannelUrl(channel) + ", user = " + this.getUserId(user));
            if (channel != null && channel.isGroupChannel()) {
                ChannelManager.getInstance().upsertChannel((GroupChannel)channel);
            }
        }

        public void onChannelFrozen(BaseChannel channel) {
            Logger.d(TAG, "onChannelFrozen, channel = " + this.getChannelUrl(channel));
            if (channel != null && channel.isGroupChannel()) {
                ChannelManager.getInstance().upsertChannel((GroupChannel)channel);
            }
        }

        public void onChannelUnfrozen(BaseChannel channel) {
            Logger.d(TAG, "onChannelUnfrozen, channel = " + this.getChannelUrl(channel));
            if (channel != null && channel.isGroupChannel()) {
                ChannelManager.getInstance().upsertChannel((GroupChannel)channel);
            }
        }

        public void onChannelChanged(BaseChannel channel) {
            Logger.d(TAG, "onChannelChanged, channel = " + this.getChannelUrl(channel));
            if (channel != null && channel.isGroupChannel()) {
                ChannelManager.getInstance().upsertChannel((GroupChannel)channel);
            }
        }

        public void onChannelDeleted(String channelUrl, BaseChannel.ChannelType channelType) {
            Logger.d(TAG, "onChannelDeleted, channelUrl = " + channelUrl + ", channelType = " + channelType);
            ChannelManager.getInstance().removeChannelUrl(channelUrl);
        }

        public void onMetaDataCreated(BaseChannel channel, Map<String, String> metaDataMap) {
            Logger.d(TAG, "onMetaDataCreated, channelUrl = " + this.getChannelUrl(channel));
            if (channel != null && channel.isGroupChannel()) {
                ChannelManager.getInstance().upsertChannel((GroupChannel)channel);
            }
        }

        public void onMetaDataUpdated(BaseChannel channel, Map<String, String> metaDataMap) {
            Logger.d(TAG, "onMetaDataUpdated, channelUrl = " + this.getChannelUrl(channel));
            if (channel != null && channel.isGroupChannel()) {
                ChannelManager.getInstance().upsertChannel((GroupChannel)channel);
            }
        }

        public void onMetaDataDeleted(BaseChannel channel, List<String> keys) {
            Logger.d(TAG, "onMetaDataDeleted, channelUrl = " + this.getChannelUrl(channel));
            if (channel != null && channel.isGroupChannel()) {
                ChannelManager.getInstance().upsertChannel((GroupChannel)channel);
            }
        }

        public void onMetaCountersCreated(BaseChannel channel, Map<String, Integer> metaCounterMap) {
            Logger.d(TAG, "onMetaCountersCreated, channelUrl = " + this.getChannelUrl(channel));
            if (channel != null && channel.isGroupChannel()) {
                ChannelManager.getInstance().upsertChannel((GroupChannel)channel);
            }
        }

        public void onMetaCountersUpdated(BaseChannel channel, Map<String, Integer> metaCounterMap) {
            Logger.d(TAG, "onMetaCountersUpdated, channelUrl = " + this.getChannelUrl(channel));
            if (channel != null && channel.isGroupChannel()) {
                ChannelManager.getInstance().upsertChannel((GroupChannel)channel);
            }
        }

        public void onMetaCountersDeleted(BaseChannel channel, List<String> keys) {
            Logger.d(TAG, "onMetaCountersDeleted, channelUrl = " + this.getChannelUrl(channel));
            if (channel != null && channel.isGroupChannel()) {
                ChannelManager.getInstance().upsertChannel((GroupChannel)channel);
            }
        }

        public void onChannelHidden(GroupChannel channel) {
            Logger.d(TAG, "onChannelHidden, channelUrl = " + this.getChannelUrl((BaseChannel)channel));
            if (channel != null && channel.isGroupChannel()) {
                ChannelManager.getInstance().upsertChannel(channel);
            }
        }

        public void onTypingStatusUpdated(GroupChannel channel) {
            Logger.d(TAG, "onTypingStatusUpdated, channelUrl = " + this.getChannelUrl((BaseChannel)channel));
        }

        private String getChannelUrl(BaseChannel channel) {
            return channel == null ? "null" : channel.getUrl();
        }

        private String getUserId(User user) {
            return user == null ? "null" : user.getUserId();
        }

        private String getMessageId(BaseMessage message) {
            return message == null ? "null" : String.valueOf(message.getMessageId());
        }
    };

    private ChannelManager() {
        this.mIdentifier = UUID.randomUUID().toString();
        this.mCollections = new ArrayList<ChannelCollection>();
        this.mContainer = new ChannelContainer();
        SendBird.addChannelHandler((String)this.mIdentifier, (SendBird.ChannelHandler)this.mChannelHandler);
    }

    void setup(CompletionHandler handler) {
        this.mContainer.setup(handler);
        ChannelSynchronizer.getInstance().clear();
        ChannelChangeLogSync.getInstance().clear();
    }

    static void deinit() {
        sInstance = null;
    }

    static ChannelManager getInstance() {
        if (sInstance == null) {
            throw new RuntimeException((Throwable)SyncManagerError.getException(810100));
        }
        return sInstance;
    }

    static void init() {
        if (sInstance == null) {
            sInstance = new ChannelManager();
        }
    }

    void addChannelCollection(ChannelCollection collection) {
        ChannelManager.getInstance().mCollections.add(collection);
    }

    void removeChannelCollection(ChannelCollection collection) {
        ChannelManager.getInstance().mCollections.remove(collection);
    }

    void resumeSync() {
        List<ChannelCollection> collections = this.getCollections();
        for (ChannelCollection collection : collections) {
            collection.resumeSync();
        }
        ChannelChangeLogSync.getInstance().start(true);
        ChannelSynchronizer.getInstance().resumeSync();
    }

    void pauseSync() {
        List<ChannelCollection> collections = this.getCollections();
        for (ChannelCollection collection : collections) {
            collection.pauseSync();
        }
        ChannelChangeLogSync.getInstance().stop();
        ChannelSynchronizer.getInstance().pauseSync();
    }

    ChannelContainer getContainer() {
        return this.mContainer;
    }

    private void upsertChannel(final GroupChannel channel) {
        ArrayList<GroupChannel> channels = new ArrayList<GroupChannel>();
        channels.add(channel);
        ChannelManager.getInstance().getContainer().upsertChannels(channels, new ChannelContainer.UpdateChannelHandler(){

            @Override
            public void onResult(List<GroupChannel> updatedChannels, SendBirdException e) {
                if (e != null) {
                    e.printStackTrace();
                    return;
                }
                if (updatedChannels == null || updatedChannels.size() == 0) {
                    return;
                }
                MessageManager.getInstance().updateChannel(channel);
                List collections = ChannelManager.this.getCollections();
                for (ChannelCollection collection : collections) {
                    if (collection == null) continue;
                    collection.upsertChannel(channel);
                }
            }
        });
    }

    private void removeChannelUrl(final String channelUrl) {
        final ArrayList<String> channelUrls = new ArrayList<String>();
        channelUrls.add(channelUrl);
        ChannelManager.getInstance().getContainer().removeChannelUrl(channelUrl, new CompletionHandler(){

            @Override
            public void onCompleted(SendBirdException e) {
                if (e != null) {
                    e.printStackTrace();
                    return;
                }
                MessageManager.getInstance().removeChannel(channelUrl);
                List collections = ChannelManager.this.getCollections();
                for (ChannelCollection collection : collections) {
                    collection.removeChannelUrls(channelUrls);
                }
            }
        });
    }

    private List<ChannelCollection> getCollections() {
        return new ArrayList<ChannelCollection>(this.mCollections);
    }

    void clearCache() {
        this.mContainer.clear();
        this.mCollections.clear();
    }

    void clearCache(String userId) {
        this.mContainer.clear(userId);
        this.mCollections.clear();
    }
}

